/* by BAILOPAN and Freecode
 *
 * csdm_mod.sma
 * Allows for Counter-Strike to be played as DeathMatch.
 *
 * This was designed by BAILOPAN and Freecode
 * Freecode's code is demarked
 * Original ideas by isbunk - who also gave us most original bug reports.
 * (C)1995-2003 The TCW Organization and David "BAILOPAN" Anderson
 * Creation: 01-02-2004 Last Edit: 01-06-2004
 *
 * http://www.tcwonline.org/ - BAILOPAN
 * http://www.drugzclan.com/ - Freecode
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *  Give credit where due.
 *  Share the source - it sets you free
 *  http://www.opensource.org/
 *  http://www.gnu.org/
 */
 
//Tampering with the author and name lines will violate copyrights
//This is my third complete plugin.  This is probably Freecode's 500th.
new PLUGINNAME[] = "CSDM Plugin"
new VERSION[] = "1.00-beta"
new BUILD_VERSION[] = "148"
new AUTHORS[] = "BAILOPAN,Freecode"

#pragma dynamic 131072
#include <amxmod>
#include <amxmisc>
#include <Vexd_Utilities>

#define TE_BEAMTORUS 19
#define MAX_SPAWNS 32
#define MAX_ENTS 200
#define S_ENTS 9
#define MAX_DROP 64
#define MAX_TEMPENTS 300
#define MAX_TASKS 200
#define MAXMENUPOS 34

#define PISTOL_AMMO 1
#define SHOTGUN_AMMO 2
#define SMG_AMMO 3
#define RIFLE_AMMO 4 

new StripEnts[S_ENTS][] = {"info_hostage_rescue", "hostage_entity", "info_bomb_target", "func_bomb_target", "func_hostage_rescue", "func_buyzone", "info_vip_start", "func_vip_safetyzone", "item_longjump"}
new SPAWN[MAX_SPAWNS][3]		//For spawn points
new Float:SpnVec[MAX_SPAWNS][3]	//
new SpnTeam[MAX_SPAWNS]			//
new SpawnEnts[MAX_SPAWNS]		//
new SPAWNS_ENABLED				//
new SPAWNS						//
new mapFile[48]					//
new EntList[MAX_ENTS][24]		//For entities
new EntVecs[MAX_ENTS][3]		//
new EntId[MAX_ENTS]				//
new EntCount					//
new EntFile[48]					//
new Origins[32][3]				//Track origins
new bool:Swep[32] = false		//Menus
new g_MenuPos[32] 				//
new g_LastWep[32][2]			//
new bool:g_getArmor[32]			//
new bool:g_getGrens[32]			//
new bool:ShowMenu[32] = true	//
new bool:isSpawning[32]			//Spawning
new bool:isRespawn[32]			//
new DropId[MAX_DROP]			//Track dropped weapons
new DropTask[MAX_DROP]			//Track dropped weapon remove tasks
new Tasks[MAX_TASKS]			//Track tasks
new PackId[MAX_DROP]			//drop_pack tempents
new PackAmmo[MAX_DROP][4]		//0=pistol, 1=shotgun, 2=smg, 3=rifle
new PackGren[MAX_DROP][3]		//0=fb, 1=sg, 2=he
new TempEnt[MAX_TEMPENTS]		//This is set up to track tempents
new Entities					//points to current entid
new dbug = 0
new g_Aliases[MAXMENUPOS][] = {"usp","glock","deagle","p228","elites","fn57","m3","xm1014","mp5","tmp","p90","mac10","ump45","ak47","galil","famas","sg552","m4a1","aug","scout","awp","g3sg1","sg550","m249","vest","vesthelm","flash","hegren","sgren","defuser","nvgs","shield","primammo","secammo"} 
new g_Aliases2[MAXMENUPOS][] = {"km45","9x19mm","nighthawk","228compact","elites","fiveseven","12gauge","autoshotgun","smg","mp","c90","mac10","ump45","cv47","defender","clarion","krieg552","m4a1","bullpup","scout","magnum","d3au1","krieg550","m249","vest","vesthelm","flash","hegren","sgren","defuser","nvgs","shield","primammo","secammo"}

public plugin_init()
{
	register_plugin(PLUGINNAME, VERSION, AUTHORS)
	register_menucmd(register_menuid("CSDM: Equip"),1023,"EquipChoice")
	register_menucmd(register_menuid("CSDM: Primary Weapon"),1023,"PrimaryWeapon")
	register_menucmd(register_menuid("CSDM: Secondary Weapon"),1023,"SecondWeapon")
	register_menucmd(register_menuid("CSDM: Armor"),1023,"ArmorChoice")
	register_menucmd(register_menuid("CSDM: Grenades"),1023,"GrenChoice")
	register_concmd("csdm_enable", "csdm_onoff", ADMIN_LEVEL_C, "Turn CSDM on or off.")
	register_concmd("csdm_version", "csdm_version", 0, "Show CSDM Version.")
	register_concmd("csdm_setspawn", "csdm_setspawn", ADMIN_LEVEL_D, "Create a CSDM spawn point.")
	register_concmd("csdm_setspawnv", "csdm_setspawnv", ADMIN_LEVEL_D, "Create a CSDM spawn point with angle.")
	register_concmd("csdm_delspawn", "csdm_delspawn", ADMIN_LEVEL_D, "Delete a CSDM spawn point.")
	register_concmd("csdm_setent", "csdm_setent", ADMIN_LEVEL_D, "Add a CSDM entity.")
	register_concmd("csdm_delent", "csdm_delent", ADMIN_LEVEL_D, "Delete a CSDM entity.")
	register_concmd("csdm_ent", "csdm_ent", ADMIN_LEVEL_D, "Find the nearest entity.")
	register_concmd("csdm_viewspawns", "csdm_viewspawns", ADMIN_LEVEL_D, "View all spawns.")
	register_concmd("csdm_hidespawns", "csdm_hidespawns", ADMIN_LEVEL_D, "Hide all spawns.")
	register_concmd("csdm_rement", "csdm_rement", ADMIN_LEVEL_D, "Delete an entity.")
	register_concmd("csdm_origin", "csdm_origin", 0, "Find your origin for debugging bad spawns.")
	register_concmd("csdm_near", "csdm_near", ADMIN_LEVEL_D, "Shows you the number of the nearest spawn point.")
	register_concmd("csdm_set_amenu", "csdm_set_amenu", ADMIN_LEVEL_B, "Turns armor menus off/on.")
	register_concmd("csdm_set_gmenu", "csdm_set_gmenu", ADMIN_LEVEL_B, "Turns grenade menus off/on.")
	register_concmd("csdm_debug", "csdm_debug", ADMIN_LEVEL_D, "Turns debug mode off/on.")
	register_concmd("csdm_killall", "csdm_killall", ADMIN_LEVEL_B, "Turns kill everyone mode off/on.")
	register_concmd("csdm_look", "csdm_look", ADMIN_LEVEL_D, "Returns the entity id you are looking at.")
	register_clcmd("drop", "hook_drop")
	register_clcmd("respawn", "hook_respawn")
	register_clcmd("guns", "hook_guns")
	register_clcmd("give", "hook_give")
	register_clcmd("enable_menu", "hook_menu")
	register_clcmd("say guns", "hook_guns")
	register_clcmd("say respawn", "hook_respawn")
	register_clcmd("say menu", "hook_menu")
	register_clcmd("say enablemenu", "hook_menu")
	register_clcmd("say enable_menu", "hook_menu")
	// from AssKicr
	register_clcmd("buy", "hook_block")
	register_clcmd("buyammo1", "hook_block")
	register_clcmd("buyammo2", "hook_block")
	register_clcmd("buyequip", "hook_block")
	register_clcmd("radio1", "hook_block")
	register_clcmd("radio2", "hook_block")
	register_clcmd("radio3", "hook_block")
	register_clcmd("nightvision", "hook_block")
	register_clcmd("cl_setautobuy","hook_block") 
	register_clcmd("cl_autobuy","hook_block") 
	register_clcmd("cl_setrebuy","hook_block") 
	register_clcmd("cl_rebuy","hook_block") 
	//
	register_event("ResetHUD","hook_hud","be")
	register_event("DeathMsg", "hook_death", "a")
	register_event("CurWeapon","hook_changewp","be","1=1")
   	//from dm autopilot, which took from jailbreak
	register_menucmd(register_menuid("Terrorist_Select"), 1023, "hook_skin")
	register_menucmd(register_menuid("CT_Select"), 1023, "hook_skin")
	register_menucmd(-26,1023, "hook_skin")      // VGUI
	register_menucmd(-27,1023, "hook_skin")      // VGUI
	register_event("ShowMenu", "hook_team", "b", "4&Team_Select")
	register_event("VGUIMenu", "hook_team", "b", "1=2") 
	//
	register_cvar("csdm_active", "1")			//Enable CSDM?
	register_cvar("csdm_freeze_time", "4")		//Spawn protection time
	register_cvar("csdm_add_items", "0")		//0=Players choose weapons, 1=Players find weapons
	register_cvar("csdm_item_time", "20.0")		//Time until items respawn
	register_cvar("csdm_random_spawns", "1")	//Use random spawns or regular spawns?
	register_cvar("csdm_kill_all", "0")			//0=Use normal teams 1=Free for all
	register_cvar("csdm_drop_packs", "0")		//0=Drop packs on death 1=Drop weapons on death
	register_cvar("csdm_drop_weapons", "1")		//0=Players can't drop weapons
	register_cvar("csdm_delete_time", "20.0")	//How long until dropped weapons/packs disappear (0=perm)
												//packs will disappear in 30 seconds max, no perma
	register_cvar("csdm_allow_clguns", "0")		//Allows players to choose gun setups with "guns" command
	register_cvar("csdm_hold_many", "0")		//Allows players to hold more than one of each type.
	register_cvar("csdm_auto_equip", "0")		//Automatically equip players with armor
	register_cvar("csdm_auto_gren", "0")		//Automatically equip players with grenades
	register_cvar("csdm_spawn_spam", "0")		//gives respawning users a message
	register_cvar("csdm_enable_amenu", "1")		//*Enables armor menu
	register_cvar("csdm_enable_gmenu", "1")		//*Enables grenade menu
	register_cvar("csdm_allow_smoke", "1")		//Sets whether smoke grenades are allowed.
	register_cvar("csdm_spawn_protect", "1")	//Sets CSDM spawn mode
												//0=none
												//1=normal, stops when you move
												//2=high, stops after csdm_freeze_time
	
	set_task(2.0, "start_map")
	set_task(10.0, "check_players", 1210, "", 0, "b")
	
	return PLUGIN_CONTINUE
}

public check_players()
{
	new players[32], mPlayers
	get_players(players, mPlayers)
	if (dbug) {
		log_to_file("csdm-debug.txt", "check_players(): checking %d players", mPlayers)
	}
	for (new i=0; i<mPlayers; i++) {
		if (!is_user_alive(players[i])) {
			//oops!
			new Data[2]
			Data[0] = players[i]
			set_task(0.5, "quick_respawn", 0, Data, 2)
			isRespawn[players[i]] = true
			if (dbug) {
				log_to_file("csdm-debug.txt", "check_players(): found dead player %d", players[i])
			}
		}
	}
	
	return PLUGIN_CONTINUE
}

public client_connect(id)
{
	ShowMenu[id] = true
	isSpawning[id] = true
	g_LastWep[id][0] = 0
	g_LastWep[id][1] = 0
	g_getArmor[id] = false
	g_getGrens[id] = false
	isRespawn[id] = true
	
	return PLUGIN_CONTINUE
}

public client_putinserver(id)
{
	new data[2]
	
	data[0] = id
	set_task(10.0, "introduce", 0, data, 2)
	
	return PLUGIN_CONTINUE
}

public client_command(id){ 	//from AssKicr
	new arg[13] 
	if (read_argv(0, arg, 12) > 11) /* Longest buy command has 11 chars so if command is longer then don't care */ 
		return PLUGIN_CONTINUE 
	new a = 0 
	do {
		if (equal(g_Aliases[a], arg) || equal(g_Aliases2[a], arg)) { 
			return PLUGIN_HANDLED 
		}
	} while(++a < MAXMENUPOS)

	return PLUGIN_CONTINUE 
} 


public introduce(data[])
{
	new id = data[0]
	
	client_print(id, print_chat, "[CSDM] Welcome to Counter-Strike Deathmatch by BAILOPAN and Freecode!")	
	client_print(id, print_chat, "[CSDM] Visit www.amxmod.net forums for more information.")
	client_print(id, print_chat, "[CSDM] Console commands: ^"respawn^" to manually respawn.")
	if (get_cvar_num("csdm_allow_clguns")) {
		client_print(id, print_chat, "[CSDM] ^"guns^" to see a menu and ^"give <name>^" to get a gun.")
	}

	return PLUGIN_CONTINUE
}

public plugin_end()
{
	new i
	
	//remove all spawns
	for (i=0; i<SPAWNS; i++) {
		if (SpawnEnts[i] > 32) {
			rment(SpawnEnts[i])
		}
	}
	
	if (get_cvar_num("csdm_add_items")) {
	
		//kill all ents
		for (i=1; i<EntCount; i++) {
			if (EntId[i] > 32) {
				rment(EntId[i])
			}
		}
		
		//remove all packs
		for (i=1; i<MAX_DROP; i++) {
			destroyPack(i)
		}
	
		//remove all tempents
		for (i=1; i<MAX_TEMPENTS; i++) {
			destroyTempEnt(i)
		}
	
		//find everything else
		new tEnt = FindEntity(-1, "info_target")
		new class[32]
		while (tEnt > 0) {
			Entvars_Get_String(tEnt, EV_SZ_classname, class, 32)
			if (cwrap(class, "weapon") || cwrap(class, "csdm")
			|| cwrap(class, "drop_pack") || cwrap(class, "view_spawn")
			|| cwrap(class, "armor")) {
				rment(tEnt)
			}
			tEnt = FindEntity(tEnt, "info_target")
		}
	}
	
	return PLUGIN_CONTINUE
}

public start_map()
{	
	checkMod()
	readMapFile()
	setSpawns()
	cleanMap()
	readEntsFile()
	setEnts()
}

public plugin_precache()
{
	precache_model("models/w_medkit.mdl")
	precache_model("models/w_battery.mdl")
	precache_model("models/w_357ammobox.mdl")	//Pistol Ammo
	precache_model("models/w_shotbox.mdl")		//Shotgun Ammo
	precache_model("models/w_9mmclip.mdl")		//SMG Ammo
	precache_model("models/w_9mmarclip.mdl")	//Rifle Ammo
	precache_model("models/w_chainammo.mdl")	//Full ammo
	precache_model("models/w_suit.mdl")			//Suit
	precache_model("models/w_suitt.mdl")		//
	precache_model("models/w_weaponbox.mdl")	//Drop pack
	precache_model("models/w_assault.mdl")		//assaultsuit
	precache_model("models/w_longjump.mdl")		//lonjump - thanks asskicr
	precache_model("models/w_longjumpt.mdl")	//"
	precache_model("models/w_oxygen.mdl")
	precache_model("models/w_oxygent.mdl")
	precache_model("models/w_isotopebox.mdl")
	precache_model("models/w_isotopeboxt.mdl")
	precache_sound("items/smallmedkit1.wav")
	precache_sound("items/suitchargeok1.wav")
	precache_sound("items/ammopickup2.wav")
	
	return PLUGIN_CONTINUE
}

public csdm_near(id)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	new marker, dist=9999, cur
	new PVec[3]
	
	marker = -1
	get_user_origin(id, PVec)
	for (new i=0; i<SPAWNS; i++) {
		cur = get_distance(PVec, SPAWN[i])
		if (cur < dist) {
			dist = cur
			marker = i
		}
	}
	
	if (marker != -1) {
		client_print(id, print_console, "[CSDM] The nearest spawn to you is number %d", marker+1)
	} else {
		client_print(id, print_console, "[CSDM] No spawns found.")
	}
	
	return PLUGIN_HANDLED
}

public csdm_killall(id)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_B)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	if (get_cvar_num("csdm_kill_all")) {
		client_print(id, print_console, "[CSDM] Free for all mode is now disabled.")
		set_cvar_num("csdm_kill_all", 0)
		checkMod()
		return PLUGIN_HANDLED
	} else {
		client_print(id, print_console, "[CSDM] Free for all mode is now enabled.")
		set_cvar_num("csdm_kill_all", 1)
		set_cvar_num("mp_autokick", 0)
		set_cvar_num("mp_tkpunish", 0)
		set_cvar_num("mp_autoteambalance", 0)
		set_cvar_num("mp_friendlyfire", 1)
		return PLUGIN_HANDLED
	}
	
	return PLUGIN_HANDLED
}

public csdm_set_amenu(id)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_B)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	if (get_cvar_num("csdm_enable_amenu")) {
		client_print(id, print_console, "[CSDM] Armor menu is now disabled.")
		set_cvar_num("csdm_enable_amenu", 0)
		return PLUGIN_HANDLED
	} else {
		client_print(id, print_console, "[CSDM] Armor menu is now enabled.")
		set_cvar_num("csdm_enable_amenu", 1)
		return PLUGIN_HANDLED
	}
	
	return PLUGIN_HANDLED
}

public csdm_set_gmenu(id)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_B)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	if (get_cvar_num("csdm_enable_gmenu")) {
		client_print(id, print_console, "[CSDM] Grenade menu is now disabled.")
		set_cvar_num("csdm_enable_gmenu", 0)
		return PLUGIN_HANDLED
	} else {
		client_print(id, print_console, "[CSDM] Grenade menu is now enabled.")
		set_cvar_num("csdm_enable_gmenu", 1)
		return PLUGIN_HANDLED
	}
	
	return PLUGIN_HANDLED
}

public hook_team(id)
{
	if (get_cvar_num("csdm_active")) {
		new tID[2]
		tID[0] = id
		set_task(5.0, "quick_respawn", 0, tID, 2)
		if (dbug) {
			log_to_file("csdm-debug.txt", "TeamSelect(%d)")
		}
	}
	
	return PLUGIN_CONTINUE
}

public hook_skin(id)		//from dm autopilot
{
	new parm[2]
	parm[0]=id
	set_task(5.0, "wait_alive", 1037, parm, 2)
	
	return PLUGIN_CONTINUE
}

public wait_alive(parm[])	//from dm autopilot
{	
	new id = parm[0]
	if (!is_user_alive(id))
	{
		new svIndex[2]
		svIndex[0] = id
		set_task(0.5, "quick_respawn", 0, svIndex, 2)
	}
	return PLUGIN_CONTINUE
}

public csdm_origin(id)
{
	new Vec[3]
	
	get_user_origin(id, Vec)
	client_print(id, print_console, "[CSDM] Your origin is (%d, %d, %d).", Vec[0], Vec[1], Vec[2])
	
	return PLUGIN_HANDLED
}

public hook_changewp(id)
{
	return PLUGIN_CONTINUE
}

public hook_block(id)
{
	return PLUGIN_HANDLED
}

public hook_menu(id)
{
	if (dbug) {
		log_to_file("csdm-debug.txt", "hook_menu(%d): ShowMenu[%d]=%d", id, id, ShowMenu[id])
	}
	if (ShowMenu[id]) {
		ShowMenu[id] = false
		client_print(id, print_console, "[CSDM] Weapons menu is now off.")
		if (get_cvar_num("csdm_allow_clguns")) {
			client_print(id, print_console, "[CSDM] You can use ^"guns^" and ^"give <gun>^" to get weapons.")
		}
		return PLUGIN_HANDLED
	} else {
		ShowMenu[id] = true
		client_print(id, print_console, "[CSDM] Weapons menu is now on.")
		if (get_cvar_num("csdm_allow_clguns")) {
			client_print(id, print_console, "[CSDM] You can use ^"guns^" and ^"give <gun>^" to get weapons.")
		}
		return PLUGIN_HANDLED
	}
	
	return PLUGIN_HANDLED
}

public hook_respawn(id)
{
	if (!is_user_alive(id) && id) {
		new Data[2]
		Data[0] = id
		respawn(Data)
		log_to_file("csdm-debug.txt", "hook_respawn(%d)")
	}
	
	return PLUGIN_HANDLED
}

public hook_give(id)
{
	if (get_cvar_num("csdm_allow_clguns")) {
		new data[16], wpn[24], wp
		read_argv(1, data, 16)
		format(wpn, 24, "weapon_%s", data)
		wp = getWepId(wpn)
		if (dbug) {
			log_to_file("csdm-debug.txt", "hook_give(%d): wp=%d wpn=^"%s^"", id, wp, wpn)
		}
		if (!wp) {
			client_print(id, print_console, "[CSDM] Invalid gun!")
			
			return PLUGIN_HANDLED
		} else {
			if (get_cvar_num("csdm_hold_many")) {
				giveGun(id, wp, 2)
			} else {
				if (canGetGun(id, wp)) {
					giveGun(id, wp, 2)
				} else {
					client_print(id, print_console, "[CSDM] Sorry, you can't hold this weapon.")
					
					return PLUGIN_HANDLED
				}
			}
		}
	} else {
		client_print(id, print_console, "[CSDM] Client gun commands are disabled.")
	}
	
	return PLUGIN_HANDLED
}

public hook_guns(id)
{
	if (get_cvar_num("csdm_allow_clguns")) {
		if (is_user_alive(id)) {
			EquipMenu(id)
		}
	} else {
		client_print(id, print_chat, "[CSDM] Sorry, client gun menu command is disabled.")
	}
	
	return PLUGIN_HANDLED
}

public hook_drop(id)
{
	if (get_cvar_num("csdm_active")) {
		new wp, c, a, Drop[2]
		
		wp = get_user_weapon(id, c, a)
		Drop[0] = wp
		if (get_cvar_num("csdm_drop_weapons")) {
			Drop[1] = 0
		} else {
			Drop[1] = 1
		}
		
		if (dbug) {
			log_to_file("csdm-debug.txt", "hook_drop(%d): wp=%d hide=%d c=%d a=%d", id, wp, Drop[1], c, a)
		}
		
		set_task(0.2, "timed_replace", 0, Drop, 2)
	}
	
	return PLUGIN_CONTINUE
}

force_drop_all(id)
{
	//new wps[32], num
	new drop[2], authid[20]
	
	get_user_authid(id, authid, 20)
	
	if (is_user_alive(id)) {
	
/*		get_user_weapons(id, wps, num)
		
		for (new i=0; i<num; i++) {
			if (wps[i] != CSW_C4 && wps[i] != CSW_KNIFE) {
				client_cmd(id, "drop")
				drop[0] = wps[i]
				drop[1] = 1
				set_task(0.2, "timed_replace", 0, drop, 2)
			}
		}*/
		if (get_user_team(id) == 1) {
			if (equali(authid, "BOT")) { 
				client_cmd(id, "drop")
			} else {
				engclient_cmd(id, "drop", "weapon_glock18")
			}
			drop[0] = CSW_GLOCK18
			drop[1] = 1
			set_task(0.2, "timed_replace", 0, drop, 2)
		} else if (get_user_team(id) == 2) {
			if (equali(authid, "BOT")) { 
				client_cmd(id, "drop")
			} else {
				engclient_cmd(id, "drop", "weapon_usp")
			}
			drop[0] = CSW_USP
			drop[1] = 1
			set_task(0.2, "timed_replace", 0, drop, 2)
		}
		if (dbug) {
			log_to_file("csdm-debug.txt", "force_drop_all(%d): team=%d", id, get_user_team(id))
		}
	}
}

public csdm_rement(id, level, cid)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	new S[4]
	new s
	
	read_argv(1, S, 4)
	s = strtonum(S)
	
	client_print(id, print_console, "Removing entity #%d", s)
	rment(s)
	
	return PLUGIN_HANDLED
}

public timed_rem_drop(data[])
{
	new id = data[0]
	
	destroyDrop(id)
	
	return PLUGIN_CONTINUE	
}

public timed_replace(data[])
{
	new wp = data[0]
	new hide = data[1]
	
	if (!hide) {
		replaceWeapons(wp, 0)
	} else {
		replaceWeapons(wp, 1)
	}
	
	return PLUGIN_CONTINUE
}

replaceWeapons(wp, hide=0)
{
	new name[20], model[32], wmodel[32]
	new Float:RVec[3], Float:AVec[3]
	new entid, drop[2]
	new Float:Vel[3]
	new x = 0
	
	get_weaponname(wp, name, 20)
	getWepModel(wp, model, 32)
	
	//No matter what happened - we need to remove armoury_entities too.
	new ent = FindEntity(-1, "armoury_entity")
	while (ent > 0) {
		rment(ent)
		ent = FindEntity(ent, "armoury_entity")
		if (dbug) {
			log_to_file("csdm-debug.txt", "replaceWeapons(%d,%d): removing armoury_entity %d", wp, hide, ent)
		}
		x++
	}
	
	if (wp && strlen(model)) {
		new tEnt = FindEntity(-1, "weaponbox")
		while (tEnt > 0) {
			Entvars_Get_String(tEnt, EV_SZ_model, wmodel, 32)
			if (equali(model, wmodel)) {
				if (dbug) {
					log_to_file("csdm-debug.txt", "replaceWeapons(%d,%d): tEnt = %d", wp, hide, tEnt)
				}
				if (get_cvar_num("csdm_drop_weapons") && !hide) {
					Entvars_Get_Vector(tEnt, EV_VEC_origin, RVec)
					Entvars_Get_Vector(tEnt, EV_VEC_angles, AVec)
					Entvars_Get_Vector(tEnt, EV_VEC_velocity, Vel)
					entid = makeWeapon(wp, RVec, AVec, Vel)
					createDrop(entid)
					if (dbug) {
						log_to_file("csdm-debug.txt", "replaceWeapons(%d,%d): entid=%d, drop[0]=%d", wp, hide, entid, drop[0])
					}
				}
				rment(tEnt)
				x++
			}
			tEnt = FindEntity(tEnt, "weaponbox")
		}
	}
	
	if (dbug) {
		log_to_file("csdm-debug.txt", "replaceWeapons(%d,%d): removed %d ents", wp, hide, x)
	}
	
	return x	//number of ents removed
}

public timed_rem_tempent(data[])
{
	new teID = data[0]
	
	destroyTempEnt(teID)
	
	return PLUGIN_CONTINUE
}

public hook_hud(id)
{
	new param[1]

	param[0] = id 
	set_task(0.1, "hook_hud_delayed", 3000+id, param, 1)
	
	return PLUGIN_CONTINUE
}

public hook_hud_delayed(param[])
{
	new id = param[0]
	
	if (get_cvar_num("csdm_active")) {
		if (!get_cvar_num("csdm_add_items")) {
			if (isRespawn[id]) {
				isRespawn[id] = false
				force_drop_all(id)
				set_task(0.4, "hook_hud_delayed", 3000+id, param, 2)
				
				return PLUGIN_CONTINUE
			}
			if (ShowMenu[id]) {
				EquipMenu(id)
				if (get_cvar_num("csdm_auto_equip")) {
					set_user_armor(id, 100)
					give_item(id, "item_assaultsuit")
				}
				if (get_cvar_num("csdm_auto_gren")) {
					giveGun(id, CSW_HEGRENADE, 2)
					if (get_cvar_num("csdm_allow_smoke")) {
						giveGun(id, CSW_SMOKEGRENADE, 2)
					}
					giveGun(id, CSW_FLASHBANG, 2)
					giveGun(id, CSW_FLASHBANG, 2)
				}
			} else {
				giveGun(id, g_LastWep[id][0], 1)
				giveGun(id, g_LastWep[id][1], 0)
				if (g_getArmor[id] || get_cvar_num("csdm_auto_equip")) {
					set_user_armor(id, 100)
					give_item(id, "item_assaultsuit")
				}
				if (g_getGrens[id] || get_cvar_num("csdm_auto_gren")) {
					giveGun(id, CSW_HEGRENADE, 2)
					if (get_cvar_num("csdm_allow_smoke")) {
						giveGun(id, CSW_SMOKEGRENADE, 2)
					}
					giveGun(id, CSW_FLASHBANG, 2)
					giveGun(id, CSW_FLASHBANG, 2)
				}
				if (get_cvar_num("csdm_spawn_span") && !get_cvar_num("csdm_allow_clguns")) {
					client_print(id, print_chat, "[CSDM] Type ^"enable_menu^" to re-enable, or ^"guns^" to bring up menu.")
				}
			}
		}
	}
	
	return PLUGIN_CONTINUE
}

public hook_death()
{
	new pk = read_data(1)
	new pv = read_data(2)
	new Vec[3]
	new svIndex[2], wps[32], Drop[2], num
	
	if (get_cvar_num("csdm_active")) {
		svIndex[0] = pv
		set_task(0.5, "quick_respawn", 0, svIndex, 2)
		if (dbug) {
			log_to_file("csdm-debug.txt", "hook_death(): pk=%d pv=%d", pk, pv)
		}
		isSpawning[pv] = true
		get_user_origin(pv, Vec)
		if (get_cvar_num("csdm_drop_packs")) {
			createPack(pv, Vec)
		}
		if (get_cvar_num("csdm_kill_all")) {
			if (get_user_team(pk) == get_user_team(pv)) {
				set_user_frags(pk, get_user_frags(pk)+2)
			}
		}
		get_user_weapons(pv, wps, num)		//catch every dropped weapon!
		for (new i=0; i<num; i++) {
			Drop[0] = wps[i]
			if (get_cvar_num("csdm_drop_weapons")) {
				Drop[1] = 0
			} else {
				if (get_cvar_num("csdm_drop_packs")) {
					Drop[1] = 1
				} else {
					Drop[1] = 0
				}
			}
			set_task(0.2, "timed_replace", 0, Drop, 2)			
		}
		isRespawn[pv] = true
	}
	
	return PLUGIN_CONTINUE
}

public quick_respawn(svIndex[])
{
	new vIndex = svIndex[0]
	if (!is_user_alive(vIndex) && (get_user_team(vIndex)!=3)) {
		if (dbug) {
			log_to_file("csdm-debug.txt", "quick_respawn(%d) PASS", vIndex)
		}
		user_spawn(vIndex)
		set_task(0.1, "respawn", 0, svIndex, 2)
	} else {
		if (dbug) {
			log_to_file("csdm-debug.txt", "quick_respawn(%d) FAIL", vIndex)
		}
	}
	
	return PLUGIN_CONTINUE
}

public respawn(svIndex[])
{
	new vIndex = svIndex[0]
	
	if (get_user_team(vIndex)==3) {
		if (dbug) {
			log_to_file("csdm-debug.txt", "respawn(%d) FAIL, team=%d", get_user_team(vIndex))
		}
		return PLUGIN_CONTINUE
	} else {
		if (get_user_team(vIndex) == 1 || get_user_team(vIndex) == 2) {
			user_spawn(vIndex)
			isSpawning[vIndex] = true
			new Float:Time = get_cvar_float("csdm_freeze_time")
			get_user_origin(vIndex, Origins[vIndex])
			set_task(Time, "unfreeze", 0, svIndex, 2)
			if (get_cvar_num("csdm_spawn_spam")) {
				client_print(vIndex, print_chat, "[CSDM] Counter-Strike Deathmatch by BAILOPAN and Freecode!")	
				client_print(vIndex, print_chat, "[CSDM] Console commands: ^"respawn^" to manually respawn.")
				if (get_cvar_num("csdm_allow_clguns")) {
					client_print(vIndex, print_chat, "[CSDM] ^"guns^" to see a menu and ^"give <name>^" to get a gun.")
				}
			}
			if (get_cvar_num("csdm_spawn_protect")>0) {
				set_user_health(vIndex, 10239)
				set_user_rendering(vIndex, kRenderFxGlowShell, 0, 255, 0, kRenderNormal, 25)
				if (get_cvar_num("csdm_spawn_protect")==1) {
					set_task(0.2, "check_move", 0, svIndex, 2, "a", floatround(Time/0.25))
				}
			}
			if (dbug) {
				log_to_file("csdm-debug.txt", "respawn(%d) PASS", vIndex)
			}
		} else {
			if (dbug) {
				log_to_file("csdm-debug.txt", "respawn(%d) FAIL team=%d", vIndex, get_user_team(vIndex))
			}
			return PLUGIN_CONTINUE
		}
	}
	
	return PLUGIN_CONTINUE
}

public check_move(svIndex[])
{
	new vIndex = svIndex[0]
	new Origin[3]
	
	if (isSpawning[vIndex]) {
	
		get_user_origin(vIndex, Origin)
		
		if (Origins[vIndex][0] != Origin[0]) {
			unfreeze(svIndex)
		} else if (Origins[vIndex][1] != Origin[1]) {
			unfreeze(svIndex)
		}
	}
	
	return PLUGIN_CONTINUE
}

public unfreeze(svIndex[])
{
	new vIndex = svIndex[0]
	
	if (dbug) {
		log_to_file("csdm-debug.txt", "unfreeze(%d)", vIndex)
	}
	
	if (get_cvar_num("csdm_spawn_protect")>0) {
		set_user_health(vIndex, 100)
		set_user_rendering(vIndex, kRenderFxNone, 0, 0, 0, kRenderNormal, 0)
	}
	if (get_cvar_num("csdm_add_items")) {
		if (get_cvar_num("csdm_auto_equip")) {
			give_item(vIndex, "item_assaultsuit")
			set_user_armor(vIndex, 100)
		}
		if (get_cvar_num("csdm_auto_gren")) {
			give_item(vIndex, "weapon_hegrenade")
			give_item(vIndex, "weapon_flashbang")
			give_item(vIndex, "weapon_flashbang")
			if (get_cvar_num("csdm_allow_smoke")) {
				give_item(vIndex, "weapon_smokegrenade")
			}
		}
	}
	//Redraw the HUD
	//message_begin(MSG_ALL, get_user_msgid("HideWeapon"))
	//write_byte(0)
	//message_end() 
	isSpawning[vIndex] = false
	
	return PLUGIN_CONTINUE
}

public csdm_version(id)
{
	console_print(id, "[CSDM] Counter-Strike Deathmatch Version %s, build %s.", VERSION, BUILD_VERSION)
	console_print(id, "[CSDM] Made by BAILOPAN and Freecode.")
	
	return PLUGIN_HANDLED
}

public csdm_debug(id)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
	}
	
	if (dbug) {
		dbug = false
		console_print(id, "[CSDM] Debugging disabled.")
		return PLUGIN_HANDLED
	} else {
		dbug = true
		console_print(id, "[CSDM] Debugging enabled.")
		return PLUGIN_HANDLED
	}
	
	return PLUGIN_HANDLED
}

public csdm_look(id)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
	}
	
	new marker, dist=100, cur, PVec[3]
	
	marker = -1
	get_user_origin( id, PVec, 3)

	for (new i=1; i<EntCount; i++) {
		cur = get_distance(PVec, EntVecs[i])
		if (cur < dist) {
			dist = cur
			marker = i
		}
	}

	if (marker!=-1) {
		client_print(id, print_console, "[CSDM] CSDM Entity found: id=%d distance=%d", marker, dist)
	}else{
		client_print(id, print_console, "[CSDM] No Entity found.")
	}

	return PLUGIN_HANDLED
}

public csdm_ent(id)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
	}
		
	new marker, dist=9999, cur
	new PVec[3]
	
	marker = -1
	get_user_origin(id, PVec)
	for (new i=1; i<EntCount; i++) {
		cur = get_distance(PVec, EntVecs[i])
		if (cur < dist) {
			dist = cur
			marker = i
		}
	}
	
	if (marker != -1) {
		client_print(id, print_console, "[CSDM] The nearest entity to you is number %d", marker)
	} else {
		client_print(id, print_console, "[CSDM] No entities found.")
	}
		
	return PLUGIN_HANDLED
}

public csdm_delent(id, level, cid)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	new Text[64]
	new S[4]
	new s
	
	read_argv(1, S, 4)
	s = strtonum(S)
	
	if (s>EntCount || s<1) {
		client_print(id, print_console, "[CSDM] That entity was not found.")
		
		return PLUGIN_HANDLED
	}
	
	new entid = EntId[s]
	
	for (new i=s; i<EntCount-1; i++) {
		copy(EntList[i], 24, EntList[i+1])
		EntVecs[i][0] = EntVecs[i+1][0]
		EntVecs[i][1] = EntVecs[i+1][1]
		EntVecs[i][2] = EntVecs[i+1][2]
		EntId[i] = EntId[i+1]
	}
	EntCount--
	delete_file(EntFile)
	for (new i=1; i<EntCount; i++) {
		format(Text, 64, "%s %d %d %d", EntList[i], EntVecs[i][0], EntVecs[i][1], EntVecs[i][2])
		write_file(EntFile, Text, -1)
	}
	
	rment(entid)
	
	client_print(id, print_console, "[CSDM] Entity %d removed.", s)
	client_print(id, print_console, "[CSDM] There are now %d entities defined.", EntCount)
	
	return PLUGIN_HANDLED
}

public csdm_delspawn(id, level, cid)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	new Text[64]
	new S[4]
	new s
	
	read_argv(1, S, 4)
	s = strtonum(S)
	
	if (s>SPAWNS) {
		client_print(id, print_console, "[CSDM] That spawn point was not found.")
		
		return PLUGIN_HANDLED
	}
	
	s--
	for (new i=s; i<SPAWNS-1; i++) {
		SPAWN[i][0] = SPAWN[i+1][0]
		SPAWN[i][1] = SPAWN[i+1][1]
		SPAWN[i][2] = SPAWN[i+1][2]
	}
	SPAWNS--
	delete_file(mapFile)
	for (new i=0; i<SPAWNS; i++) {
		format(Text, 64, "%d %d %d", SPAWN[i][0], SPAWN[i][1], SPAWN[i][2])
		write_file(mapFile, Text, -1)
	}
	readMapFile()
	setSpawns()
	
	client_print(id, print_console, "[CSDM] Spawn point %d removed.", s)
	client_print(id, print_console, "[CSDM] There are now %d spawns defined.", SPAWNS)
	
	return PLUGIN_HANDLED
}

public csdm_setspawnv(id, level, cid)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	new IDVec[3]
	new Text[64]
	new Float:vAngle[3]
	new team[4]
	new iTeam
	
	read_argv(1, team, 4)
	iTeam = strtonum(team)
	
	if (SPAWNS == 0 || !SPAWNS_ENABLED) {
		SPAWNS_ENABLED = 1
	}
	if (SPAWNS == MAX_SPAWNS) {
		client_print(id, print_console, "[CSDM] Spawn limit reached at %d.", MAX_SPAWNS)
		
		return PLUGIN_HANDLED
	}
	
	get_user_origin(id, IDVec)
	Entvars_Get_Vector(id, EV_VEC_v_angle, vAngle)
	IDVec[2] += 15
	format(Text, 64, "%d %d %d %d %d %d %d", IDVec[0], IDVec[1], IDVec[2], floatround(vAngle[0]), floatround(vAngle[1]), floatround(vAngle[2]), iTeam)
	
	write_file(mapFile, Text, -1)
	SPAWN[SPAWNS][0] = IDVec[0]
	SPAWN[SPAWNS][1] = IDVec[1]
	SPAWN[SPAWNS][2] = IDVec[2]
	SpnVec[SPAWNS][0] = vAngle[0]
	SpnVec[SPAWNS][1] = vAngle[1]
	SpnVec[SPAWNS][2] = vAngle[2]
	SpnTeam[SPAWNS] = iTeam
	set_user_origin(id, SPAWN[SPAWNS])
	SPAWNS++
	
	client_print(id, print_console, "[CSDM] There are now %d spawns defined.", SPAWNS)
	
	return PLUGIN_HANDLED
}

public csdm_setspawn(id, level, cid)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	new IDVec[3]
	new Text[64]
	new team[4]
	new iTeam
	
	read_argv(1, team, 4)
	iTeam = strtonum(team)
	
	if (SPAWNS == 0 || !SPAWNS_ENABLED) {
		SPAWNS_ENABLED = 1
	}
	if (SPAWNS == MAX_SPAWNS) {
		client_print(id, print_console, "[CSDM] Spawn limit reached at %d.", MAX_SPAWNS)
		
		return PLUGIN_HANDLED
	}
	
	get_user_origin(id, IDVec)
	IDVec[2] += 15
	format(Text, 64, "%d %d %d 0 0 0 %d", IDVec[0], IDVec[1], IDVec[2], iTeam)
	
	write_file(mapFile, Text, -1)
	SPAWN[SPAWNS][0] = IDVec[0]
	SPAWN[SPAWNS][1] = IDVec[1]
	SPAWN[SPAWNS][2] = IDVec[2]
	SpnVec[SPAWNS][0] = 0.0
	SpnVec[SPAWNS][1] = 0.0
	SpnVec[SPAWNS][2] = 0.0
	SpnTeam[SPAWNS] = iTeam
	set_user_origin(id, SPAWN[SPAWNS])
	SPAWNS++
	
	client_print(id, print_console, "[CSDM] There are now %d spawns defined.", SPAWNS)
	
	return PLUGIN_HANDLED
}

public csdm_hidespawns(id)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	new tEnt
	
	tEnt = FindEntity(-1, "view_spawn")
	while (tEnt > 0) {
		rment(tEnt)
		tEnt = FindEntity(-1, "view_spawn")
	}
	
	client_print(id, print_console, "[CSDM] Spawn markers removed.")
	
	return PLUGIN_HANDLED
}

public csdm_viewspawns(id, level, cid)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	new entid, Float:Vec[3]
		
	for (new i=0; i<SPAWNS; i++) {
		IVecFVec(SPAWN[i], Vec)
		entid = mkent("info_target")
		Entvars_Set_String(entid, EV_SZ_classname, "view_spawn")
		ENT_SetModel(entid, "models/w_suit.mdl")
		ENT_SetOrigin(entid, Vec)
		Entvars_Set_Vector(entid, EV_VEC_angles, SpnVec[i])
		Entvars_Set_Int(entid, EV_INT_solid, 1)
		Entvars_Set_Int(entid, EV_INT_movetype, 6)
	}
	
	return PLUGIN_HANDLED
}

public csdm_setent(id, level, cid)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_D)) {
		client_print(id, print_console, "[CSDM] You do not have appropriate access.")
		
		return PLUGIN_HANDLED
	}
	
	if (EntCount == MAX_ENTS) {
		client_print(id, print_console, "[CSDM] Entity limit reached at %d", MAX_ENTS)
		
		return PLUGIN_HANDLED
	}
	
	if (get_cvar_num("csdm_add_items") != 1) {
		client_print(id, print_console, "[CSDM] You must have csdm_add_items set to 1.")
		client_print(id, print_console, "[CSDM] Set it to 1 and restart the map.")
		
		return PLUGIN_HANDLED
	}
	
	new IDVec[3]
	new gEnt[24]
	new Text[64]
	
	read_argv(1, gEnt, 24)
	get_user_origin(id, IDVec)
	format(Text, 64, "%s %d %d %d", gEnt, IDVec[0], IDVec[1], IDVec[2])
	
	copy(EntList[EntCount], 24, gEnt)
	EntVecs[EntCount][0] = IDVec[0]
	EntVecs[EntCount][1] = IDVec[1]
	EntVecs[EntCount][2] = IDVec[2]
	EntId[EntCount] = makeEnt(EntCount)

	if (EntId[EntCount] > 0) {
		write_file(EntFile, Text, -1)
		EntCount++
		client_print(id, print_console, "[CSDM] There are now %d entities defined.", EntCount)
	} else {
		client_print(id, print_console, "[CSDM] Entity ^"%s^" did not init properly.", gEnt)
		EntVecs[EntCount][0] = 0
		EntVecs[EntCount][1] = 0
		EntVecs[EntCount][2] = 0
		EntId[EntCount] = 0
		copy(EntList[EntCount], 24, "")
	}
	
	return PLUGIN_HANDLED
}

public csdm_onoff(id, level, cid)
{
	if (!(get_user_flags(id)&ADMIN_LEVEL_C)) {
		return PLUGIN_HANDLED
	}
	
	new Bits[4], bit
	
	read_argv(1, Bits, 4)
	bit = strtonum(Bits)
	
	if (bit == 0) {
		set_cvar_num("csdm_active", 0)
		client_print(id, print_console, "CSDM Mode turned off.")
		log_message("[CSDM] CSDM Mode turned off.")
		client_print(id, print_console, "You must changemap/reset to make changes.")
		return PLUGIN_HANDLED
	} else {
		set_cvar_num("csdm_active", 1)
		client_print(id, print_console, "CSDM Mode turned on.")
		log_message("[CSDM] CSDM Mode turned on.")
		client_print(id, print_console, "You must changemap/reset to make changes.")
		return PLUGIN_HANDLED
	}
		
	return PLUGIN_HANDLED
}

checkMod()
{
	new mod[16]
	
	get_modname(mod, 16)
	
	if (!equali(mod, "cstrike")) {
		log_message("[CSDM] Not running on cstrike, plugin disabled.")
		set_cvar_string("csdm_active", "1")
		
		return false
	} else {
		if (get_cvar_num("csdm_active")==1) {
			new Time[32]
			get_cvar_string("mp_timelimit", Time, 32)
			if (strtonum(Time) < 1) {
				copy(Time, 32, "10")
			}
			set_cvar_string("mp_roundtime", Time)
			set_cvar_num("mp_freezetime", 0)
			if (get_cvar_num("csdm_kill_all")) {
				if (get_cvar_num("mp_tkpunish")>0) {
					set_cvar_num("mp_tkpunish", 0)
				}
				if (get_cvar_num("mp_autokick")>0) {
					set_cvar_num("mp_autokick", 0)
				}
				if (get_cvar_num("mp_autoteambalance")>0) {
					set_cvar_num("mp_autoteambalance",0)
				}
				if (get_cvar_num("mp_friendlyfire")!=1) {
					set_cvar_num("mp_friendlyfire", 1)
				}
			}
			MessageBlock(get_user_msgid("TextMsg"), BLOCK_SET)
			MessageBlock(get_user_msgid("SendAudio"), BLOCK_SET)
		}
	}
	
	return true
}

bool:cwrap(string1[], string2[])
{
	if (containi(string1, string2)!=-1) {
		return true
	} else {
		return false
	}
	
	return false
}

cleanMap()
{
	if (get_cvar_num("csdm_active")) {
		new tEnt
		
		for (new i=0; i<S_ENTS; i++) {
			tEnt = FindEntity(-1, StripEnts[i])
			while (tEnt > 0) {
				rment(tEnt)
				tEnt = FindEntity(-1, StripEnts[i])
			}
		}
	}
}

setSpawns()
{	
	if (SPAWNS_ENABLED && get_cvar_num("csdm_active")) {
		new tEnt = FindEntity(-1, "info_player_start")
		while (tEnt > 0) {
			rment(tEnt)
			tEnt = FindEntity(-1, "info_player_start")
		}
		new dEnt = FindEntity(-1, "info_player_deathmatch")
		while (dEnt > 0) {
			rment(dEnt)
			dEnt = FindEntity(-1, "info_player_deathmatch")
		}		
		new chosen[32]
		new Float:Vec[3]
		new ent
		new f, g
		for (new i=0; i<SPAWNS; i++) {
			f = random_num(0, SPAWNS-1)
			while (chosen[f]) {
				f = random_num(0, SPAWNS-1)
			}
			chosen[f] = 1
			IVecFVec(SPAWN[f], Vec)
			if (SpnTeam[f] == 1) {
				g = 1
			} else if (SpnTeam[f] == 2) {
				g = 2
			} else {
				g = (random_num(1,20) % 2) + 1
			}
			if (g == 2) {
				ent = mkent("info_player_start")
				Entvars_Set_String(ent, EV_SZ_classname, "info_player_start")
			} else if (g == 1) {
				ent = mkent("info_player_deathmatch")
				Entvars_Set_String(ent, EV_SZ_classname, "info_player_deathmatch")
			}
			if (dbug) {
				log_to_file("csdm-debug.txt", "setSpawns() SPAWNS=%d i=%d f=%d g=%d ent=%d", SPAWNS, i, f, g, ent)
			}
			if (ent) {
				ENT_SetOrigin(ent, Vec)
				Entvars_Set_Vector(ent, EV_VEC_angles, SpnVec[f])
				SpawnEnts[f] = ent
			}
		}
	}
}

setEnts()
{
	if ((get_cvar_num("csdm_add_items")==1) && EntCount && get_cvar_num("csdm_active")) {
		for (new i=1; i<=EntCount; i++) {
			EntId[i] = makeEnt(i)
		}
	}
}

makeWeapon(wp, Float:Origin[3], Float:Angles[3]={0.0,0.0,0.0}, Float:Vel[3]={0.0,0.0,0.0})
{
	new model_name[32]
	new name[20]
	
	getWepModel(wp, model_name, 32)
	get_weaponname(wp, name, 20)
	
	new entid = mkent("info_target")
	if (entid) {
		Entvars_Set_String(entid, EV_SZ_classname, name)
		ENT_SetModel(entid, model_name)
		ENT_SetOrigin(entid, Origin)
		Entvars_Set_Int(entid, EV_INT_solid, 1)
		Entvars_Set_Int(entid, EV_INT_movetype, 6)
		Entvars_Set_Vector(entid, EV_VEC_angles, Angles)
		Entvars_Set_Vector(entid, EV_VEC_velocity, Vel)
	} else {
		entid = 0
	}
	
	if (dbug) {
		log_to_file("csdm-debug.txt", "makeWeapon(%d): model_name=^"%s^" name=^"%s^"", wp, model_name, name)
	}
	
	return entid
}

makeEnt(id)
{
	new Float:Vec[3]
	new entid
	
	IVecFVec(EntVecs[id], Vec)
	
	if ((!(get_cvar_num("csdm_active"))) || (!(get_cvar_num("csdm_add_items")))) {
		return 0
	}
	
	if (cwrap(EntList[id], "weapon_")) {
		if (cwrap(EntList[id], "smokegrenade")) {
			if (!get_cvar_num("csdm_allow_smoke")) {
				return 0
			}
		}
		new wp = getWepId(EntList[id])
		entid = makeWeapon(wp, Vec)
	} else if (cwrap(EntList[id], "pistol_ammo")) {
		entid = mkent("info_target")
		if (entid) {
			Entvars_Set_String(entid, EV_SZ_classname, "csdm_pistolammo")
			ENT_SetModel(entid, "models/w_357ammobox.mdl")
			ENT_SetOrigin(entid, Vec)
			Entvars_Set_Int(entid, EV_INT_solid, 1)
			Entvars_Set_Int(entid, EV_INT_movetype, 6)
		}
	} else if (cwrap(EntList[id], "rifle_ammo")) {
		entid = mkent("info_target")
		if (entid) {
			Entvars_Set_String(entid, EV_SZ_classname, "csdm_rifleammo")
			ENT_SetModel(entid, "models/w_9mmarclip.mdl")
			ENT_SetOrigin(entid, Vec)
			Entvars_Set_Int(entid, EV_INT_solid, 1)
			Entvars_Set_Int(entid, EV_INT_movetype, 6)
		}
	} else if (cwrap(EntList[id], "shotgun_ammo")) {
		entid = mkent("info_target")
		if (entid) {
			Entvars_Set_String(entid, EV_SZ_classname, "csdm_shotammo")
			ENT_SetModel(entid, "models/w_shotbox.mdl")
			ENT_SetOrigin(entid, Vec)
			Entvars_Set_Int(entid, EV_INT_solid, 1)
			Entvars_Set_Int(entid, EV_INT_movetype, 6)
		}
	} else if (cwrap(EntList[id], "smg_ammo")) {
		entid = mkent("info_target")
		if (entid) {
			Entvars_Set_String(entid, EV_SZ_classname, "csdm_smgammo")
			ENT_SetModel(entid, "models/w_9mmclip.mdl")
			ENT_SetOrigin(entid, Vec)
			Entvars_Set_Int(entid, EV_INT_solid, 1)
			Entvars_Set_Int(entid, EV_INT_movetype, 6)
		}
	} else if (cwrap(EntList[id], "full_ammo")) {
		entid = mkent("info_target")
		if (entid) {
			Entvars_Set_String(entid, EV_SZ_classname, "csdm_fullammo")
			ENT_SetModel(entid, "models/w_chainammo.mdl")
			ENT_SetOrigin(entid, Vec)
			Entvars_Set_Int(entid, EV_INT_solid, 1)
			Entvars_Set_Int(entid, EV_INT_movetype, 6)
		}
	} else if (cwrap(EntList[id], "gren_ammo")) {
		entid = mkent("info_target")
		if (entid) {
			Entvars_Set_String(entid, EV_SZ_classname, "csdm_treasure")
			ENT_SetModel(entid, "models/w_rpgammo.mdl")
			ENT_SetOrigin(entid, Vec)
			Entvars_Set_Int(entid, EV_INT_solid, 1)
			Entvars_Set_Int(entid, EV_INT_movetype, 6)
		}
	} else if (cwrap(EntList[id], "armor")) {
		entid = mkent("info_target")
		if (entid) {
			Entvars_Set_String(entid, EV_SZ_classname, "csdm_armor")
			ENT_SetModel(entid, "models/w_assault.mdl")
			ENT_SetOrigin(entid, Vec)
			Entvars_Set_Int(entid, EV_INT_solid, 1)
			Entvars_Set_Int(entid, EV_INT_movetype, 6)
		}
	} else {
		entid = mkent(EntList[id])
		if (entid) {
			Entvars_Set_String(entid, EV_SZ_classname, EntList[id])
			ENT_SetOrigin(entid, Vec)
			DispatchSpawn(entid)
		}
	}
	
	if (entid) {
		return entid
	} else {
		return 0
	}
	
	return entid
}

readEntsFile()
{
	new Map[32]
	new Text[192]
	
	get_mapname(Map, 48)
	format(EntFile, 48, "addons\amx\csdm\ents_%s.cfg", Map)
	EntCount = 0
	if (file_exists(EntFile)) {
		new i=0, temp
		new Data[32]
		new x,y,z
		new Name[32]
		new TempB1[32]
		new TempB2[32]
		new TempB3[32]
		while (i<MAX_ENTS && read_file(EntFile, i, Data, 32, temp)) {
			strbreak(Data, Name, TempB3, 32, 32)
			strbreak(TempB3, TempB1, TempB2, 32, 32)
			x = strtonum(TempB1)
			strbreak(TempB2, TempB1, TempB3, 32, 32)
			y = strtonum(TempB1)
			strbreak(TempB3, TempB1, TempB2, 32, 32)
			z = strtonum(TempB1)
			if (strlen(Name)>2) {
				EntCount++
				EntVecs[EntCount][0] = x
				EntVecs[EntCount][1] = y
				EntVecs[EntCount][2] = z
				copy(EntList[EntCount], 24, Name)
			}
			i++
		}
		format(Text, 192, "[CSDM] loaded %d entities for %s.", EntCount, Map)
		log_message(Text)
	} else {
		format(Text, 192, "[CSDM] warning: map %s not set up for entities.", Map)
		log_message(Text)
		EntCount = 0
	}
}

readMapFile()	//taken from Bail's Root Plugin
{
	new Map[32]
	new Text[192]
	
	get_mapname(Map, 32)
	format(mapFile, 48, "addons\amx\csdm\csdm_%s.cfg", Map)
	SPAWNS = 0
	if (file_exists(mapFile)) {
		SPAWNS_ENABLED = 1
		new i=0, temp
		new Data[64]
		new TempB1[8]
		new TempB2[8]
		new TempB3[8]
		new TempB4[8]
		new TempB5[8]
		new TempB6[8]
		new TempB7[8]
		while (i<MAX_SPAWNS && read_file(mapFile, i, Data, 64, temp)) {
			if (strlen(Data)>2) {
				parse(Data, TempB1, 8, TempB2, 8, TempB3, 8, TempB4, 8, TempB5, 8, TempB6, 8, TempB7, 8)
				SPAWN[SPAWNS][0] = strtonum(TempB1)
				SPAWN[SPAWNS][1] = strtonum(TempB2)
				SPAWN[SPAWNS][2] = strtonum(TempB3)
				SpnVec[SPAWNS][0] = float(strtonum(TempB4))
				SpnVec[SPAWNS][1] = float(strtonum(TempB5))
				SpnVec[SPAWNS][2] = float(strtonum(TempB6))
				SpnTeam[SPAWNS] = strtonum(TempB7)
				SPAWNS++
				i++
			}
		}
		format(Text, 192, "[CSDM] loaded %d spawns for %s.", SPAWNS, Map)
		log_message(Text)
	} else {
		format(Text, 192, "[CSDM] warning: map %s not set up for spawn points.", Map)
		log_message(Text)
		SPAWNS_ENABLED = 0
	}
}

strbreak(const String[], Left[], Right[], lMax, rMax)	//taken from Bail's Root Plugin
{
	//Breaks String[] into two parts, Left[], and Right[]
	// Left[] will contain the first parameter (either quoted or non-quoted)
	// Right[] contain the rest of the string after Left[], not including the space
	new bool:quote_flag = false
	new bool:done_flag = false
	new left_pos = 0
	new right_pos = 0
	new i
	new hold[] = "'^"x"
	
	copy(Left, lMax, "")
	copy(Right, rMax, "")
	
	for (i=0; i<=strlen(String)-1; i++) {
		if (equali(String[i], "^"", 1)) {
			quote_flag = true
		} else if ((equali(String[i], "^"", 1)) && (quote_flag)) {
			quote_flag = false
		}
		if ((equali(String[i], " ", 1)) && (!quote_flag) && (!done_flag)) {
			done_flag = true
			i++
		}
		if (!done_flag && !equali(String[i], "^"", 1)) {
			if (left_pos < lMax) {
				setc(Left[left_pos], 1, String[i])
				if (equali(Left[left_pos], "'", 1)) {
					setc(Left[left_pos], 1, hold[1])
				}
				left_pos++
			}
		} else {
			if (right_pos < rMax && !equali(String[i], "^"", 1)) {
				setc(Right[right_pos], 1, String[i])
				if (equali(Right[right_pos], "'", 1)) {
					setc(Right[right_pos], 1, hold[1])
				}
				right_pos++
			}
		}
	}

	Left[left_pos] = 0
	Right[right_pos] = 0
	
	return true
}

IVecFVec(IVec[3], Float:FVec[3])
{
	FVec[0] = float(IVec[0])
	FVec[1] = float(IVec[1])
	FVec[2] = float(IVec[2])
}

public giveGun(id,wpn,s)	//by Freecode
{
	new wpn_id[32], num
	get_user_weapons(id,wpn_id,num)
	for(new i = 0; i<num; i++)
	{
		if(wpn_id[i] != wpn)
		{
			if (canGetGun(id, wpn)) {
				new wepname[32]
				get_weaponname(wpn,wepname,31)
				if(is_user_alive(id)) {
					while (canGetGun(id, wpn)) {
						give_item(id, wepname)
					}
				}
				if (s==1) {
					g_LastWep[id][0] = wpn
				} else if (s==0) {
					g_LastWep[id][1] = wpn
				}
			}
		}
	}
	return PLUGIN_HANDLED
}

public ArmorMenu(id)
{
	if (is_user_alive(id)) {
		if (get_cvar_num("csdm_enable_amenu")) {
			new menuBody[192]
			new key
			
			format(menuBody, 192, "\rCSDM: Armor\R^n^n\y1.\w Yes, armor up^n\y2.\w No armor")
			key = (1<<0)|(1<<1)
			
			show_menu(id, key, menuBody)
		} else {
			GrenadeMenu(id)
		}
	}
}

public GrenadeMenu(id)
{
	if (is_user_alive(id) && get_cvar_num("csdm_enable_gmenu")) {
		new menuBody[192]
		new key
		
		format(menuBody, 192, "\rCSDM: Grenades\R^n^n\y1.\w All Grenades^n\y2.\w No grenades")
		key = (1<<0)|(1<<1)
		
		show_menu(id, key, menuBody)
	}
}

public EquipMenu(id)
{
	if (is_user_alive(id)) {
		new menuBody[192] 
		new key
		
		format(menuBody, 192, "\rCSDM: Equip\R^n^n\y1.\w New Weapons^n\y2.\w Previous Setup^n\y3.\w 2+Don't show menu again")
		key = (1<<0)|(1<<1)|(1<<2)
		
		show_menu(id, key, menuBody)
	}
}

public pWeaponMenu(id,mpage)	//By Freecode
{
	g_MenuPos[id] = mpage
	new menuBody[1024]
	new len
	new key
	if(mpage == 1)
	{
		len = format(menuBody,1023,"\rCSDM: Primary Weapon\R^n^n\y1.\w M4A1^n\y2.\w AK47^n\y3.\w AUG^n\y4.\w SG552^n\y5.\w Galil^n\y6.\w Famas")
		len += format(menuBody[len],1023-len,"^n\y7.\w Next^n\y8.\w None")
		key = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)
	}
	else if(mpage == 2)
	{
		len = format(menuBody,1023,"\rCSDM: Primary Weapon\R^n^n\y1.\w Scout^n\y2.\w AWP^n\y3.\w SG550^n\y4.\w M249^n\y5.\w G3SG1^n\y6.\w Back^n\y7.\w Next")
		len += format(menuBody[len],1023-len,"^n\y8.\w Exit")
		key = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)
	}
	else if(mpage == 3)
	{
		len = format(menuBody,1023,"\rCSDM: Primary Weapon\R^n^n\y1.\w UMP 45^n\y2.\w MP5 Navy^n\y3.\w M3^n\y4.\w XM1014^n\y5.\w TMP^n\y6.\w Mac 10")
		len += format(menuBody[len],1023-len,"^n\y7.\w Back^n\y8.\w Exit")
		key = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)
	}
	show_menu(id,key,menuBody)
}

public sWeaponMenu(id)	//By Freecode
{
	new menuB[1024]
	new key
	format(menuB,1023,"\rCSDM: Secondary Weapon\R^n^n\y1.\w USP^n\y2.\w Glock^n\y3.\w Deagle^n\y4.\w P228t^n\y5.\w Elite^n\y6.\w Five Seven^n\y7.\w None")
	key = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)
	show_menu(id,key,menuB)
}

public ArmorChoice(id, key)
{
	switch(key)
	{
		case 0:
		{
			set_user_armor(id, 100)
			give_item(id, "item_assaultsuit")
			g_getArmor[id] = true
		}
		case 1:
		{
			g_getArmor[id] = false
		}	
	}
	GrenadeMenu(id)
}

public GrenChoice(id, key)
{
	switch(key)
	{
		case 0:
		{
			give_item(id, "weapon_hegrenade")
			give_item(id, "weapon_flashbang")
			give_item(id, "weapon_flashbang")
			if (get_cvar_num("csdm_allow_smoke")) {
				give_item(id, "weapon_smokegrenade")
			}
			g_getGrens[id] = true
		}
		case 1:
		{
			g_getGrens[id] = false
		}
	}
}


public EquipChoice(id, key)
{
	switch(key)
	{
		case 0:
		{
			sWeaponMenu(id)
		}
		case 1:
		{
			giveGun(id, g_LastWep[id][0], 1)
			giveGun(id, g_LastWep[id][1], 0)
		}
		case 2:
		{
			giveGun(id, g_LastWep[id][0], 1)
			giveGun(id, g_LastWep[id][1], 0)
			ShowMenu[id] = false
			client_print(id, print_chat, "[CSDM] Type ^"enable_menu^" to re-enable, or ^"guns^" to bring up.")
		}
	}
}

public PrimaryWeapon(id,key)	//By Freecode
{
	Swep[id] = false
	if(g_MenuPos[id] == 1)
	{
		switch (key)
		{
			case 0:
			{
				giveGun(id,CSW_M4A1,0)
				ArmorMenu(id)
			}
			case 1: 
			{
				giveGun(id,CSW_AK47,0)
				ArmorMenu(id)
			}
			case 2: 
			{
				giveGun(id,CSW_AUG,0)
				ArmorMenu(id)
			}
			case 3:
			{
				giveGun(id,CSW_SG552,0)
				ArmorMenu(id)
			}
			case 4:
			{
				giveGun(id,CSW_GALI,0)
				ArmorMenu(id)
			}
			case 5:
			{
				giveGun(id,CSW_FAMAS,0)
				ArmorMenu(id)
			}
			case 6: pWeaponMenu(id,2)
			case 8: ArmorMenu(id)
		}
	}
	else if(g_MenuPos[id] == 2)
	{
		switch (key)
		{
			case 0:
			{
				giveGun(id,CSW_SCOUT,0)
				ArmorMenu(id)
			}
			case 1:
			{
				giveGun(id,CSW_AWP,0)
				ArmorMenu(id)
			}
			case 2:
			{
				giveGun(id,CSW_SG550,0)
				ArmorMenu(id)
			}
			case 3:
			{
				giveGun(id,CSW_M249,0)
				ArmorMenu(id)
			}
			case 4:
			{
				giveGun(id,CSW_G3SG1,0)
				ArmorMenu(id)
			}
			case 5: pWeaponMenu(id,1)
			case 6: pWeaponMenu(id,3)
		}
	}
	else if(g_MenuPos[id] == 3)
	{
		switch (key)
		{
			case 0:
			{
				giveGun(id,CSW_UMP45,0)
				ArmorMenu(id)
			}
			case 1:
			{
				giveGun(id,CSW_MP5NAVY,0)
				ArmorMenu(id)
			}
			case 2:
			{
				giveGun(id,CSW_M3,0)
				ArmorMenu(id)
			}
			case 3:
			{
				giveGun(id,CSW_XM1014,0)
				ArmorMenu(id)
			}
			case 4:
			{
				giveGun(id,CSW_TMP,0)
				ArmorMenu(id)
			}
			case 5: 
			{
				giveGun(id,CSW_MAC10,0)
				ArmorMenu(id)
			}
			case 6: pWeaponMenu(id,2)
		}
	}
}

public SecondWeapon(id,key)	//By Freecode
{
	Swep[id] = false
	switch (key)
	{
		case 0: 
			{
				giveGun(id,CSW_USP,1)
				pWeaponMenu(id, 1)
			}
		case 1: 
			{
				giveGun(id,CSW_GLOCK18,1)
				pWeaponMenu(id, 1)
			}
		case 2:
			{
				giveGun(id,CSW_DEAGLE,1)
				pWeaponMenu(id, 1)
			}
		case 3: 
			{
				giveGun(id,CSW_P228,1)
				pWeaponMenu(id, 1)
			}
		case 4: 
			{
				giveGun(id,CSW_ELITE,1)
				pWeaponMenu(id, 1)
			}
		case 5:
			{
				giveGun(id,CSW_FIVESEVEN,1)
				pWeaponMenu(id, 1)
			}
		case 6:
			{
				pWeaponMenu(id, 1)
			}
	}
	
}

public vexd_pfntouch(pToucher, pTouched) {
	new ptr = pToucher
	new ptd = pTouched
	new ptrClass[32]
	new ptdClass[32]
	new Float:Time = get_cvar_float("csdm_item_time")
	new g_wp
	new Item[2], id
   
	Entvars_Get_String(ptr, EV_SZ_classname, ptrClass, 32)
	Entvars_Get_String(ptd, EV_SZ_classname, ptdClass, 32)

	//client_print(0, print_chat, "DEBUG => vexd/ptr,ptrc (%d, ^"%s^")", ptr,ptrClass)
	if (!is_user_alive(ptd) || ptd > 32 || ptd < 1) {
		return PLUGIN_CONTINUE
	}
	
	if (cwrap(ptrClass, "weapon_") && equal(ptdClass, "player")) {
		g_wp = getWepId(ptrClass)
		id = findEntId(ptr)
		if (id && g_wp) {
			if (canGetGun(ptd, g_wp)) {
				rment(ptr)
				give_item(ptd, ptrClass)
				EntId[id] = 0
				Item[0] = id
				set_task(Time, "replenish", 0, Item, 2)
			}
		} else {
			if (canGetGun(ptd, g_wp)) {
				//Do not replenish, THIS IS A TEMPENT
				new teID = findTempEnt(ptr)
				new dropid = findDrop(teID)
				give_item(ptd, ptrClass)
				if (dropid && teID) {
					destroyDrop(dropid)
				} else if (!dropid && teID) {
					destroyTempEnt(teID)
				} else {
					rment(ptr)
				}
			}
		}
	}
	
	if (get_cvar_num("csdm_add_items")!=1) {
		return PLUGIN_CONTINUE
	}
	
	if (cwrap(ptrClass, "csdm_") && equal(ptdClass, "player")) {
		//THIS WEAPON WAS SET IN THE MAP THROUGH CSDM_SETENT - PERMANENT
		id = findEntId(ptr)
		//client_print(0, print_chat, "DEBUG => vexd/id => %d", id)
		if (id) {
			if (cwrap(EntList[id], "pistol_ammo")) {
				if (canGetAmmo(ptd, PISTOL_AMMO)) {
					giveAmmoType(ptd, PISTOL_AMMO)
					rment(ptr)
					EntId[id] = 0
					Item[0] = id
					set_task(Time, "replenish", 0, Item, 2)
				}
			} else if (cwrap(EntList[id], "shotgun_ammo")) {
				if (canGetAmmo(ptd, SHOTGUN_AMMO)) {
					giveAmmoType(ptd, SHOTGUN_AMMO)
					rment(ptr)
					EntId[id] = 0
					Item[0] = id
					set_task(Time, "replenish", 0, Item, 2)
				}
			} else if (cwrap(EntList[id], "smg_ammo")) {
				if (canGetAmmo(ptd, SMG_AMMO)) {
					giveAmmoType(ptd, SMG_AMMO)
					rment(ptr)
					EntId[id] = 0
					Item[0] = id
					set_task(Time, "replenish", 0, Item, 2)
				}
			} else if (cwrap(EntList[id], "rifle_ammo")) {
				if (canGetAmmo(ptd, RIFLE_AMMO)) {
					giveAmmoType(ptd, RIFLE_AMMO)
					rment(ptr)
					EntId[id] = 0
					Item[0] = id
					set_task(Time, "replenish", 0, Item, 2)
				}
			} else if (cwrap(EntList[id], "full_ammo")) {
				if (canGetAmmo(ptd, 1) && canGetAmmo(ptd, 2) & canGetAmmo(ptd, 3) && canGetAmmo(ptd, 4)) {
					giveAmmoType(ptd, PISTOL_AMMO)
					giveAmmoType(ptd, SHOTGUN_AMMO)
					giveAmmoType(ptd, SMG_AMMO)
					giveAmmoType(ptd, RIFLE_AMMO)
					rment(ptr)
					EntId[id] = 0
					Item[0] = id
					set_task(Time, "replenish", 0, Item, 2)
				}
			} else if (cwrap(EntList[id], "armor")) {
				if (get_user_armor(ptd) < 100) {
					give_item(ptd, "item_assaultsuit")
					rment(ptr)
					EntId[id] = 0
					Item[0] = id
					set_task(Time, "replenish", 0, Item, 2)
				}
			}
		}
	} else if (equali(ptrClass, "drop_pack") && equali(ptdClass, "player")) {
		//THIS PACK WAS CREATED ON DEATH - :. IT IS A TEMPENT
		//Go through pack contents and award bonii
		new teID = findTempEnt(ptr)
		new pid = findPackId(teID)
		
		if (pid && teID) {
			if (get_user_health(ptd)+15>100) {
				set_user_health(ptd, 100)
			} else {
				set_user_health(ptd, get_user_health(ptd)+15)
			}
			if (get_user_armor(ptd)+15>100) {
				set_user_armor(ptd, 100)
			} else {
				set_user_armor(ptd, get_user_armor(ptd)+15)
			}
			emit_sound(ptd, CHAN_ITEM, "items/ammopickup2.wav", 0.85, ATTN_NORM, 0, 150)
			new name[20]
			for (new i=0; i<4; i++) {
				g_wp = PackAmmo[pid][i]
				if (g_wp) {
					if (canGetGun(ptd, g_wp)) {
						get_weaponname(g_wp, name, 20)
						give_item(ptd, name)
					}
					giveAmmoType(ptd, i+1)
				}
			}
			for (new i=0; i<3; i++) {
				g_wp = PackGren[pid][i]
				if (g_wp) {
					if (canGetGun(ptd, g_wp)) {
						get_weaponname(g_wp, name, 20)
						give_item(ptd, name)
					}
				}
			}
			//Get rid of pack
			if (!destroyPack(pid)) {
				rment(ptr)
			}
		}
	}
	      
	return PLUGIN_CONTINUE
}

public replenish(Item[])
{
	new id = Item[0]

	if (id) {
		EntId[id] = makeEnt(id)
		if (EntId[id]) {
			emit_sound(EntId[id], CHAN_ITEM, "items/suitchargeok1.wav", 0.85, ATTN_NORM, 0, 150)
		} else {
			//failed to replenish, make a new one
			new Float:Time = get_cvar_float("csdm_item_time")
			set_task(Time, "replenish", 0, Item, 2)
		}
		if (dbug) {
			log_to_file("csdm-debug.txt", "replenish(%d) EntId[%d]=%d", id, id, EntId[id])
		}
	}
}

bool:destroyPack(pid)
{
	//This function will remove a pack by ENTID and clear index space for it
	if (!pid) {
		return false
	}
	
	new teID = PackId[pid]
	
	PackId[pid] = 0
	PackAmmo[pid][0] = 0
	PackAmmo[pid][1] = 0
	PackAmmo[pid][2] = 0
	PackAmmo[pid][3] = 0
	PackGren[pid][0] = 0
	PackGren[pid][1] = 0
	PackGren[pid][2] = 0
	
	if (dbug) {
		log_to_file("csdm-debug.txt", "destroyPack(%d): teID=%d", pid, teID)
	}
	
	if (destroyTempEnt(teID)) {
		return true
	} else {
		return false
	}
	
	return false
}

createTempEnt(entid)
{
	new first = 1
	
	for (new i=1; i<MAX_TEMPENTS; i++) {
		if (TempEnt[i] == entid) {
			//wierded out!  destroy the offender.
			destroyTempEnt(i)
			first = i
		}
	}
	
	new teID = findNextTempEnt(first)
	
	TempEnt[teID] = entid
	
	if (dbug) {
		log_to_file("csdm-debug.txt", "createTempEnt(%d) teID=%d", entid, teID)
	}
	
	return teID
}

findNextTempEnt(id=1)
{
	//This function will search for an index to store tempents
	for (new i=1; i<MAX_TEMPENTS; i++) {
		if (!TempEnt[i]) {
			return i
		}
	}
	
	destroyTempEnt(id)
	
	return id
}

findTempEnt(entid)
{
	for (new i=1; i<MAX_TEMPENTS; i++) {
		if (TempEnt[i] == entid) {
			return i
		}
	}
	
	return 0
}

bool:destroyTempEnt(id)
{
	if (!id) {
		return false
	}
	if (dbug) {
		log_to_file("csdm-debug.txt", "destroyTempEnt(%d) TempEnt[%d]=%d", id, id, TempEnt[id])
	}
	if (TempEnt[id] > 32 && TempEnt[id]) {
		rment(TempEnt[id])
		TempEnt[id] = 0
	} else {
		TempEnt[id] = 0
		return false
	}
	
	return true
}

findNextTask()
{
	for (new i=1; i<MAX_TASKS; i++) {
		if (!Tasks[i]) {
			return i
		}
	}
	
	destroyTask(1)
	
	return 1
}

findNextDrop()
{
	for (new i=1; i<MAX_DROP; i++) {
		if (!DropId[i] && !DropTask[i]) {
			return i
		}
	}
	
	destroyDrop(1)
	
	return 1
}

createDrop(entid)
{
	new id = findNextDrop()
	new taskid = findNextTask()
	new teID = createTempEnt(entid)
	new Float:Time = get_cvar_float("csdm_delete_time")
	new Drop[2]
	
	DropId[id] = teID
	DropTask[id] = taskid
	Drop[0] = id
	
	set_task(Time, "timed_rem_drop", taskid, Drop, 2)

	
	return id
}

findDrop(teID)
{
	for (new i=1; i<MAX_DROP; i++) {
		if (DropId[i] == teID) {
			return i
		}
	}
	
	return 0
}

destroyTask(id)
{
	if (id && Tasks[id]) {
		remove_task(Tasks[id])
		Tasks[id] = 0
	}
	
	return id
}

destroyDrop(id)
{
	new teID = DropId[id]
	new taskid = DropTask[id]
	
	destroyTempEnt(teID)
	DropId[id] = 0
	destroyTask(taskid)
	DropTask[id] = 0
	
	return id
}

findNextZeroPack()
{
	//This function will search for an index to store pack data
	new ret
	
	for (new i=1; i<MAX_DROP; i++) {
		if (!PackId[i]) {
			return i
		}
	}

	ret = destroyPack(1)
	
	return ret
}

createPack(id, Origin[3])
{
	new Float:Vec[3]
	new Float:Time = get_cvar_float("csdm_delete_time")
	new pid = findNextZeroPack()
	
	IVecFVec(Origin, Vec)
	
	//Create physical pack
	new entid = mkent("info_target")
	//Now, a pack is actually a tempent.
	if (entid) {
		new teID = createTempEnt(entid)
		PackId[pid] = teID
		Entvars_Set_String(entid, EV_SZ_classname, "drop_pack")
		ENT_SetModel(entid, "models/w_weaponbox.mdl")
		ENT_SetOrigin(entid, Vec)
		Entvars_Set_Int(entid, EV_INT_solid, 1)
		Entvars_Set_Int(entid, EV_INT_movetype, 6)
		new wps[32], num, type
		get_user_weapons(id, wps, num)
		for (new i=0; i<num; i++) {
			//populate the pack
			type = getWepAmmoType(wps[i])
			if (type > 0 && type < 5) {
				PackAmmo[pid][type-1] = wps[i]
			}
			if (type == 5) {
				if (wps[i] == CSW_HEGRENADE) {
					PackGren[pid][2] = CSW_HEGRENADE
				}
				if (get_cvar_num("csdm_allow_smoke")) {
					if (wps[i] == CSW_SMOKEGRENADE) {
						PackGren[pid][1] = CSW_SMOKEGRENADE
					}
				}
				if (wps[i] == CSW_FLASHBANG) {
					PackGren[pid][0] = CSW_FLASHBANG
				}
			}
		}
		if (Time > 30.0) {
			Time = 30.0
		}
		new Drop[2]
		Drop[0] = pid
		if (dbug) {
			log_to_file("csdm-debug.txt", "createPack(%d) pid=%d teID=%d entid=%d", id, pid, teID, entid)
		}
		set_task(Time, "delete_drop_pack", 0, Drop, 2)
	}
	
	return pid
}

public delete_drop_pack(data[])
{
	new pid = data[0]
	
	destroyPack(pid)

	return PLUGIN_CONTINUE
}

bool:canGetAmmo(id, ammo)
{
	new c, a
	switch (ammo) {
		case PISTOL_AMMO:
		{
			get_user_ammo(id, CSW_DEAGLE, c, a)
			if (a<getMaxAmmo(CSW_DEAGLE)) {
				return true
			}
			get_user_ammo(id, CSW_P228, c, a)
			if (a<getMaxAmmo(CSW_P228)) {
				return true
			}
			get_user_ammo(id, CSW_USP, c, a)
			if (a<getMaxAmmo(CSW_USP)) {
				return true
			}
			get_user_ammo(id, CSW_GLOCK18, c, a)
			if (a<getMaxAmmo(CSW_GLOCK18)) {
				return true
			}
			get_user_ammo(id, CSW_FIVESEVEN, c, a)
			if (a<getMaxAmmo(CSW_FIVESEVEN)) {
				return true
			}
		}
		
		case SHOTGUN_AMMO:
		{
			get_user_ammo(id, CSW_XM1014, c, a)
			if (a<getMaxAmmo(CSW_XM1014)) {
				return true
			}
		}
		
		case SMG_AMMO:
		{
			get_user_ammo(id, CSW_P90, c, a)
			if (a<getMaxAmmo(CSW_P90)) {
				return true
			}
			get_user_ammo(id, CSW_MP5NAVY, c, a)
			if (a<getMaxAmmo(CSW_MP5NAVY)) {
				return true
			}
			get_user_ammo(id, CSW_MAC10, c, a)
			if (a<getMaxAmmo(CSW_MAC10)) {
				return true
			}
		}
		
		case RIFLE_AMMO:
		{
			get_user_ammo(id, CSW_M4A1, c, a)
			if (a<getMaxAmmo(CSW_M4A1)) {
				return true
			}
			get_user_ammo(id, CSW_AK47, c, a)
			if (a<getMaxAmmo(CSW_AK47)) {
				return true
			}
			get_user_ammo(id, CSW_AWP, c, a)
			if (a<getMaxAmmo(CSW_AWP)) {
				return true
			}
			get_user_ammo(id, CSW_M249, c, a)
			if (a<getMaxAmmo(CSW_M249)) {
				return true
			}
		}
	}
	
	return false
}

bool:canGetGun(id, g_wp)
{
	new g_slot = getWepSlot(g_wp)
	new wps[32], num, ammo, u_slot, u_max
	new clip
	new bool:has = false		//have this weapon?
	new bool:hold = true		//can hold more in slot?
	
	if (!g_wp || !id) {
		return false
	}
	
	get_user_weapons(id, wps, num)
	
	for (new i=0; i<num; i++) {		//does the user have this weapon?
		get_user_ammo(id, wps[i], ammo, clip)
		u_slot = getWepSlot(wps[i])
		if ((u_slot == g_slot) && (g_slot != 4)) {
			if (get_cvar_num("csdm_hold_many")!=1) {
				hold = false
			}
		}
		
		if (wps[i] == g_wp) {		//make sure user has this weapon
			u_max = getMaxAmmo(wps[i])
			if (clip < u_max) {
				return true
			}
			has = true
		}
	}
	
	if (!has) {	//Make sure this user does not have this weapon and has slot room
		if (hold) {
			return true
		} else {
			if (get_cvar_num("csdm_hold_many")) {
				return true
			}
			return false
		}
	} else {
		return false
	}
	
	return false
}

findPackId(teID)
{
	//Given an entity id, this will return the index to it in the pack list
	new id = 0
	
	if (!teID) {
		return 0
	}
	
	for (new i=0; i<MAX_DROP; i++) {
		if (PackId[i] == teID) {
			id = i
		}
	}
	
	return id
}

findEntId(entid)
{
	//Given an entity id, this will return the index to it in the entity list
	new id = 0
	
	if (!entid) {
		return 0
	}
	
	for (new i=1; i<=EntCount; i++) {
		if (EntId[i] == entid) {
			id = i
		}
	}
	
	return id
}

getWepModel(wp, model[], imax)
{
	switch (wp) {
		case CSW_P228:
			copy(model, imax, "models/w_p228.mdl")
		case CSW_SCOUT:
			copy(model, imax, "models/w_scout.mdl")
		case CSW_HEGRENADE:
			copy(model, imax, "models/w_hegrenade.mdl")
		case CSW_XM1014:
			copy(model, imax, "models/w_xm1014.mdl")
		case CSW_C4:
			copy(model, imax, "models/w_backpack.mdl")
		case CSW_MAC10:
			copy(model, imax, "models/w_mac10.mdl")
		case CSW_AUG:
			copy(model, imax, "models/w_aug.mdl")
		case CSW_SMOKEGRENADE:
			copy(model, imax, "models/w_smokegrenade.mdl")
		case CSW_ELITE:
			copy(model, imax, "models/w_elite.mdl")
		case CSW_FIVESEVEN:
			copy(model, imax, "models/w_fiveseven.mdl")
		case CSW_UMP45:
			copy(model, imax, "models/w_ump45.mdl")
		case CSW_SG550:
			copy(model, imax, "models/w_sg550.mdl")
		case CSW_GALI:
			copy(model, imax, "models/w_galil.mdl")
		case CSW_FAMAS:
			copy(model, imax, "models/w_famas.mdl")
		case CSW_USP:
			copy(model, imax, "models/w_usp.mdl")
		case CSW_GLOCK18:
			copy(model, imax, "models/w_glock18.mdl")
		case CSW_AWP:
			copy(model, imax, "models/w_awp.mdl")
		case CSW_MP5NAVY:
			copy(model, imax, "models/w_mp5.mdl")
		case CSW_M249:
			copy(model, imax, "models/w_m249.mdl")
		case CSW_M3:
			copy(model, imax, "models/w_m3.mdl")
		case CSW_M4A1:
			copy(model, imax, "models/w_m4a1.mdl")
		case CSW_TMP:
			copy(model, imax, "models/w_tmp.mdl")
		case CSW_G3SG1:
			copy(model, imax, "models/w_g3sg1.mdl")
		case CSW_FLASHBANG:
			copy(model, imax, "models/w_flashbang.mdl")
		case CSW_DEAGLE:
			copy(model, imax, "models/w_deagle.mdl")
		case CSW_SG552:
			copy(model, imax, "models/w_sg552.mdl")
		case CSW_AK47:
			copy(model, imax, "models/w_ak47.mdl")
		case CSW_KNIFE:
			copy(model, imax, "models/w_knife.mdl")
		case CSW_P90:
			copy(model, imax, "models/w_p90.mdl")
	}
	
	return 1
}

getWepId(wp[])
{
	if (equali(wp, "weapon_p228")) {
		return CSW_P228
	} else if (equali(wp, "weapon_scout")) {
		return CSW_SCOUT
	} else if (equali(wp, "weapon_hegrenade")) {
		return CSW_HEGRENADE
	} else if (equali(wp, "weapon_xm1014")) {
		return CSW_XM1014
	} else if (equali(wp, "weapon_c4")) {
		return CSW_C4
	} else if (equali(wp, "weapon_mac10")) {
		return CSW_MAC10
	} else if (equali(wp, "weapon_aug")) {
		return CSW_AUG
	} else if (equali(wp, "weapon_smokegrenade")) {
		return CSW_SMOKEGRENADE
	} else if (equali(wp, "weapon_elite")) {
		return CSW_ELITE
	} else if (equali(wp, "weapon_fiveseven")) {
		return CSW_FIVESEVEN
	} else if (equali(wp, "weapon_ump45")) {
		return CSW_UMP45
	} else if (equali(wp, "weapon_sg550")) {
		return CSW_SG550
	} else if (equali(wp, "weapon_galil")) {
		return CSW_GALI
	} else if (equali(wp, "weapon_famas")) {
		return CSW_FAMAS
	} else if (equali(wp, "weapon_usp")) {
		return CSW_USP
	} else if (equali(wp, "weapon_glock18")) {
		return CSW_GLOCK18
	} else if (equali(wp, "weapon_awp")) {
		return CSW_AWP
	} else if (equali(wp, "weapon_mp5navy")) {
		return CSW_MP5NAVY
	} else if (equali(wp, "weapon_m249")) {
		return CSW_M249
	} else if (equali(wp, "weapon_m3")) {
		return CSW_M3
	} else if (equali(wp, "weapon_m4a1")) {
		return CSW_M4A1
	} else if (equali(wp, "weapon_tmp")) {
		return CSW_TMP
	} else if (equali(wp, "weapon_g3sg1")) {
		return CSW_G3SG1
	} else if (equali(wp, "weapon_flashbang")) {
		return CSW_FLASHBANG
	} else if (equali(wp, "weapon_deagle")) {
		return CSW_DEAGLE
	} else if (equali(wp, "weapon_sg552")) {
		return CSW_SG552
	} else if (equali(wp, "weapon_ak47")) {
		return CSW_AK47
	} else if (equali(wp, "weapon_knife")) {
		return CSW_KNIFE
	} else if (equali(wp, "weapon_p90")) {
		return CSW_P90
	}
	
	return 0
}

giveAmmoType(id, ammotype)
{
	switch (ammotype) {
		case PISTOL_AMMO:
		{
			give_item(id, "ammo_357sig")
			give_item(id, "ammo_57mm")
			give_item(id, "ammo_45acp")
			give_item(id, "ammo_50ae")
			give_item(id, "ammo_9mm")
		}
		case SHOTGUN_AMMO:
		{
			give_item(id, "ammo_buckshot")
		}
		case SMG_AMMO:
		{
			give_item(id, "ammo_9mm")
			give_item(id, "ammo_45acp")
		}
		case RIFLE_AMMO:
		{
			give_item(id, "ammo_762nato")
			give_item(id, "ammo_556nato")
			give_item(id, "ammo_338magnum")
			give_item(id, "ammo_556natobox")
		}
	}
}

getWepAmmoType(wp)
{
	switch (wp)
	{
		case CSW_P228:
			return 1
		case CSW_SCOUT:
			return 4
		case CSW_HEGRENADE:
			return 5
		case CSW_XM1014:
			return 2
		case CSW_MAC10:
			return 3
		case CSW_AUG:
			return 4
		case CSW_SMOKEGRENADE:
			return 5
		case CSW_ELITE:
			return 1
		case CSW_FIVESEVEN:
			return 1
		case CSW_UMP45:
			return 3
		case CSW_SG550:
			return 4
		case CSW_GALI:
			return 4
		case CSW_FAMAS:
			return 4
		case CSW_USP:
			return 1
		case CSW_GLOCK18:
			return 1
		case CSW_AWP:
			return 4
		case CSW_MP5NAVY:
			return 3
		case CSW_M249:
			return 4
		case CSW_M3:
			return 2
		case CSW_M4A1:
			return 4
		case CSW_TMP:
			return 3
		case CSW_G3SG1:
			return 4
		case CSW_FLASHBANG:
			return 5
		case CSW_DEAGLE:
			return 1
		case CSW_SG552:
			return 4
		case CSW_AK47:
			return 4
		case CSW_P90:
			return 3
	}
	
	return 0
}

getWepSlot(wp)
{
	switch (wp)
	{
		case CSW_P228:
			return 3
		case CSW_SCOUT:
			return 2
		case CSW_HEGRENADE:
			return 4
		case CSW_XM1014:
			return 2
		case CSW_C4:
			return 5
		case CSW_MAC10:
			return 2
		case CSW_AUG:
			return 2
		case CSW_SMOKEGRENADE:
			return 5
		case CSW_ELITE:
			return 3
		case CSW_FIVESEVEN:
			return 3
		case CSW_UMP45:
			return 2
		case CSW_SG550:
			return 2
		case CSW_GALI:
			return 2
		case CSW_FAMAS:
			return 2
		case CSW_USP:
			return 3
		case CSW_GLOCK18:
			return 3
		case CSW_AWP:
			return 2
		case CSW_MP5NAVY:
			return 2
		case CSW_M249:
			return 2
		case CSW_M3:
			return 2
		case CSW_M4A1:
			return 2
		case CSW_TMP:
			return 2
		case CSW_G3SG1:
			return 2
		case CSW_FLASHBANG:
			return 4
		case CSW_DEAGLE:
			return 3
		case CSW_SG552:
			return 2
		case CSW_AK47:
			return 2
		case CSW_KNIFE:
			return 1
		case CSW_P90:
			return 2
	}
	
	return 0
}

getMaxAmmo(wp)
{
	switch (wp)
	{
		case CSW_P228:
			return 52
		case CSW_SCOUT:
			return 90
		case CSW_HEGRENADE:
			return 1
		case CSW_XM1014:
			return 32
		case CSW_C4:
			return 1
		case CSW_MAC10:
			return 100
		case CSW_AUG:
			return 90
		case CSW_SMOKEGRENADE:
			return 1
		case CSW_ELITE:
			return 120
		case CSW_FIVESEVEN:
			return 100
		case CSW_UMP45:
			return 100
		case CSW_SG550:
			return 90
		case CSW_GALI:
			return 90
		case CSW_FAMAS:
			return 90
		case CSW_USP:
			return 100
		case CSW_GLOCK18:
			return 120
		case CSW_AWP:
			return 30
		case CSW_MP5NAVY:
			return 120
		case CSW_M249:
			return 200
		case CSW_M3:
			return 32
		case CSW_M4A1:
			return 90
		case CSW_TMP:
			return 120
		case CSW_G3SG1:
			return 90
		case CSW_FLASHBANG:
			return 2
		case CSW_DEAGLE:
			return 35
		case CSW_SG552:
			return 90
		case CSW_AK47:
			return 90
		case CSW_KNIFE:
			return 1
		case CSW_P90:
			return 100
	}
	
	return 0
}

mkent(ent[])
{
	new entid
	
	if (Entities>=500) {
		if (dbug) {
			log_to_file("csdm-debug.txt", "mkent(^"%s^"): entity creation failed", ent)
		}
		return 0
	} else {
		entid = CreateEntity(ent)
		Entities++	//this is a stupid and silly check
		if (dbug) {
			log_to_file("csdm-debug.txt", "mkent(^"%s^"): entid=%d", ent, entid)
		}
	}
	
	return entid
}

rment(entid)
{
	if (entid > 32) {
		RemoveEntity(entid)
		Entities--
	}
	
	return entid
}