/* gm_pyro.sma is part of GabenMod
*  Copyright 2005-2006 by Basic-Master (AMX Mod X Dev Team)
*
*  Yes, Gabe, this mod is dedicated to you, we hope you like
*  it as much as we do! Nevertheless, VALVe, your code still
*  sucks. Especially your HL2SDK, it's a nightmare. Someday
*  Gaben will appear and eat you and your SDK >_<. HE WILL!
*
*/

#include <amxmodx>
#include <amxmisc>
#include "gabenmod"
#include <fakemeta>
#include <cstrike>
#if defined CSDM_COMPILATION
#include <csdm>
#endif

#define BURN_MAXDMG 35
#define BURN_MINDMG 5
#define SHOOT_INTERVAL 0.2
#define JETPACK_INTERVAL 0.2
#define JETPACK_VELOCITY 300.0
#define JETPACK_AIMVEL 30

#define JETPACK_REQP 91
#define AMMO_REQP 84
#define HE_REQP 70
#define XM1014_REQP 56

#define AllKeys (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9) // Menu keys

#define PLUGIN "GM Pyro"
#define AUTHOR "Basic-Master"

new gHasClass[33]
new gCanShoot[33]
new gCanFly[33]
new gWpn[33]
/* Skills for the buymenu
*
* gSkills[0] = Jetpack (with rightclick)
* gSkills[1] = Extra flamethrower ammo
* gSkills[2] = HE Grenades
* gSkills[3] = XM1014
*
*/
new gSkills[33][4]
new gVEgon, gPEgon
new gFire
new temp[256]
new pt_ammo
new wpn_wpn, wpn_clip, wpn_ammo

new gIsEnabled = 1

public plugin_init() {
	register_plugin(PLUGIN, GABENMOD_VERSION, AUTHOR)
	register_event("CurWeapon", "hook_wpn", "b")
	register_forward(FM_PlayerPreThink, "hook_prethink")
	
	gm_RegClass("Pyro", "Flame thrower", "cmd_init", "cmd_buy", "cmd_buy", 0)
	register_menucmd(register_menuid("BuyMenu"), AllKeys, "PressedBuyMenu")
	
	gIsEnabled = gm_IsEnabled()
}

public plugin_precache() {
	// Precache models+sounds
	gFire = engfunc(EngFunc_PrecacheModel, "sprites/explode1.spr")
	engfunc(EngFunc_PrecacheModel, "models/v_egon.mdl")
	engfunc(EngFunc_PrecacheModel, "models/p_egon.mdl")
	engfunc(EngFunc_PrecacheSound, "ambience/flameburst1.wav")
	engfunc(EngFunc_PrecacheSound, "ambience/burning1.wav")
	engfunc(EngFunc_PrecacheSound, "weapons/357_cock1.wav")
	
	gVEgon = engfunc(EngFunc_AllocString, "models/v_egon.mdl")
	gPEgon = engfunc(EngFunc_AllocString, "models/p_egon.mdl")
}

public hook_wpn(id) {
	if (!gIsEnabled || !gHasClass[id] || !gm_IsValidPlayer(id)) return PLUGIN_CONTINUE
	
	engfunc(EngFunc_SetClientMaxspeed, id, 350.0)
	set_pev(id, pev_maxspeed, 350.0)
	
	wpn_wpn = get_user_weapon(id, wpn_clip, wpn_ammo)
	if (wpn_wpn == CSW_SMOKEGRENADE && gWpn[id] != wpn_wpn) {
		// MAGIC
		set_pev(id, pev_viewmodel, gVEgon)
		set_pev(id, pev_weaponmodel, gPEgon)
		set_animation(id, 0)
	}
	gWpn[id] = wpn_wpn
	
	return PLUGIN_CONTINUE
}

public hook_prethink(id) {
	if (gIsEnabled && gHasClass[id] && is_user_alive(id) && gWpn[id] == CSW_SMOKEGRENADE) {
		if (gm_IsValidPlayer(id)) {
			// Normal attack
			if (gCanShoot[id] && pev(id, pev_button)&IN_ATTACK) {
				pt_ammo = cs_get_user_bpammo(id, CSW_SMOKEGRENADE)
				if (pt_ammo == 0) {
					if (is_user_bot(id))
						client_cmd(id, "slot1")
					else
						emit_sound(id, CHAN_WEAPON, "weapons/357_cock1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
				}
				else
					fire_flamethrower(id, pt_ammo)
				gCanShoot[id] = 0
				set_task(SHOOT_INTERVAL, "task_reset", id)
			}
			// Jetpack if available
			if (gCanFly[id] && gSkills[id][0] && pev(id, pev_button)&IN_ATTACK2) {
				pt_ammo = cs_get_user_bpammo(id, CSW_SMOKEGRENADE)
				if (pt_ammo == 0)
					emit_sound(id, CHAN_WEAPON, "weapons/357_cock1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
				else {
					new Float:fVec[3], Float:fVec2[3], args[6]
					new origin[3], velocity[3]
					// effects+velocity
					set_pev(id, pev_weaponanim, 8)
					gm_VelocityByAim(id, JETPACK_AIMVEL, fVec2)
					pev(id, pev_velocity, fVec)
					fVec[0] = floatadd(fVec[0], fVec2[0])
					fVec[1] = floatadd(fVec[1], fVec2[1])
					fVec[2] = floatadd(floatadd(fVec[2], JETPACK_VELOCITY), fVec2[2])
					set_pev(id, pev_velocity, fVec)
					// flame effects
					velocity[0] = 0
					velocity[1] = 0
					velocity[2] = floatround(fVec[2])
					pev(id, pev_origin, fVec)
					origin[0] = floatround(fVec[0])
					origin[1] = floatround(fVec[1])
					origin[2] = floatround(fVec[2])
					args[0] = origin[0]
					args[1] = origin[1]
					args[2] = origin[2]
					args[3] = 0
					args[4] = 0
					args[5] = -10
					set_task(0.1, "task_spray", 0, args, 6, "a", 2)
					set_task(1.0, "task_resetanim", id)
					// sound+ammo
					emit_sound(id, CHAN_WEAPON, "ambience/flameburst1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
					cs_set_user_bpammo(id, CSW_SMOKEGRENADE, pt_ammo - 1)
				}
				gCanFly[id] = 0
				set_task(JETPACK_INTERVAL, "task_resetfly", id)
			}
		}
		
		if (pev(id, pev_button)&IN_ATTACK)
			set_pev(id, pev_button, pev(id, pev_button)&~IN_ATTACK)
		if (pev(id, pev_oldbuttons)&IN_ATTACK) {
			set_animation(id, 0)
			set_pev(id, pev_oldbuttons, pev(id, pev_oldbuttons)&~IN_ATTACK)
		}
	}
	
	return FMRES_IGNORED
}

public task_resetanim(id) {
	new tmp1, tmp2
	if (is_user_connected(id) && get_user_weapon(id, tmp1, tmp2) == CSW_SMOKEGRENADE)
		set_animation(id, 0)
}

public task_reset(id) {
	gCanShoot[id] = 1
}

public task_resetfly(id) {
	gCanFly[id] = 1
}

public gm_Respawn(id) {
	if (!gIsEnabled || !gm_IsValidPlayer(id))
		return
	
	if (gHasClass[id]) {
		client_print(id, print_chat, "[GM] Switch to Smoke Grenade to use your flamethrower.")
		
		set_user_health(id, 115.0)
		cs_set_user_armor(id, 60, CS_ARMOR_KEVLAR)
		
		set_task(0.1, "task_giveweapons", id)
	}
}

public task_giveweapons(id) {
	if (gIsEnabled && gm_IsValidPlayer(id)) {
		gm_StripWeapons(id)
		/* Knife */
		gm_CreateOwnedItem(id, "weapon_knife")
		/* Fiveseven */
		gm_CreateOwnedItem(id, "weapon_fiveseven")
		gm_CreateOwnedItem(id, "ammo_57mm")
		gm_CreateOwnedItem(id, "ammo_57mm")
		/* P90 */
		gm_CreateOwnedItem(id, "weapon_p90")
		gm_CreateOwnedItem(id, "ammo_338magnum")
		gm_CreateOwnedItem(id, "ammo_338magnum")
		/* Smokegrenade/flamethrower */
		gm_CreateOwnedItem(id, "weapon_smokegrenade")
		if (gSkills[id][2]) { // HE Grenades
			gm_CreateOwnedItem(id, "weapon_hegrenade")
			cs_set_user_bpammo(id, CSW_HEGRENADE, 3)
		}
		if (gSkills[id][3]) { // XM1014
			gm_CreateOwnedItem(id, "weapon_xm1014")
			gm_CreateOwnedItem(id, "ammo_buckshot")
			gm_CreateOwnedItem(id, "ammo_buckshot")
		}
		if (gSkills[id][1]) { // Extra ammo
			cs_set_user_bpammo(id, CSW_SMOKEGRENADE, 150)
			if (gSkills[id][2])
				cs_set_user_bpammo(id, CSW_HEGRENADE, 4)
			if (gSkills[id][3]) {
				gm_CreateOwnedItem(id, "ammo_57mm")
				gm_CreateOwnedItem(id, "ammo_57mm")
				gm_CreateOwnedItem(id, "ammo_buckshot")
				gm_CreateOwnedItem(id, "ammo_buckshot")
			}
		}
		else
			cs_set_user_bpammo(id, CSW_SMOKEGRENADE, 100)
		
		engclient_cmd(id, "weapon_smokegrenade")
		engfunc(EngFunc_SetClientMaxspeed, id, 350.0)
		set_pev(id, pev_maxspeed, 350.0)
	}
}

set_animation(id, anim) {
	set_pev(id, pev_weaponanim, anim)
	
	message_begin(MSG_ONE, SVC_WEAPONANIM, {0, 0, 0}, id)
	write_byte(anim)
	write_byte(pev(id, pev_body))
	message_end()
}  

public cmd_init(id, hasclass) {
	gHasClass[id] = hasclass
	gCanShoot[id] = 1
	gCanFly[id] = 1
	if (gIsEnabled && hasclass)
		gm_Respawn(id)
	
	for(new i=0;i<4;i++)
		gSkills[id][i] = 0
}

/* Original code by jtp10181/Ludwig van */

fire_flamethrower(id, ammo) {
	new vec[3]
	new aimvec[3]
	new velocityvec[3]
	new length
	new speed = 10
	get_user_origin(id, vec)
	get_user_origin(id, aimvec, 2)
	new dist = get_distance(vec, aimvec)+get_ent_speed(id)
	new radius = 75
	
	vec[2] -= 20

	if (dist < 50) {
		radius = 2
		speed = 5
	}
	else if (dist < 150) {
		speed = 5
		radius = 50
	}
	else if (dist < 200) {
		speed = 5
		radius = 90
	}
	else if (dist < 250) {
		speed = 6
		radius = 90
	}
	else if (dist < 350)
		speed = 7
	else if (dist < 450)
		speed = 8
	else if (dist < 500) {
		speed = 9
		dist = 500
	}
	
	velocityvec[0] = aimvec[0]-vec[0]
	velocityvec[1] = aimvec[1]-vec[1]
	velocityvec[2] = aimvec[2]-vec[2]
	length = sqroot(velocityvec[0]*velocityvec[0]+velocityvec[1]*velocityvec[1]+velocityvec[2]*velocityvec[2])
	velocityvec[0] = velocityvec[0]*speed/length
	velocityvec[1] = velocityvec[1]*speed/length
	velocityvec[2] = velocityvec[2]*speed/length

	new args[6]
	args[0] = vec[0]
	args[1] = vec[1]
	args[2] = vec[2]
	args[3] = velocityvec[0]
	args[4] = velocityvec[1]
	args[5] = velocityvec[2]
	
	if (length <= 1) length = 2
	
	new wallorigin[3]
	if (!burn_damage(id, vec, wallorigin, radius, length)) {
		dist = get_distance(vec, wallorigin)
		if (dist < 50)
			speed = 5
		else if (dist < 200)
			speed = 5
		else if (dist < 250)
			speed = 6
		else if (dist < 350)
			speed = 7
		else if (dist < 450)
			speed = 8
		else if (dist < 500) {
			speed = 9
			dist = 500
		}
		
		velocityvec[0] = aimvec[0]-vec[0]
		velocityvec[1] = aimvec[1]-vec[1]
		velocityvec[2] = aimvec[2]-vec[2]
		length = sqroot(velocityvec[0]*velocityvec[0]+velocityvec[1]*velocityvec[1]+velocityvec[2]*velocityvec[2])
		velocityvec[0] = velocityvec[0]*speed/length
		velocityvec[1] = velocityvec[1]*speed/length
		velocityvec[2] = velocityvec[2]*speed/length
		args[3] = velocityvec[0]
		args[4] = velocityvec[1]
		args[5] = velocityvec[2]
	}
	
	set_task(0.1, "task_spray", 0, args, 6, "a", 2)
	set_animation(id, 7)
	cs_set_user_bpammo(id, CSW_SMOKEGRENADE, ammo - 1)
	emit_sound(id, CHAN_WEAPON, "ambience/flameburst1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
}

public task_spray(args[]) {
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(120) // TE_SPRAY - Throws a shower of sprites or models
	write_coord(args[0]) // start pos
	write_coord(args[1])
	write_coord(args[2])
	write_coord(args[3]) // velocity
	write_coord(args[4])
	write_coord(args[5])
	write_short(gFire) // spr
	write_byte(16) // count
	write_byte(70) // speed
	write_byte(100) //(noise)
	write_byte(5) // (rendermode)
	message_end()

	return PLUGIN_CONTINUE
}


burn_damage(id, origin[3], wallorigin[3], radius, length) {
	length = length * 2
	length = length / 3
	
	new i, ent, class[32], damage
	new Float:fOrigin[3], Float:fVelocity[3]
	
	for(i=radius/2;i<length;i+=radius/2) {
		fOrigin[0] = float(origin[0])
		fOrigin[1] = float(origin[1])
		fOrigin[2] = float(origin[2])
		
		gm_VelocityByAim(id, i, fVelocity)
		fOrigin[0] = floatadd(fOrigin[0], fVelocity[0])
		fOrigin[1] = floatadd(fOrigin[1], fVelocity[1])
		fOrigin[2] = floatadd(fOrigin[2], fVelocity[2])
		
		// Check for walls
		ent = 0
		while ((ent = engfunc(EngFunc_FindEntityInSphere, ent, fOrigin, float(radius))) > 0) {
			if (ent != id) {
				pev(ent, pev_classname, class, 31)
				pev(ent, pev_origin, fVelocity)
				
				if (pev(ent, pev_owner) == 0 && vec_distance(fOrigin, fVelocity) < 130 && equali("gm_wall", class)) {
					wallorigin[0] = floatround(fVelocity[0])
					wallorigin[1] = floatround(fVelocity[1])
					wallorigin[2] = floatround(fVelocity[2])
					return 0
				}
				else {
					damage = floatround(float(vec_distance(fOrigin, fVelocity)) / float(length) * BURN_MAXDMG)
					if (damage < BURN_MINDMG)
						damage = BURN_MINDMG
						
					damage /= 2
					
					if (is_user_connected(ent)) {
						if (get_cvar_num("mp_friendlyfire") || (!get_cvar_num("mp_friendlyfire") && cs_get_user_team(ent) != cs_get_user_team(id))) {
							gm_ExtraDamage(id, ent, damage, "flamethrower", 0, DMG_BURN)
							if (task_exists(ent+400))
								remove_task(ent+400)
							else
								emit_sound(ent, CHAN_BODY, "ambience/burning1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
							set_task(1.5, "stop_burn", ent+400)
						}
					}
					else if (pev_valid(ent))
						gm_FakeDamage(ent, "flamethrower", float(damage), DMG_BURN)
				}
			}
		}
	}
	
	return 1
}

public stop_burn(id) {
	id -= 400
	if (pev_valid(id) || is_user_connected(id))
		emit_sound(id, CHAN_BODY, "ambience/burning1.wav", 1.0, ATTN_NORM, (1<<5), PITCH_NORM)
}

/* Buy menu */

public cmd_buy(id) {
	if (gIsEnabled)
		show_buymenu(id)
}

show_buymenu(id) {
	new keys = (1<<9)
	temp = "\yBuy menu^n^n"
	/* Jetpack */
	if (gSkills[id][0]) {
		add(temp, 255, "\w1. Drop Jetpack^n")
		keys |= (1<<0)
	}
	else if (gm_GetPoints(id) >= JETPACK_REQP) {
		addpointitem("\w1. Buy Jetpack", JETPACK_REQP)
		keys |= (1<<0)
	}
	else
		addpointitem("\d1. Buy Jetpack", JETPACK_REQP)
	/* Extra Ammo */
	if (gSkills[id][1]) {
		add(temp, 255, "\w2. Drop Extra Ammo^n")
		keys |= (1<<1)
	}
	else if (gm_GetPoints(id) >= AMMO_REQP) {
		addpointitem("\w2. Buy Extra Ammo", AMMO_REQP)
		keys |= (1<<1)
	}
	else
		addpointitem("\d2. Buy Extra Ammo", AMMO_REQP)
	/* HE Grenades */
	if (gSkills[id][2]) {
		add(temp, 255, "\w3. Drop HE Grenades^n")
		keys |= (1<<2)
	}
	else if (gm_GetPoints(id) >= HE_REQP) {
		addpointitem("\w3. Buy HE Grenades", HE_REQP)
		keys |= (1<<2)
	}
	else
		addpointitem("\d3. Buy HE Grenades", HE_REQP)
	/* XM1014 */
	if (gSkills[id][3]) {
		add(temp, 255, "\w4. Drop XM 1014^n")
		keys |= (1<<3)
	}
	else if (gm_GetPoints(id) >= XM1014_REQP) {
		addpointitem("\w4. Buy XM 1014", XM1014_REQP)
		keys |= (1<<3)
	}
	else
		addpointitem("\d4. Buy XM 1014", XM1014_REQP)
	add(temp, 255, "^n\w0. Exit")
	
	show_menu(id, keys, temp, -1, "BuyMenu") // Display menu
}

addpointitem(title[], points) {
	new tmp[64]
	format(tmp, 63, "%s (%d points)^n", title, points)
	add(temp, 255, tmp)
}

public PressedBuyMenu(id, key) {
	if (!gIsEnabled) return
	
	switch (key) {
		case 0: { // Jetpack
			if (gSkills[id][0]) {
				gm_AddPoints(id, JETPACK_REQP)
				gSkills[id][0] = 0
				client_print(id, print_chat, "[GM] You've dropped Jetpack and got %d points back.", JETPACK_REQP)
			}
			else if (gm_GetPoints(id) >= JETPACK_REQP) {
				gm_RemPoints(id, JETPACK_REQP)
				gSkills[id][0] = 1
				client_print(id, print_chat, "[GM] You've just bought Jetpack for %d points. Use rightclick to use it.", JETPACK_REQP)
			}
		}
		case 1: { // Extra Ammo
			if (gSkills[id][1]) {
				gm_AddPoints(id, AMMO_REQP)
				gSkills[id][1] = 0
				client_print(id, print_chat, "[GM] You've dropped Extra Ammo and got %d points back.", AMMO_REQP)
			}
			else if (gm_GetPoints(id) >= AMMO_REQP) {
				gm_RemPoints(id, AMMO_REQP)
				gSkills[id][1] = 1
				client_print(id, print_chat, "[GM] You've just bought Extra Ammo for %d points.", AMMO_REQP)
			}
		}
		case 2: { // HE Grenades
			if (gSkills[id][2]) {
				if (cs_get_user_bpammo(id, CSW_HEGRENADE) < 3)
					client_print(id, print_chat, "[GM] You must wait for your next respawn until you can drop this skill.")
				else {
					gm_AddPoints(id, HE_REQP)
					gSkills[id][2] = 0
					client_print(id, print_chat, "[GM] You've dropped the HE Grenades and got %d points back.", HE_REQP)
				}
			}
			else if (gm_GetPoints(id) >= HE_REQP) {
				gm_RemPoints(id, HE_REQP)
				gSkills[id][2] = 1
				gm_CreateOwnedItem(id, "weapon_hegrenade")
				if (gSkills[id][1])
					cs_set_user_bpammo(id, CSW_HEGRENADE, 4)
				else
					cs_set_user_bpammo(id, CSW_HEGRENADE, 3)
				client_print(id, print_chat, "[GM] You've just bought HE Grenades for %d points.", HE_REQP)
			}
		}
		case 3: { // XM 1014
			if (gSkills[id][3]) {
				gm_AddPoints(id, XM1014_REQP)
				gSkills[id][3] = 0
				client_print(id, print_chat, "[GM] You've dropped XM 1014 and got %d points back.", XM1014_REQP)
			}
			else if (gm_GetPoints(id) >= XM1014_REQP) {
				gm_RemPoints(id, XM1014_REQP)
				gSkills[id][3] = 1
				client_print(id, print_chat, "[GM] You've just bought XM 1014 for %d points.", XM1014_REQP)
			}
		}
		case 9: {
			return
		}
	}
	
	show_buymenu(id)
}
