/* gm_sniper.sma is part of GabenMod
*  Copyright 2005-2006 by Basic-Master (AMX Mod X Dev Team)
*
*  Yes, Gabe, this mod is dedicated to you, we hope you like
*  it as much as we do! Nevertheless, VALVe, your code still
*  sucks. Especially your HL2SDK, it's a nightmare. Someday
*  Gaben will appear and eat you and your SDK >_<. HE WILL!
*
*/

#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <fakemeta>
#include "gabenmod"
#if defined CSDM_COMPILATION
#include <csdm>
#endif

#define PLUGIN "GM Sniper"
#define AUTHOR "Basic-Master"

#define AllKeys (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9) // Menu keys

#define SCOUT_REQP 	0
#define AWP_REQP 	119
#define G3_REQP 	147
#define SG_REQP 	154

#define EXPLOSION_REQP 	70
#define BULLETS_REQP 	55
#define RELOAD_REQP 	35
#define SHWORD_REQP 	65

#define BULLETS_EXTRADMG 	75
#define BULLETS_EXTRADMG_AUTO	20

#define EXPLOSION_DMG		30
#define EXPLOSION_DMG_AUTO 	10

#define SHWORD_RADIUS 100.0
#define SHWORD_DMG 110
#define SHWORD_COOLDOWN 12.0
#define SHWORD_SELFDMG 20

// Menu+Callback
new mSelectionMenu 
new mcbSelectionMenu
// Some player-related variables
new gHasSniper[33]
new gHasExp[33]
new gHasBullets[33]
new gHasReload[33]
new gCurWeapon[33][2]
new gRifle[33]
new gHasShword[33]
new gNewSelectForbidden[33]

new gExpSprite
new temp[256]
new wpn_ammo, wpn_wpn, wpn_bpack, wpn_target
new wpn_hitpos[3], wpn_origin[3], wpn_weapon[32]
new Float:wpn_fvec1[3], Float:wpn_fvec2[3], Float:wpn_fvec3[3]
new pt_btn, pt_oldbtn, pt_tmp1, Float:pt_fVec[3]

new gAlreadyHurt[33]
new gJumpBlocked[33], gInJump[33], gInCooldown[33]

new gShockwave
new gIsEnabled

public plugin_init() {
	// Register stuff
	register_plugin(PLUGIN, GABENMOD_VERSION, AUTHOR)
	register_event("CurWeapon", "hook_wpn", "b")
	register_forward(FM_PlayerPreThink, "hook_prethink")
	gm_RegClass("Sniper", "Get a sniper rifle", "cmd_init", "cmd_menu", "cmd_buy", 0)
	
	
	// Menus
	/* Menu Selection menu */
	mSelectionMenu = menu_create("Selection menu", "mh_SelectionMenu")
	mcbSelectionMenu = menu_makecallback("mcb_SelectionMenu")
	// a function might be better here but this is actually faster
	#if SCOUT_REQP == 0
	menu_additem(mSelectionMenu, "Select Scout", "", ADMIN_ALL, mcbSelectionMenu)
	#else
	format(temp, 32, "Select Scout (%d points req)", SCOUT_REQP)
	menu_additem(mSelectionMenu, temp, "", ADMIN_ALL, mcbSelectionMenu)
	#endif
	#if AWP_REQP == 0
	menu_additem(mSelectionMenu, "Select AWP", "", ADMIN_ALL, mcbSelectionMenu)
	#else
	format(temp, 32, "Select AWP (%d points req)", AWP_REQP)
	menu_additem(mSelectionMenu, temp, "", ADMIN_ALL, mcbSelectionMenu)
	#endif
	#if G3_REQP == 0
	menu_additem(mSelectionMenu, "Select G3/SG-1", "", ADMIN_ALL, mcbSelectionMenu)
	#else
	format(temp, 32, "Select G3/SG-1 (%d points req)", G3_REQP)
	menu_additem(mSelectionMenu, temp, "", ADMIN_ALL, mcbSelectionMenu)
	#endif
	#if SG_REQP == 0
	menu_additem(mSelectionMenu, "Select SG-550", "", ADMIN_ALL, mcbSelectionMenu)
	#else
	format(temp, 32, "Select SG-550 (%d points req)", SG_REQP)
	menu_additem(mSelectionMenu, temp, "", ADMIN_ALL, mcbSelectionMenu)
	#endif
	menu_additem(mSelectionMenu, "Buy menu", "", ADMIN_ALL, mcbSelectionMenu)
	/* Menu End */
	register_menucmd(register_menuid("BuyMenu"), AllKeys, "PressedBuyMenu")
	
	gIsEnabled = gm_IsEnabled()
}

public plugin_precache() {
	gExpSprite = engfunc(EngFunc_PrecacheModel, "sprites/zerogxplode.spr")
	gShockwave = engfunc(EngFunc_PrecacheModel, "sprites/shockwave.spr")
	
	engfunc(EngFunc_PrecacheSound, "zombie/claw_strike1.wav")
}

public cmd_init(id, hasclass) {
	gHasSniper[id] = hasclass
	if (gm_IsValidPlayer(id) && gIsEnabled) {
		if (hasclass) {
			gm_Respawn(id)
			menu_display(id, mSelectionMenu, 0)
		}
		else
			gm_SetRendering(id)
	}
	
	gRifle[id] = 0
	gNewSelectForbidden[id] = 0
	gHasExp[id] = 0
	gHasBullets[id] = 0
	gHasReload[id] = 0
	gHasShword[id] = 0
}

public cmd_menu(id) {
	if (gIsEnabled)
		menu_display(id, mSelectionMenu, 0)
}

public cmd_buy(id) {
	if (gIsEnabled)
		show_buymenu(id)
}

public gm_Respawn(id) {
	if (!gIsEnabled || !gm_IsValidPlayer(id))
		return
	
	if (gHasSniper[id]) {
		// Allow the user to select a new weapon.
		gNewSelectForbidden[id] = 0
		give_speed(id)
		// ... and finally some armor, health, invisibility and maxspeed
		gm_SetRendering(id, kRenderFxGlowShell, 0, 0, 0, kRenderTransAlpha, 150)
		engfunc(EngFunc_SetClientMaxspeed, id, 350.0)
		set_pev(id, pev_maxspeed, 350.0)
		set_pev(id, pev_health, 95.0)
		cs_set_user_armor(id, 100, CS_ARMOR_KEVLAR)
		// ... and give weapons to the user...
		set_task(0.1, "give_weapon", id)
		// reset some stuff
		gInJump[id] = 0
		gJumpBlocked[id] = 0
		if (gInCooldown[id])
			remove_task(id+200)
		gInCooldown[id] = 0
	}
}

public hook_prethink(id) {
	if (gIsEnabled && gHasSniper[id] && gm_IsValidPlayer(id)) {
		pt_btn = pev(id, pev_button)
		pt_oldbtn = pev(id, pev_oldbuttons)
		
		if (gJumpBlocked[id]) {
			// Knife only
			if (gCurWeapon[id][0] != CSW_KNIFE)
				client_cmd(id, "weapon_knife")
			// Check this
			if (pev(id, pev_flags)&FL_ONGROUND) {
				// Kill the beam
				message_begin(MSG_BROADCAST, SVC_TEMPENTITY, { 0, 0, 0 }, id)
				write_byte(99)
				write_short(id)
				message_end()
				// damage
				gm_ExtraDamage(id, id, SHWORD_SELFDMG, "knife", 0, DMG_PARALYZE)
				// oh, and set and eat some values
				set_pev(id, pev_takedamage, 2.0)
				gJumpBlocked[id] = 0
				gInJump[id] = 0
				gInCooldown[id] = 1
				for(pt_tmp1=0;pt_tmp1<33;pt_tmp1++)
					gAlreadyHurt[pt_tmp1] = 0
				set_task(SHWORD_COOLDOWN, "task_cooldown_end", id+200)
			}
			else if (pt_btn&IN_ATTACK || pt_btn&IN_ATTACK2) {
				pt_tmp1 = 0
				pev(id, pev_origin, pt_fVec)
				
				while ((pt_tmp1 = engfunc(EngFunc_FindEntityInSphere, pt_tmp1, pt_fVec, SHWORD_RADIUS)) > 0) {
					if (pt_tmp1 != id && is_user_connected(pt_tmp1) && !gAlreadyHurt[pt_tmp1]) {
						// damage and stuff
						gm_ExtraDamage(id, pt_tmp1, SHWORD_DMG, "knife", 0)
						engfunc(EngFunc_EmitSound, pt_tmp1, CHAN_AUTO, "zombie/claw_strike1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
						gAlreadyHurt[pt_tmp1] = 1
						// lolz
						pt_fVec[0] = random_float(-15.0, 15.0)
						pt_fVec[1] = random_float(-15.0, 15.0)
						pt_fVec[2] = random_float(-45.0, 45.0)
						set_pev(pt_tmp1, pev_punchangle, pt_fVec)
					}
				}
			}
		}
		else if (gHasShword[id] && !gInCooldown[id]) {
			if (pt_btn&IN_JUMP && gCurWeapon[id][0] == CSW_KNIFE && !(pt_btn&IN_DUCK)) {
				if (!gInJump[id] && !(pev(id, pev_flags)&FL_ONGROUND)) {
					set_task(1.2, "task_movenow", id+100)
					gInJump[id] = 1
				}
				pev(id, pev_velocity, pt_fVec)
				pt_fVec[2] += 25.0
				set_pev(id, pev_velocity, pt_fVec)
			}
			else if (pt_oldbtn&IN_JUMP && !(pt_btn&IN_JUMP) && gCurWeapon[id][0] == CSW_KNIFE && gInJump[id]) {
				/* Follow Beam */
				message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
				write_byte(22)
				write_short(id)
				write_short(gShockwave)
				write_byte(10)
				write_byte(4)
				write_byte(255)
				write_byte(255)
				write_byte(128)
				write_byte(255)
				message_end()
				/* Set velocity+godmode */
				gm_VelocityByAim(id, 1500, pt_fVec)
				set_pev(id, pev_velocity, pt_fVec)
				set_pev(id, pev_takedamage, 0.0)
				gJumpBlocked[id] = 1
				gInJump[id] = 0
				/* Remove task */
				remove_task(id+100)
			}
		}
	}
}

public task_cooldown_end(id) {
	id -= 200
	gInCooldown[id] = 0
}

public task_movenow(id) {
	// Init stuff
	id -= 100
	new Float:fVec[3]
	/* Follow Beam */
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(22)
	write_short(id)
	write_short(gShockwave)
	write_byte(10)
	write_byte(4)
	write_byte(255)
	write_byte(255)
	write_byte(128)
	write_byte(255)
	message_end()
	/* Set velocity+godmode */
	gm_VelocityByAim(id, 1500, fVec)
	set_pev(id, pev_velocity, fVec)
	set_pev(id, pev_takedamage, 0.0)
	/* Time is over, ste this to 1 */
	gJumpBlocked[id] = 1
	gInJump[id] = 0
}

public give_weapon(id) {
	if (!gIsEnabled || !gm_IsValidPlayer(id))
		return
	
	gm_StripWeapons(id)
	// Knife
	gm_CreateOwnedItem(id, "weapon_knife")
	// Deagle+Ammo
	gm_CreateOwnedItem(id, "weapon_deagle")
	gm_CreateOwnedItem(id, "ammo_50ae")
	gm_CreateOwnedItem(id, "ammo_50ae")
	gm_CreateOwnedItem(id, "ammo_50ae")
	
	switch (gRifle[id]) {
		case 1: { // Scout+ammo
			gm_CreateOwnedItem(id, "weapon_scout")
			gm_CreateOwnedItem(id, "ammo_762nato")
			gm_CreateOwnedItem(id, "ammo_762nato")
		}
		case 2: { // AWP+ammo
			gm_CreateOwnedItem(id, "weapon_awp")
			gm_CreateOwnedItem(id, "ammo_338magnum")
			gm_CreateOwnedItem(id, "ammo_338magnum")
		}
		case 3: { // G3/SG-1+ammo
			gm_CreateOwnedItem(id, "weapon_g3sg1")
			gm_CreateOwnedItem(id, "ammo_762nato")
			gm_CreateOwnedItem(id, "ammo_762nato")
		}
		case 4: { // SG-550+ammo
			gm_CreateOwnedItem(id, "weapon_sg550")
			gm_CreateOwnedItem(id, "ammo_357sig")
			gm_CreateOwnedItem(id, "ammo_357sig")
		}
	}
	/* Speed */
	give_speed(id)
}

public hook_wpn(id) {
	// Check user's weapon and if he's valid
	if (!gIsEnabled || !gHasSniper[id] || !gm_IsValidPlayer(id))
		return PLUGIN_CONTINUE
	
	give_speed(id)
	wpn_wpn = get_user_weapon(id, wpn_ammo, wpn_bpack)
	if (wpn_wpn != CSW_DEAGLE) {
		if (gRifle[id] == 1 && wpn_wpn != CSW_SCOUT) {
			gCurWeapon[id][0] = wpn_wpn
			gCurWeapon[id][1] = wpn_ammo
			return PLUGIN_CONTINUE
		}
		if (gRifle[id] == 2 && wpn_wpn != CSW_AWP) {
			gCurWeapon[id][0] = wpn_wpn
			gCurWeapon[id][1] = wpn_ammo
			return PLUGIN_CONTINUE
		}
		if (gRifle[id] == 3 && wpn_wpn != CSW_G3SG1) {
			gCurWeapon[id][0] = wpn_wpn
			gCurWeapon[id][1] = wpn_ammo
			return PLUGIN_CONTINUE
		}
		if (gRifle[id] == 4 && wpn_wpn != CSW_SG550) {
			gCurWeapon[id][0] = wpn_wpn
			gCurWeapon[id][1] = wpn_ammo
			return PLUGIN_CONTINUE
		}
	}
	if(gCurWeapon[id][0] != wpn_wpn) { // User changed weapon
		gCurWeapon[id][0] = wpn_wpn
		gCurWeapon[id][1] = wpn_ammo
		return PLUGIN_CONTINUE
	}
	if(gCurWeapon[id][1] < wpn_ammo && !gHasReload[id]) { // User reloaded
		gCurWeapon[id][1] = wpn_ammo
		return PLUGIN_CONTINUE
	}
	if(gCurWeapon[id][1] == wpn_ammo) // User did something else, but didn't shoot
		return PLUGIN_CONTINUE
	if (gm_AimingAtWall(id)) // making walls gimplode with special effects isn't allowed, boy
		return PLUGIN_CONTINUE
	
	// This means user shot his/her gun
	// Save (new) weapon data
	gCurWeapon[id][1] = wpn_ammo
	gCurWeapon[id][0] = wpn_wpn
	get_user_origin(id, wpn_origin)
	get_user_origin(id, wpn_hitpos, 4)
	
	if (wpn_wpn != CSW_DEAGLE) {
		message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("ScreenFade"), {0, 0, 0}, id)
		write_short(60) // duration in 0.01s
		write_short(20) // holdtime in 0.01s
		write_short(40) // fadetime in 0.01s
		write_byte(0) // r
		write_byte(0) // g
		write_byte(0) // b
		write_byte(40)	// alpha
		message_end()
	}
	
	/* Tracer effect */
	if (gHasBullets[id] && wpn_wpn != CSW_DEAGLE) {
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
		write_byte(6) // TE_TRACER
		write_coord(wpn_origin[0])
		write_coord(wpn_origin[1])
		write_coord(wpn_origin[2])
		write_coord(wpn_hitpos[0])
		write_coord(wpn_hitpos[1])
		write_coord(wpn_hitpos[2])
		message_end()
		
		pev(id, pev_velocity, wpn_fvec1)
		gm_VelocityByAim(id, 80, wpn_fvec2)
		wpn_fvec1[0] -= wpn_fvec2[0]
		wpn_fvec1[1] -= wpn_fvec2[1]
		wpn_fvec1[2] -= wpn_fvec2[2]
		set_pev(id, pev_velocity, wpn_fvec1)
	}
	/* Explosion effect + damage */
	if (gHasExp[id] && wpn_wpn != CSW_DEAGLE) {
		get_weaponname(wpn_wpn, wpn_weapon, 31)
		
		// make an explosion
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
		write_byte(3)
		write_coord(wpn_hitpos[0])
		write_coord(wpn_hitpos[1])
		write_coord(wpn_hitpos[2])
		write_short(gExpSprite)
		write_byte(12)
		write_byte(25)
		write_byte(0)
		message_end()
		// and do damage
		wpn_fvec3[0] = float(wpn_hitpos[0])
		wpn_fvec3[1] = float(wpn_hitpos[1])
		wpn_fvec3[2] = float(wpn_hitpos[2])
		
		wpn_target = 0
		while ((wpn_target = engfunc(EngFunc_FindEntityInSphere, wpn_target, wpn_fvec3, 37.5)) > 0) {
			if (wpn_target != id) {
				if (is_user_connected(wpn_target))
					gm_ExtraDamage(id, wpn_target, (wpn_wpn == CSW_AWP || wpn_wpn == CSW_SCOUT) ? EXPLOSION_DMG : EXPLOSION_DMG_AUTO, wpn_weapon[7], 0)
				else
					gm_FakeDamage(wpn_target, wpn_weapon[7], (wpn_wpn == CSW_AWP || wpn_wpn == CSW_SCOUT) ? float(EXPLOSION_DMG) : float(EXPLOSION_DMG_AUTO), DMG_BULLET)
			}
		}
	}
	/* Auto-Reload */
	if (wpn_ammo == 0 && wpn_bpack != 0 && gHasReload[id]) {
		new weapon[32] = ""
		switch (wpn_wpn) {
			case CSW_DEAGLE: {
				if (wpn_bpack < 7) {
					wpn_ammo = wpn_bpack
					wpn_bpack = 0
				}
				else {
					wpn_ammo = 7
					wpn_bpack -= 7
				}
				weapon = "weapon_deagle"
			}
			case CSW_SCOUT: {
				if (wpn_bpack < 10) {
					wpn_ammo = wpn_bpack
					wpn_bpack = 0
				}
				else {
					wpn_ammo = 10
					wpn_bpack -= 10
				}
				weapon = "weapon_scout"
			}
			case CSW_AWP: {
				if (wpn_bpack < 10) {
					wpn_ammo = wpn_bpack
					wpn_bpack = 0
				}
				else {
					wpn_ammo = 10
					wpn_bpack -= 10
				}
				weapon = "weapon_awp"
			}
			case CSW_G3SG1: {
				if (wpn_bpack < 30) {
					wpn_ammo = wpn_bpack
					wpn_bpack = 0
				}
				else {
					wpn_ammo = 30
					wpn_bpack -= 30
				}
				weapon = "weapon_g3sg1"
			}
			case CSW_SG550: {
				if (wpn_bpack < 30) {
					wpn_ammo = wpn_bpack
					wpn_bpack = 0
				}
				else {
					wpn_ammo = 30
					wpn_bpack -= 30
				}
				weapon = "weapon_sg550"
			}
			default: {
				return PLUGIN_CONTINUE
			}
		}
		
		new index = gm_FindEntByOwner(weapon, id)
		if (pev_valid(index)) {
			// set clip ammo
			cs_set_weapon_ammo(index, wpn_ammo)
			// and bpack
			cs_set_user_bpammo(id, wpn_wpn, wpn_bpack)
		}
	}
	
	return PLUGIN_CONTINUE
}

public gm_DamageEvent(victim, attacker, weapon[], damage, extradamage) {
	if (gIsEnabled && attacker && is_user_connected(attacker) && gHasSniper[attacker] && containi(weapon, "weapon_") == 0 && get_user_health(victim) - damage > 0 && !extradamage) {
		if ((equali(weapon, "weapon_scout") || equali(weapon, "weapon_awp")) && gHasBullets[attacker])
			gm_ExtraDamage(attacker, victim, BULLETS_EXTRADMG, weapon[7], 0)
		else if ((equali(weapon, "weapon_g3sg1") || equali(weapon, "weapn_sg550")) && gHasBullets[attacker])
			gm_ExtraDamage(attacker, victim, BULLETS_EXTRADMG_AUTO, weapon[7], 0)
	}
}

give_speed(id) {
	engfunc(EngFunc_SetClientMaxspeed, id, 350.0)
	set_pev(id, pev_maxspeed, 350.0)
}

show_buymenu(id) {
	new keys = (1<<9)
	temp = "\yBuy menu^n^n"
	/* Explosive bullets */
	if (gHasExp[id]) {
		add(temp, 255, "\w1. Drop Explosive Bullets^n")
		keys |= (1<<0)
	}
	else if (gm_GetPoints(id) >= EXPLOSION_REQP) {
		addpointitem("\w1. Buy Explosive Bullets", EXPLOSION_REQP)
		keys |= (1<<0)
	}
	else
		addpointitem("\d1. Buy Explosive Bullets", EXPLOSION_REQP)
	/* Upgraded Bullets */
	if (gHasBullets[id]) {
		add(temp, 255, "\w2. Drop Upgraded Bullets^n")
		keys |= (1<<1)
	}
	else if (gm_GetPoints(id) >= BULLETS_REQP) {
		addpointitem("\w2. Buy Upgraded Bullets", BULLETS_REQP)
		keys |= (1<<1)
	}
	else
		addpointitem("\d2. Buy Upgraded Bullets", BULLETS_REQP)
	/* Auto-Reload */
	if (gHasReload[id]) {
		add(temp, 255, "\w3. Drop Auto-Reload^n")
		keys |= (1<<2)
	}
	else if (gm_GetPoints(id) >= RELOAD_REQP) {
		addpointitem("\w3. Buy Auto-Reload", RELOAD_REQP)
		keys |= (1<<2)
	}
	else
		addpointitem("\d3. Buy Auto-Reload", RELOAD_REQP)
	/* Shword Action */
	if (gHasShword[id]) {
		add(temp, 255, "\w4. Drop Shword Action^n")
		keys |= (1<<3)
	}
	else if (gm_GetPoints(id) >= SHWORD_REQP) {
		addpointitem("\w4. Buy Shword Action", SHWORD_REQP)
		keys |= (1<<3)
	}
	else
		addpointitem("\d4. Buy Shword Action", SHWORD_REQP)
	
	add(temp, 255, "^n\w0. Exit")
	
	show_menu(id, keys, temp, -1, "BuyMenu") // Display menu
}

addpointitem(title[], points) {
	new tmp[64]
	format(tmp, 63, "%s (%d points)^n", title, points)
	add(temp, 255, tmp)
}

public PressedBuyMenu(id, key) {
	if (!gIsEnabled) return
	
	switch (key) {
		case 0: { /* Explosive bullets */
			if (gHasExp[id]) {
				gm_AddPoints(id, EXPLOSION_REQP)
				gHasExp[id] = 0
				client_print(id, print_chat, "[GM] You've dropped Explosive Bullets and got %d points back.", EXPLOSION_REQP)
			}
			else if (gm_GetPoints(id) >= EXPLOSION_REQP) {
				gm_RemPoints(id, EXPLOSION_REQP)
				gHasExp[id] = 1
				client_print(id, print_chat, "[GM] You've just bought Explosive Bullets for %d points.", EXPLOSION_REQP)
			}
		}
		case 1: { /* Upgraded Bullets */
			if (gHasBullets[id]) {
				gm_AddPoints(id, BULLETS_REQP)
				gHasBullets[id] = 0
				client_print(id, print_chat, "[GM] You've dropped Upgraded Bullets and got %d points back.", BULLETS_REQP)
			}
			else if (gm_GetPoints(id) >= BULLETS_REQP) {
				gm_RemPoints(id, BULLETS_REQP)
				gHasBullets[id] = 1
				client_print(id, print_chat, "[GM] You've just bought Upgraded Bullets for %d points.", BULLETS_REQP)
			}
		}
		case 2: { /* Auto-Reload */
			if (gHasReload[id]) {
				gm_AddPoints(id, RELOAD_REQP)
				gHasReload[id] = 0
				client_print(id, print_chat, "[GM] You've dropped Auto-Reload and got %d points back.", RELOAD_REQP)
			}
			else if (gm_GetPoints(id) >= RELOAD_REQP) {
				gm_RemPoints(id, RELOAD_REQP)
				gHasReload[id] = 1
				client_print(id, print_chat, "[GM] You've just bought Auto-Reload for %d points.", RELOAD_REQP)
			}
		}
		case 3: { // Shword Action
			if (gHasShword[id]) {
				gm_AddPoints(id, SHWORD_REQP)
				gHasShword[id] = 0
				client_print(id, print_chat, "[GM] You've dropped Shword Action and got %d points back.", SHWORD_REQP)
			}
			else if (gm_GetPoints(id) >= SHWORD_REQP) {
				gm_RemPoints(id, SHWORD_REQP)
				gHasShword[id] = 1
				client_print(id, print_chat, "[GM] You've just bought the Shword Action for %d points. Switch to knife and press jump+attack to use it.", SHWORD_REQP)
			}
		}
		case 9: { /* Exit */
			return
		}
	}
	show_buymenu(id)
}

/* Menu Selection menu */

public mh_SelectionMenu(id, menu, item) {
	if (!gIsEnabled) return
	
	switch (item) {
		case 0: { /* Scout */
			if (gNewSelectForbidden[id])
				client_print(id, print_chat, "[GM] You can only select a start weapon once per life.")
			else if (gm_GetPoints(id, 0) >= SCOUT_REQP && gRifle[id] != 1) {
				client_print(id, print_chat, "[GM] You've selected Scout as start weapon.")
				gRifle[id] = 1
				gm_Respawn(id)
				gNewSelectForbidden[id] = 1
			}
		}
		case 1: { /* AWP */
			if (gNewSelectForbidden[id])
				client_print(id, print_chat, "[GM] You can only select a start weapon once per life.")
			else if (gm_GetPoints(id, 0) >= AWP_REQP && gRifle[id] != 2) {
				client_print(id, print_chat, "[GM] You've selected AWP as start weapon.")
				gRifle[id] = 2
				gm_Respawn(id)
				gNewSelectForbidden[id] = 1
			}
		}
		case 2: { /* G3/SG-1 */
			if (gNewSelectForbidden[id])
				client_print(id, print_chat, "[GM] You can only select a start weapon once per life.")
			else if (gm_GetPoints(id, 0) >= G3_REQP && gRifle[id] != 3) {
				client_print(id, print_chat, "[GM] You've selected G3/SG-1 as start weapon.")
				gRifle[id] = 3
				gm_Respawn(id)
				gNewSelectForbidden[id] = 1
			}
		}
		case 3: { /* SG-550 */
			if (gNewSelectForbidden[id])
				client_print(id, print_chat, "[GM] You can only select a start weapon once per life.")
			else if (gm_GetPoints(id, 0) >= SG_REQP && gRifle[id] != 4) {
				client_print(id, print_chat, "[GM] You've selected SG-550 as start weapon.")
				gRifle[id] = 4
				gm_Respawn(id)
				gNewSelectForbidden[id] = 1
			}
		}
		case 4: { /* Buy menu */
			show_buymenu(id)
		}
	}
}

public mcb_SelectionMenu(id, menu, item) {
	if (SCOUT_REQP > gm_GetPoints(id, 0) && item == 0) // Scout
		return ITEM_DISABLED
	if (AWP_REQP > gm_GetPoints(id, 0) && item == 1) // AWP
		return ITEM_DISABLED
	if (G3_REQP > gm_GetPoints(id, 0) && item == 2) // G3/SG-1
		return ITEM_DISABLED
	if (SG_REQP > gm_GetPoints(id, 0) && item == 3) // SG-550
		return ITEM_DISABLED
	if (item+1 == gRifle[id])
		return ITEM_DISABLED
	return ITEM_ENABLED
	
}

public gm_EnablingMod() {
	gIsEnabled = 1
}

public gm_DisablingMod() {
	gIsEnabled  = 0
	
	arrayset(gInJump, 0, 32)
	arrayset(gJumpBlocked, 0, 32)
	arrayset(gInCooldown, 0, 32)
	arrayset(gAlreadyHurt, 0, 32)
}