/**
 * SHARKMOD
 * Version 0.3
 * By: Edgar De Loa
 * 
 * DESCRIPTION:
 * After enabling this plugin, all but one randomely chosen player will be moved to
 * the CT team. All players are locked to their team. The lone terrorist(the "shark")
 * will have increased speed, noclip, increased HP, but not be able to use anything
 * other than a knife.
 * 
 * The shark's objective is to kill the CTs.  If a CT manages to kill the shark,
 * that player will become the new shark next round.  If the shark manages to stay
 * alive for several consequtive rounds (admin-configurable), a new shark will be
 * randomely chosen.
 * 
 * An admin may also manually select the next shark through a menu.
 * 
 * 
 * REQUIREMENTS:
 * AMXX 1.70+
 * Fun module
 * Fakemeta module
 * 
 * CVARS:
 * sharkmod_maxhealth <#>
 *      The shark's initial health. (default: 255)
 * sharkmod_speed <#>
 *      Speed at which the shark travels (default: 640)
 *      Note: normal knife speed is 320, and is capped at 1000
 * sharkmod_maxrounds <#>
 *      Max number of consecutive rounds a player can be the shark (default: 3)
 * sharkmod_timer <#>
 *      Time after enabling that sharkmod begins (default: 10)
 * sharkmod_custommodel <0/1>
 *      1 to use your custom model, 0 otherwise (default: 0)
 * 
 * COMMANDS:
 * amx_shark <0/1>
 *      1 to enable sharkmod, 0 to disable
 * amx_sharkmenu
 *      Manually select the shark for the next round
 * 
 * CUSTOM MODELS:
 * The shark model should be: "models/player/shark/shark.mdl"
 * 
 * TO DO / IDEAS:
 * Make it work with other games
 * Emit shark sounds from shark when +use button is pressed.
 * Add more options to menu.
 * Allow multiple sharks.
 * Leave spectators out of the game.
 * Health changes according to number of opponents
 * Make shark's attacks stronger
 * 
 * NOTES:
 * Many of the things on the TO DO list are already in the works.
 * I figured I'd release what I have now so those that requested this mod
 * could have a working plugin immediately.
 */

#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <fun>
#include <fakemeta>

#define PLUGIN	"SharkMod"
#define VERSION	"0.3"
#define AUTHOR	"Edgar De Loa"

#define MENU_SIZE    256
#define MENU_PLAYERS 8

#define SHARK_MODEL "shark"
#define SHARK_MODEL_DIR "models/player/shark/shark.mdl"
#define SHARK_SOUND "misc/shark.wav"

#define ADMIN_REQ ADMIN_RCON

new g_iMenuPosition
new g_iMenuPlayers[32]

new g_maxRounds
new g_timer
new g_speed
new g_maxhealth
new g_custommodel

new g_enabled = 0
new g_roundsPlayed = 0
new g_currentShark = 0
new g_nextShark = 0
new blockteams

public plugin_init()
{
  register_plugin(PLUGIN, VERSION, AUTHOR)  
  
  register_clcmd("amx_shark", "setEnabled", ADMIN_REQ, "- <0/1> Enable SharkMod")
  register_clcmd("amx_sharkmenu", "ShowMenu", ADMIN_REQ, "- Select next shark")
  register_menucmd( register_menuid("\rPlayer Menu:"), 1023, "MenuAction" )
  
  register_clcmd("jointeam", "join_team")
  register_menucmd(register_menuid("Team_Select",1), (1<<0)|(1<<1)|(1<<4)|(1<<5), "team_select")
  
  register_logevent("event_roundStart", 2, "1=Round_Start")
  register_event("HLTV", "event_newRound", "a", "1=0", "2=0")
  register_event("DeathMsg", "event_deathMsg", "a", "1>0")
  register_event("CurWeapon","event_curWeapon", "be", "1=1")
  register_forward(FM_Touch,"on_touch")
  //register_forward(FM_CmdStart, "event_cmdStart")
  
  g_maxRounds = register_cvar("sharkmod_maxrounds", "3")
  g_speed = register_cvar("sharkmod_speed", "640")
  g_timer = register_cvar("sharkmod_timer", "10")
  g_maxhealth = register_cvar("sharkmod_maxhealth", "255")
  
  blockteams = g_enabled ? PLUGIN_HANDLED : PLUGIN_CONTINUE
}

public plugin_precache()
{
  g_custommodel = register_cvar("sharkmod_custommodel", "0")
  
  if (get_pcvar_num(g_custommodel)) {
    precache_model(SHARK_MODEL_DIR)
  }
  
  //precache_sound(SHARK_SOUND)
  return PLUGIN_CONTINUE
}





public setEnabled(id, lvl, cid)
{
  if(cmd_access(id, lvl, cid, 2)) {
    new str[2]
    read_argv(1, str, 1)
    str_to_num(str) ? startSharkMod() : stopSharkMod()
  }
}

public startSharkMod()
{
  g_enabled = 1
  setServerSettings()
  lockTeams()
  
  new command[64]
  format(command, 63, "sv_restartround %f", get_pcvar_float(g_timer))
  server_cmd(command)
  client_print(0, print_chat, "[SharkMod] SharkMod will start in %f seconds.", get_pcvar_float(g_timer))
}

public stopSharkMod()
{  
  if (g_currentShark) {
    cs_reset_user_model(g_currentShark)
    set_user_noclip(g_currentShark)
    set_user_maxspeed(g_currentShark, 0.0)
  }

  g_enabled = 0
  g_currentShark = 0
  g_nextShark = 0
  g_roundsPlayed = 0
  unlockTeams()
  
  client_print(0, print_chat, "[SharkMod] SharkMod is now off.")
}

/*
public checkForValidPlayers(id)
{
  
  new players[32], num
  get_players(players, num)
  
  for(new i = 0; i < num; i++) {
    new csTeams:szTeam = cs_get_user_team(players[i])
    
    if (szTeam == CS_TEAM_CT || sz == CS_TEAM_T) {
      g_players++;
    }
  }
  
  
  if (get_playersnum() > 1) {
    client_print(id, print_chat, "[SharkMod] %i seconds until SharkMod begins!", g_timer)
    setServerSettings()
    return 1;
  }
  else {
    client_print(id, print_chat, "[SharkMod] Not enough players to start SharkMod.")
    return 0;
  }
}
*/

public ShowMenu(id, lvl, cid)
{
  if(cmd_access(id, lvl, cid, 0))
    ShowPlayerMenu(id, g_iMenuPosition = 0)
  return PLUGIN_HANDLED
}

public ShowPlayerMenu(id, pos)
{
  if(pos < 0) return

  new i, j
  new szMenuBody[MENU_SIZE]
  new iCurrKey = 0
  new szUserName[32]
  new iStart = pos * MENU_PLAYERS
  new iNum

  get_players( g_iMenuPlayers, iNum )

  if( iStart >= iNum )
    iStart = pos = g_iMenuPosition = 0

  new iLen = format( szMenuBody, MENU_SIZE-1, "\rPlayer Menu:\R%d/%d^n\w^n", pos+1, (iNum / MENU_PLAYERS + ((iNum % MENU_PLAYERS) ? 1 : 0 )) )
  new iEnd = iStart + MENU_PLAYERS
  new iKeys = (1<<9|1<<7)

  if( iEnd > iNum )
    iEnd = iNum

  for( i = iStart; i < iEnd; i++)
  {
    j = g_iMenuPlayers[i]
    get_user_name( j, szUserName, 31 )
    if( (get_user_flags(j) & ADMIN_IMMUNITY) || !is_user_alive(j) )
    {
      iCurrKey++
      iLen += format( szMenuBody[iLen], (MENU_SIZE-1-iLen), "\d%d. %s^n\w", iCurrKey, szUserName )
    }else
    {
      iKeys |= (1<<iCurrKey++)
      iLen += format( szMenuBody[iLen], (MENU_SIZE-1-iLen), "%d. %s^n", iCurrKey, szUserName )
    }
  }

  if( iEnd != iNum ) {
    format( szMenuBody[iLen], (MENU_SIZE-1-iLen), "^n9. More...^n0. %s", pos ? "Back" : "Exit" )
    iKeys |= (1<<8)
  }
  else {
    format( szMenuBody[iLen], (MENU_SIZE-1-iLen), "^n0. %s", pos ? "Back" : "Exit" )
  }

  show_menu( id, iKeys, szMenuBody, -1 )
  return
}

public MenuAction(id, key)
{
  switch(key)
  {
    case 8: ShowPlayerMenu( id, ++g_iMenuPosition )
    case 9: ShowPlayerMenu( id, --g_iMenuPosition )

    default:
    {
      new iPlayerID = g_iMenuPlayers[g_iMenuPosition * MENU_PLAYERS + key]

      new szUsername[32]
      get_user_name( iPlayerID, szUsername, 31 )
      client_print(0, print_chat, "[SharkMod] %s has been chosen to become the next Shark!", szUsername)
      g_nextShark = iPlayerID;
    }
  }
  return PLUGIN_HANDLED
}





public createNewShark()
{
  if (g_currentShark) {
    cs_reset_user_model(g_currentShark)
  }
  
  new players[32], num
  get_players(players, num)
  for (new i = 0; i < num; i++) {
    cs_set_user_team(players[i], CS_TEAM_CT)
  }
    
  if (g_nextShark == 0 || !is_user_connected(g_nextShark) || get_user_team(g_nextShark) == 3) {
    g_nextShark = players[random(num)]
  }

  g_currentShark = g_nextShark;
  g_nextShark = 0;
  g_roundsPlayed = 0
  
  cs_set_user_team(g_currentShark, CS_TEAM_T)
  
  if (g_custommodel) {
    cs_set_user_model(g_currentShark, SHARK_MODEL)
  }
  
  new name[33]
  get_user_name(g_currentShark, name, 32)
  client_print(0, print_chat, "[SharkMod] The new Shark is: %s!", name)
}

public updateShark()
{
  set_user_health(g_currentShark, get_pcvar_num(g_maxhealth))
  set_user_noclip(g_currentShark, 1)
  //set_user_maxspeed(g_currentShark, get_pcvar_float(g_speed))
  set_task(0.5, "event_curWeapon", g_currentShark)
  
  g_roundsPlayed++
  client_print(0, print_chat, "[SharkMod] Starting round %i/%i!", g_roundsPlayed, get_pcvar_num(g_maxRounds))
}




public event_newRound()
{
  if (g_enabled && (g_roundsPlayed == get_pcvar_num(g_maxRounds) || g_nextShark != 0
  || !is_user_connected(g_currentShark) || get_user_team(g_currentShark) != 1 || g_currentShark == 0)) {
    createNewShark()
  }
}

public event_roundStart()
{
  if (g_enabled) {
    updateShark()
  }
}

public event_deathMsg()
{
  if (g_enabled) {
    new killer = read_data(1)
    new victim = read_data(2)
    
    if (victim == g_currentShark && killer != victim && killer <= 32) {
      g_nextShark = killer;
      new name[33]
      get_user_name(g_nextShark, name, 32)
      client_print(0, print_chat, "[SharkMod] %s got the killing blow! The next Shark will be: %s!", name, name)
    }
  }
  
  return PLUGIN_CONTINUE
}

public setServerSettings()
{
  server_cmd("mp_limitteams 0")
  server_cmd("mp_autoteambalance 0")
  server_cmd("sv_maxspeed 1000")
}





public event_curWeapon(id)
{
  if (g_enabled && id == g_currentShark) {
    new weapons[32], num
    get_user_weapons(g_currentShark, weapons, num)
    if (num > 1) {
      strip_user_weapons(g_currentShark)
      give_item(g_currentShark, "weapon_knife")
    }
    set_user_maxspeed(g_currentShark, get_pcvar_float(g_speed))
  }
}

public on_touch(ent, id)
{
  if (id == g_currentShark) {
    if (!pev_valid(ent))
      return FMRES_IGNORED

    static classname[32]
    pev(ent,pev_classname,classname,sizeof classname-1)

    if ( (!equal(classname,"weapon",6)) && (!equal(classname,"armoury",7)) )
        return FMRES_IGNORED
    
    return FMRES_SUPERCEDE
  }
  return FMRES_IGNORED
}

/*
public event_cmdStart(const id, const uc_handle, random_seed)
{
  if (id == g_currentShark) {
    new button = pev(id, pev_button)
  
    if ((button & IN_JUMP) && !(pev(id, pev_oldbuttons) & IN_JUMP)) {
      emit_sound(g_currentShark, CHAN_AUTO, SHARK_SOUND, VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
    }
  }

  return FMRES_IGNORED
}
*/





public lockTeams()
{
  blockteams = PLUGIN_HANDLED
  return PLUGIN_HANDLED
}

public unlockTeams()
{
  blockteams = PLUGIN_CONTINUE
  return PLUGIN_HANDLED
}

public team_select(id, key){
  if ( (key == 0 || key == 4) && blockteams == PLUGIN_HANDLED ) {
    engclient_cmd(id,"chooseteam")
    return PLUGIN_HANDLED
  }
  return PLUGIN_CONTINUE
}

public join_team(id)
{
  new arg[2]
  read_argv(1, arg, 1)
  new key = str_to_num(arg)-1
  if ( (key == 0 || key == 4) && blockteams == PLUGIN_HANDLED ) {
    engclient_cmd(id,"chooseteam")
    return PLUGIN_HANDLED
  }
  return PLUGIN_CONTINUE
}