#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <fakemeta>
#include <engine>
#include <fun>

#define PLUGIN "American Football Mod"
#define VERSION "1.0"
#define AUTHOR "WhooKid"

new CTtd_loc[3],Ttd_loc[3],Scrimage_loc,FirstD_loc,T_QB,CT_QB,QB_lock[3],Burst[33],BrsCnt[33],s2smoke,s2white;
new FootballMap,GameActive,StatSnap,TeamWithBall,CurDown,Float:votetime,choice[2];
new beamspr,fdtime,tscore,ctscore,dwnum,dwnum2,g_msgsync,g_msghelp,g_msgsboard,NoRushing;
	
public plugin_init()
{
	register_plugin(PLUGIN,VERSION,AUTHOR);
	register_cvar("fm_version",VERSION,FCVAR_SERVER|FCVAR_UNLOGGED|FCVAR_SPONLY);

	new MapName[64];
	get_mapname(MapName, 63);

	if (equali(MapName,"rf_football"))
	{
		Ttd_loc = {1309, -128, -1179 };
		CTtd_loc = { -1373, -128, -1179 };
		FootballMap = true;
	}
	else if (equali(MapName,"sm_footballv2"))
	{
		Ttd_loc = { 2073, -4, 1604 };
		CTtd_loc = { -2521, -4, 1604 };
		FootballMap = true;
	}

	if (FootballMap)
	{
		register_event("Damage", "on_damage", "b", "2!0", "3=0", "4!0");
		register_event("AmmoPickup","event_henade","b","1=12");
		register_event("CurWeapon","event_domodels","b");
		register_event("ResetHUD","event_resethud","b");
		
		register_message(get_user_msgid("SendAudio"),"msg_sendaudio");
		register_message(get_user_msgid("TextMsg"),"msg_textmsg");
		
		register_touch("grenade","player","player_interact");
		register_touch("grenade","*","ball_interact");
		register_touch("player","player","act_push");

		register_clcmd("say /qb","act_qb",0,"<Make you the QB>");
		register_clcmd("say /help","display_info",0,"<Tells you how to play>");
		register_clcmd("say /start","start_game",0,"<Starts a new Football game>");
		register_clcmd("say /switch","act_switch",0,"<Switches a players team>");
		register_clcmd("say /voterush","vote_start",0,"<Starts a vote on rushing>");
		
		register_concmd("amx_setqb", "set_qb", ADMIN_KICK, "<name or #userid>");
		register_concmd("amx_setdown", "set_down", ADMIN_KICK, "<new down #>");
		register_concmd("amx_setrush", "set_rush", ADMIN_KICK, "<allowing players to rush>");
		register_concmd("amx_setscore", "set_score", ADMIN_KICK, "<T|CT|1|2> <new score #>");
		register_concmd("amx_makeburst", "make_burst", ADMIN_KICK, "<make a player have a speed burst>");
		register_concmd("amx_end", "display_winner", ADMIN_KICK, "<Ends the current game>");
		
		register_cvar("fm_downs","3",FCVAR_SERVER|FCVAR_UNLOGGED|FCVAR_SPONLY);
		register_cvar("fm_helpmsg","1",FCVAR_SERVER|FCVAR_UNLOGGED|FCVAR_SPONLY);
		register_cvar("fm_maxscore","49",FCVAR_SERVER|FCVAR_UNLOGGED|FCVAR_SPONLY);
		register_cvar("fm_maxspeed","260",FCVAR_SERVER|FCVAR_UNLOGGED|FCVAR_SPONLY);
		register_cvar("fm_playclock","5",FCVAR_SERVER|FCVAR_UNLOGGED|FCVAR_SPONLY);
		register_cvar("fm_allowburst","1",FCVAR_SERVER|FCVAR_UNLOGGED|FCVAR_SPONLY);
		register_cvar("fm_burstspeed","370",FCVAR_SERVER|FCVAR_UNLOGGED|FCVAR_SPONLY);
		register_cvar("fm_allowpushoff","1",FCVAR_SERVER|FCVAR_UNLOGGED|FCVAR_SPONLY);
		register_cvar("fm_allowvoterush","1",FCVAR_SERVER|FCVAR_UNLOGGED|FCVAR_SPONLY);

		register_think("grenade","think_grenade");
		
		register_forward(FM_SetModel,"fw_setmodel",0);
		register_forward(FM_CmdStart,"fw_start",1);
		
		register_menucmd(register_menuid("\yRushing the Scrimmage Line should be?"), (1<<0)|(1<<1), "vote_count");
		
		set_msg_block(get_user_msgid("ClCorpse"), BLOCK_SET);
		
		server_print("*** Football Mod Enabled ***");

		set_task(4.0,"create_fldlines",20,"",0,"b");
		
		start_game();
	}
}

// precache files
public plugin_precache()
{
	precache_model("models/p_dodgeball.mdl");
	precache_model("models/v_dodgeball.mdl");
	precache_model("models/w_dodgeball.mdl");
	precache_model("models/p_hands.mdl");
	precache_model("models/v_hands.mdl");
	precache_sound("football/int.wav");
	precache_sound("football/hut.wav");
	precache_sound("football/crowd.wav");
	precache_sound("football/cheer1.wav");
	precache_sound("football/cheer2.wav");
	precache_sound("football/cheer3.wav");
	precache_sound("football/cheer4.wav");
	precache_sound("football/cheer5.wav");
	precache_sound("football/cheer6.wav");
	precache_sound("football/whistle.wav");
	beamspr = precache_model("sprites/laserbeam.spr");
	g_msgsync = CreateHudSyncObj();
	g_msghelp = CreateHudSyncObj();
	g_msgsboard = CreateHudSyncObj();
}

// grenade is thrown
public grenade_throw(index,greindex,wId) 
{
	// set some variables
	entity_set_edict(greindex,EV_ENT_euser1,index);
	entity_set_int(greindex,EV_INT_iuser1,0);
	entity_set_size(greindex,Float:{-6.0,-6.0,-6.0},Float:{6.0,6.0,6.0});
	entity_set_float(greindex,EV_FL_friction,0.6);
	
	// make a trail for the ball
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY);
	write_byte(22); 	// TE_BEAMFOLLOW
	write_short(greindex); 	// ball
	write_short(beamspr); 	// laserbeam
	write_byte(10); 	// life
	write_byte(10); 	// width
	write_byte(0); 		// red
	write_byte(255); 	// green
	write_byte(0); 		// blue
	write_byte(100); 	// brightness
	message_end();

	// make it glow (so we can tell if it is dead or not)
	set_rendering(greindex,kRenderFxGlowShell,0,255,0);

	// make player not glow
	set_rendering2(index,kRenderFxNone,0,0,0,kRenderTransAlpha,255);
	
	// stop the ball from rolling unlimitedly
	set_task(6.0,"stop_roll",greindex);
	
	// if no game is active then leave the nade alone.
	if (!GameActive)
		return PLUGIN_CONTINUE;
	
	// perform ingame checks
	switch (StatSnap)
	{
		case 0:{
			act_snap(index);
		}
		case 1:{
			new origin[3];
			get_user_origin(index,origin);
			new teamnum = get_user_team(index);
			if (((origin[0]<Scrimage_loc && teamnum==1) || (origin[0]>Scrimage_loc && teamnum==2)) || FirstD_loc==10000)//if FirstD_loc=10000 then the ball has been intercepted
			{
				entity_set_int(greindex,EV_INT_iuser1,1); // dead ball
				set_rendering(greindex); // get rid of glow
				play_over(1,index);
			}
			else
				display_comment(2,index);
			// display third white help message
			display_help(3);
		}
		case 2:{
			entity_set_int(greindex,EV_INT_iuser1,1); // dead ball
			set_rendering(greindex); // get rid of glow
		}
	}
	return PLUGIN_CONTINUE;
}

// player touches ball
public player_interact(ent,id) 
{
	new classname[32],origin[3];
	entity_get_string(ent,EV_SZ_classname,classname,31);
	get_user_origin(id,origin);

	// if no game is active then give them a new nade			
	if (!GameActive && equali(classname,"grenade"))
	{
		if (!user_has_ball(id))
		{
			give_item(id,"weapon_hegrenade");
			remove_entity(ent);
		}
		return PLUGIN_CONTINUE;
	}
	
	// catch a ball
	if (equali(classname,"grenade") && (entity_get_int(ent,EV_INT_iuser1) == 0) && StatSnap != 2)//if StatSnap=2 then play is dead
	{
		//check for interception
		if (get_user_team(id) != TeamWithBall) 
		{
			TeamWithBall = get_user_team(id);
			FirstD_loc = 10000;
			display_comment(6,id);
			client_cmd(0, "spk ^"football/int.wav^" ");
		}
		else if ((origin[0]<Scrimage_loc && get_user_team(id)==1) || (origin[0]>Scrimage_loc && get_user_team(id)==2))// if the pass isnt an interception display catch
			display_comment(10,id);
		if (user_has_ball(id) < 1) 
		{
			give_item(id,"weapon_hegrenade");
			remove_entity(ent);
			// give a frag for a catch
			set_user_frags(id,get_user_frags(id)+1);
			setup_tackle();
			set_rendering2(id,kRenderFxGlowShell,0,0,250,kRenderTransAlpha,255);
		}
	}
	return PLUGIN_CONTINUE;
 }
 
 // ball hits something
 public ball_interact(ball,ent)
 {
	// hit world
	if (ent == 0) 
	{
		if (entity_get_int(ball,EV_INT_iuser1) == 0)
		{
			entity_set_int(ball,EV_INT_iuser1,1); // dead ball
			entity_set_edict(ball,EV_ENT_owner,0); // clear owner
			set_rendering(ball); // get rid of glow
			if (GameActive && StatSnap==1)
			{
				display_comment(4,0);
				play_over(2,0);
			}	
		}
	}
	else
	{
		new classname[32];
		entity_get_string(ent,EV_SZ_classname,classname,31);
		if (equali(classname,"func_",5) && entity_get_int(ball,EV_INT_iuser1) == 0) 
		{
			entity_set_int(ball,EV_INT_iuser1,1); // dead ball
			entity_set_edict(ball,EV_ENT_owner,0); // clear owner
			set_rendering(ball); // get rid of glow
			if (GameActive && StatSnap==1)
			{
				display_comment(4,0);
				play_over(2,0);
			}	
		}
	}
	return PLUGIN_CONTINUE;
}

// stop a grenade from rolling too much
public stop_roll(ent) 
{
	// make sure were focusing on a ball
	if (is_valid_ent(ent)) 
	{
		// check and see if the ball is on the ground
		if (get_entity_flags(ent) & FL_ONGROUND)
		{
			// stop the ball
			entity_set_vector(ent,EV_VEC_velocity,Float:{0.0,0.0,0.0});
			entity_set_float(ent,EV_FL_gravity,1.0);
		}
		else
		{
			// if not, check again shortly
			set_task(5.0,"stop_roll",ent);
		}
	}
}

// weapon info changes
public event_domodels(id) 
{
	if (is_user_alive(id))
	{
		new clip, ammo, weapon = get_user_weapon(id,clip,ammo);
		if (weapon == CSW_HEGRENADE) 
		{
			entity_set_string(id,EV_SZ_viewmodel,"models/v_dodgeball.mdl");
			entity_set_string(id,EV_SZ_weaponmodel,"models/p_dodgeball.mdl");
		}
		else 
		{
			entity_set_string(id,EV_SZ_viewmodel,"models/v_hands.mdl");
			entity_set_string(id,EV_SZ_weaponmodel,"models/p_hands.mdl");
		}
	}
	return PLUGIN_CONTINUE;
}


// picked up a ball fix model display bug
public event_henade(id) 
{
	if (is_user_alive(id))
	{
		new clip, ammo, weapon = get_user_weapon(id,clip,ammo);
		if (weapon == CSW_HEGRENADE)
		{
			entity_set_string(id,EV_SZ_viewmodel,"models/v_dodgeball.mdl");
			entity_set_string(id,EV_SZ_weaponmodel,"models/p_dodgeball.mdl");
			entity_set_int(id,EV_INT_weaponanim,3);
		}
		else
		{
			entity_set_string(id,EV_SZ_viewmodel,"models/v_hands.mdl");
			entity_set_string(id,EV_SZ_weaponmodel,"models/p_hands.mdl");
			entity_set_int(id,EV_INT_weaponanim,3);
		}
	}
	return PLUGIN_CONTINUE;
}

// setups up both teams and the ball carrier is active
public setup_tackle()
{
	new players[32],num;
	get_players(players,num,"a");
	for (new i=0;i<num;i++) 
	{	
		if (get_user_team(players[i])==TeamWithBall)	
		{
			if (user_has_ball(players[i]))
			{
				set_user_godmode(players[i]);
				// slow him down a lil extra if hes the QB just cause
				if (players[i]==CT_QB || players[i]==T_QB)
					set_user_maxspeed(players[i],float(get_cvar_num("fm_maxspeed")-60));
				else
					set_user_maxspeed(players[i],float(get_cvar_num("fm_maxspeed")-30));
			}
			else
			{
				strip_user_weapons(players[i]);
				set_user_godmode(players[i],1);
				set_user_maxspeed(players[i],float(get_cvar_num("fm_maxspeed")));
			}
		}
		else
		{
			strip_user_weapons(players[i]);
			give_item(players[i],"weapon_knife");
			set_user_godmode(players[i],1);
			set_user_maxspeed(players[i],float(get_cvar_num("fm_maxspeed")));
		}
	}
	return PLUGIN_CONTINUE;
}

// someone gets hits!!
public on_damage(id)
{
	if (id>0)
	{
		new clip,ammo,norigin[3],attacker = get_user_attacker(id)
		if (is_user_alive(id) && is_user_alive(attacker))
		{
			set_user_health(id,300);
			if (user_has_ball(id) && get_user_weapon(attacker,clip,ammo)==CSW_KNIFE && get_user_team(attacker)!=get_user_team(id) && StatSnap!=2)
			{
				// say the tackle message
				display_comment(3,attacker);
				// end the current play/down
				play_over(1,id);
				// freeze player
				get_user_origin(id,norigin,0);
				norigin[2] = CTtd_loc[2]-10;
				set_user_origin(id,norigin);
				// give godmode so he doesn't die
				set_user_godmode(id,1);
				// give a frag for a tackle
				cs_set_user_deaths(attacker,cs_get_user_deaths(attacker)+1);
				// make player not glow
				set_rendering2(id,kRenderFxNone,0,0,0,kRenderTransAlpha,255);
			}
		}
		
	}
	return PLUGIN_CONTINUE;
}

// try and get a new game goings
public start_game()
{
	// if there is a current game, cancel
	if (GameActive || dwnum != 0)
		return PLUGIN_CONTINUE;
	// check to see if both teams have a player
	if (check_teams())
	{
		display_comment(13,0);
		GameActive = 1;
		tscore = 0
		ctscore = 0
		reset_drive();
		TeamWithBall = random_num(1,2);
		if (TeamWithBall==1)
		{
			Scrimage_loc = Ttd_loc[0]-380;
			FirstD_loc = Scrimage_loc-450;
		}
		else
		{
			Scrimage_loc = CTtd_loc[0]+380;
			FirstD_loc = Scrimage_loc+450;
		}
		set_task(1.0,"revive");
		set_task(3.5,"act_reset");
		remove_task(5273333);
	}
	else
	{
		new Players[32],pcount;
		get_players(Players,pcount,"a");
		for (new i=0;i<pcount;i++)
			give_item(Players[i],"weapon_hegrenade");
		display_comment(12,0);
		// check for right players again
		set_task(1.0,"revive");
		set_task(40.0,"start_game",5273333);
	}
	return PLUGIN_CONTINUE
}

// when the ball is snapped
public act_snap(id)
{
	StatSnap = 1;
	fdtime  = 0;
	
	// kill the snap counter
	remove_task(8675309);
	
	// play the hut wave
	client_cmd(0, "spk ^"football/hut.wav^" ");
	
	// snap message
	display_comment(1,id);
	
	// display second white help message
	display_help(2);

	// set timer incase of an error somewhere
	set_task(66.6,"play_over2",306);
	
	// get players ready to start the down
	new players[32],norigin[3],num;
	get_players(players,num,"a");
	for (new i=0;i<num;i++) 
	{
		// un-freeze players
		if (!(players[i]==T_QB) && !(players[i]==T_QB))
		{
			get_user_origin(players[i],norigin,0);
			norigin[2] = CTtd_loc[2];
			set_user_origin(players[i],norigin);
		}
		
		// screen flashes blue
		message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("ScreenFade"), {0,0,0}, players[i])
		write_short(3000) 	// duration
		write_short(3000) 	// hold time
		write_short(0) 		// flags
		write_byte(0) 		// red
		write_byte(0)		// green
		write_byte(150) 	// blue
		write_byte(95)		// alpha
		message_end()
		
		// kill if they cross the line of scrimmage
		if (is_user_alive(players[i]) && !is_user_bot(players[i]))
		{
			new origin[3],teamnum = get_user_team(players[i]);
			get_user_origin(players[i],origin);
			if ((origin[0]<Scrimage_loc && teamnum==1) || (origin[0]>Scrimage_loc && teamnum==2))
			{
				// freeze player
				if (get_user_team(players[i])==1)
					norigin[0] = Ttd_loc[0]+10;
				else
					norigin[0] = CTtd_loc[0]-10;
				norigin[1] = CTtd_loc[1]+random_num(-600,600);
				norigin[2] = CTtd_loc[2]-15;
				set_user_origin(players[i],norigin);
				// say player is offside
				display_comment(15,players[i]);
				// tell them to use help messages cause they are noobs
				set_hudmessage(255, 255, 255, -1.0, -0.84, 0, 1.0, 12.0, 2.0, 2.0, -1);
				ShowSyncHudMsg(players[i], g_msghelp, "You have been moved for being offside. If you are unsure how to play, please read Your Help messages on the top of your screen during play.");
				// end play if carrier dies
				if (user_has_ball(players[i]))
				{
					play_over(2,0);
					// make player not glow
					set_rendering2(players[i],kRenderFxNone,0,0,0,kRenderTransAlpha,255);
				}
			}
		}
	}
	// make ballcarrier tacklable now after the offsides
	setup_tackle();
}

// will call play_over becuase set_task is gay with arguments
public play_over2()
{
	play_over(2,0);
}

// after the pass 1=Complete 2=Incomplete
public play_over(status,user)
{
	// if this function is already running, dont start again.
	if (!GameActive || StatSnap==2)
		return PLUGIN_CONTINUE;	

	// kill the error timer
	remove_task(306);
	
	new Float:Resettime = 4.0;
	
	// when set to 2, no passes or catches
	StatSnap = 2;
	CurDown++;
	
	if (status==1)
	{
		new origin[3];
		get_user_origin(user,origin);
		if (get_user_team(user)==1)
		{
			if (origin[0]<Scrimage_loc && FirstD_loc!=10000)// short yardage gain
				display_comment(19,floatround((Scrimage_loc-origin[0])/35.0));
			if (origin[0]<CTtd_loc[0])// touchdown check
			{
				display_comment(5,1);
				display_touchdown(1);
				tscore += 7;
				Scrimage_loc = CTtd_loc[0]+380;
				FirstD_loc = Scrimage_loc+450;
				TeamWithBall = 2;
				client_cmd(0, "spk ^"football/cheer%d.wav^" ",random_num(1,6));
				Resettime = 7.0;
				reset_drive();
			}
			else if (origin[0]<FirstD_loc && FirstD_loc!=10000)// firstdown check
			{
				display_comment(7,user);
				CurDown = 1;
				Scrimage_loc = origin[0];
				FirstD_loc = origin[0]-450;
				Resettime = 5.0;
			}
			else if (FirstD_loc==10000)// interception check
			{
				Scrimage_loc = origin[0];
				FirstD_loc = origin[0]-450;
				Resettime = 5.0;
				reset_drive();
			}
			else// if they dont score or first down then new line of scrimmage
				Scrimage_loc = origin[0];
		}
		else
		{
			if (origin[0]>Scrimage_loc && FirstD_loc!=10000)// short yardage gain
				display_comment(19,floatround((origin[0]-Scrimage_loc)/35.0));
			if (origin[0]>Ttd_loc[0])
			{
				display_comment(5,2);
				display_touchdown(2);
				ctscore += 7;
				Scrimage_loc = Ttd_loc[0]-380;
				FirstD_loc = Scrimage_loc-450;
				TeamWithBall = 1;
				client_cmd(0, "spk ^"football/cheer%d.wav^" ",random_num(1,6));
				Resettime = 7.0;
				reset_drive();
			}
			else if (origin[0]>FirstD_loc && FirstD_loc!=10000)// firstdown check
			{
				display_comment(7,user);
				CurDown = 1;
				Scrimage_loc = origin[0];
				FirstD_loc = origin[0]+450;
				Resettime = 5.0;
			}
			else if (FirstD_loc==10000)// interception check
			{
				Scrimage_loc = origin[0];
				FirstD_loc = origin[0]+450;
				Resettime = 5.0;
				reset_drive();
			}
			else// if they dont score or first down then new line of scrimmage
				Scrimage_loc = origin[0];
		}
		
	}
	// check scores for a winner
	if (tscore>=get_cvar_num("fm_maxscore") || ctscore>=get_cvar_num("fm_maxscore"))
	{
		display_winner();
		display_comment(11,0);
		return PLUGIN_CONTINUE;
	}
	// make sure there is atleast 1 player on each team
	if (!check_teams())
	{
		GameActive = 0;
		display_comment(14,0);
		set_task(10.0,"start_game",5273333);
		return PLUGIN_CONTINUE;
	}
	// team ballancer
	new players[32],count,teams[5];
	get_players(players,count);
	for (new i=0;i<count;i++)
		if ((get_user_team(players[i])==1 || get_user_team(players[i])==2) && !is_user_bot(players[i]))
			teams[get_user_team(players[i])]++;
	// if ts have 2 more than cts
	if (teams[1]-teams[2]>1)
		act_switch(-2);
	// if cts have 2 more than ts
	if (teams[2]-teams[1]>1)
		act_switch(-1);
	// if ts have 1 more than cts and up 3 tds
	if ((teams[1]>teams[2]) && (tscore-ctscore>20))
		act_switch(-2);
	// if cts have 1 more than ts and up 3 tds
	if ((teams[2]>teams[1]) && (ctscore-tscore>20))
		act_switch(-1);
	// turnover check
	if (CurDown>get_cvar_num("fm_downs"))
	{
		display_comment(8,0);
		Resettime = 5.0;
		reset_drive();
		if (TeamWithBall==1)
		{
			FirstD_loc = Scrimage_loc+450;
			TeamWithBall = 2;
		}
		else
		{
			FirstD_loc = Scrimage_loc-450;
			TeamWithBall = 1;
		}
	}
	// make sure the scrimmage lines dont go past the field
	if (Scrimage_loc>Ttd_loc[0])
		Scrimage_loc = Ttd_loc[0];
	if (Scrimage_loc<CTtd_loc[0])
		Scrimage_loc = CTtd_loc[0];
	if (FirstD_loc>Ttd_loc[0])
		FirstD_loc = Ttd_loc[0];
	if (FirstD_loc<CTtd_loc[0])
		FirstD_loc = CTtd_loc[0];
	// we are ready to rock another down
	set_task(1.0,"revive",0,"",0,"a",1);
	set_task(Resettime,"act_reset",0,"",0,"a",1);

	return PLUGIN_CONTINUE;
}

// resets teams for a new down
public act_reset()
{
	// if this function is already running, dont start again.
	if (fdtime>0)
	{
		return;	
	}
	
	new ent;
	StatSnap = 0;
	
	// remove balls on the ground
	while((ent = find_ent_by_class(ent,"grenade")) != 0)
		remove_entity(ent);
	
	// play the whistle blowing sound
	client_cmd(0, "spk ^"football/whistle.wav^" ");
	
	//reset all players
	new players[32],num,spawn_loc[3],tcnt,ctcnt;
	get_players(players,num,"a");
	for(new i=0;i<num;i++)
	{
		//strip them incase they have a ball
		strip_user_weapons(players[i]);
		//fix model if messed
		event_henade(players[i]);
		//heal
		set_user_health(players[i],300);
		//take cash
		cs_set_user_money(players[i],0,0);
		//teleport to new starting position
		spawn_loc[2] = CTtd_loc[2]-10;
		if (get_user_team(players[i])==1)
		{
			if (!T_QB || !is_user_alive(T_QB) || !(get_user_team(T_QB)==1))
				T_QB = players[i];
			if (players[i]==T_QB)
			{
				if (TeamWithBall==1)
				{
					give_item(players[i],"weapon_hegrenade"); 
					set_rendering2(players[i],kRenderFxGlowShell,0,0,250,kRenderTransAlpha,255);
					set_user_maxspeed(players[i],100.0);
				}
				spawn_loc[0] = Scrimage_loc+120;
				spawn_loc[1] = Ttd_loc[1];
				spawn_loc[2] = CTtd_loc[2];
			}
			else
			{
				tcnt++;
				if (tcnt==1){ spawn_loc[0] = Scrimage_loc+50; spawn_loc[1] = Ttd_loc[1]-500;}
				else if (tcnt==2){ spawn_loc[0] = Scrimage_loc+50; spawn_loc[1] = Ttd_loc[1]+500;}
				else if (tcnt==3){ spawn_loc[0] = Scrimage_loc+50; spawn_loc[1] = Ttd_loc[1]-400;}
				else if (tcnt==4){ spawn_loc[0] = Scrimage_loc+50; spawn_loc[1] = Ttd_loc[1]+400;}
				else if (tcnt==5){ spawn_loc[0] = Scrimage_loc+50; spawn_loc[1] = Ttd_loc[1]-300;}
				else if (tcnt==6){ spawn_loc[0] = Scrimage_loc+50; spawn_loc[1] = Ttd_loc[1]+300;}
				else if (tcnt==7){ spawn_loc[0] = Scrimage_loc+50; spawn_loc[1] = Ttd_loc[1]-200;}
				else if (tcnt==8){ spawn_loc[0] = Scrimage_loc+50; spawn_loc[1] = Ttd_loc[1]+200;}
				else if (tcnt==9){ spawn_loc[0] = Scrimage_loc+50; spawn_loc[1] = Ttd_loc[1]-100;}
				else if (tcnt==10){ spawn_loc[0] = Scrimage_loc+50; spawn_loc[1] = Ttd_loc[1]+100;}
				else { spawn_loc[0] = Scrimage_loc+50; spawn_loc[1] = Ttd_loc[1];}
			}
		}
		else
		{
			if (!CT_QB || !is_user_alive(CT_QB) || !(get_user_team(CT_QB)==2))
				CT_QB = players[i];
			if (players[i]==CT_QB)
			{
				if (TeamWithBall==2)
				{
					give_item(players[i],"weapon_hegrenade");
					set_rendering2(players[i],kRenderFxGlowShell,0,0,250,kRenderTransAlpha,255);
					set_user_maxspeed(players[i],100.0);
				}
				spawn_loc[0] = Scrimage_loc-120;
				spawn_loc[1] = CTtd_loc[1];
				spawn_loc[2] = CTtd_loc[2];
			}
			else
			{
				ctcnt++;
				if (ctcnt==1){ spawn_loc[0] = Scrimage_loc-50; spawn_loc[1] = CTtd_loc[1]-500;}
				else if (ctcnt==2){ spawn_loc[0] = Scrimage_loc-50; spawn_loc[1] = CTtd_loc[1]+500;}
				else if (ctcnt==3){ spawn_loc[0] = Scrimage_loc-50; spawn_loc[1] = CTtd_loc[1]-400;}
				else if (ctcnt==4){ spawn_loc[0] = Scrimage_loc-50; spawn_loc[1] = CTtd_loc[1]+400;}
				else if (ctcnt==5){ spawn_loc[0] = Scrimage_loc-50; spawn_loc[1] = CTtd_loc[1]-300;}
				else if (ctcnt==6){ spawn_loc[0] = Scrimage_loc-50; spawn_loc[1] = CTtd_loc[1]+300;}
				else if (ctcnt==7){ spawn_loc[0] = Scrimage_loc-50; spawn_loc[1] = CTtd_loc[1]-200;}
				else if (ctcnt==8){ spawn_loc[0] = Scrimage_loc-50; spawn_loc[1] = CTtd_loc[1]+200;}
				else if (ctcnt==9){ spawn_loc[0] = Scrimage_loc-50; spawn_loc[1] = CTtd_loc[1]-100;}
				else if (ctcnt==10){ spawn_loc[0] = Scrimage_loc-50; spawn_loc[1] = CTtd_loc[1]+100;}
				else { spawn_loc[0] = Scrimage_loc-50; spawn_loc[1] = CTtd_loc[1];}
			}
		}
		set_user_origin(players[i],spawn_loc);
	}
	//display down number
	display_comment(9,0);
	// display white help messages
	display_help(1);
	//start new down timer
	fdtime = get_cvar_num("fm_playclock");
	set_task(1.0,"display_timer",8675309,"",0,"b");
}

// countdown timer for the play clock
public display_timer()
{
	switch (fdtime)
	{
		case 0: {
			set_hudmessage(150, 0, 0, -1.0, 0.80, 0, 1.0, 1.0, 0.01, 0.01, -1);
			ShowSyncHudMsg(0, g_msgsync, "  HUT!^n  HUT!");
		}
		case 1: {
			set_hudmessage(255, 128, 0, -1.0, 0.80, 0, 1.0, 1.0, 0.01, 0.01, -1);
			ShowSyncHudMsg(0, g_msgsync, "  Set!^n   %d  ", fdtime);
		}
		case 2: {
			set_hudmessage(150, 150, 0, -1.0, 0.80, 0, 1.0, 1.0, 0.01, 0.01, -1);
			ShowSyncHudMsg(0, g_msgsync, "  Down!^n   %d  ", fdtime);
		}
		default: {
			set_hudmessage(0, 150, 0, -1.0, 0.80, 0, 1.0, 1.0, 0.01, 0.01, -1);
			ShowSyncHudMsg(0, g_msgsync, "Play Clock^n   %d  ", fdtime);
		}
	}
	if (fdtime < 1)
	{
		act_snap(0);
		return;
	}
	fdtime--;
}

// initiates the lines and the scoreboard
public  create_fldlines()
{
	if (GameActive)
	{
		//make scrimmage lines
		new ids[3]
		num_to_str(1,ids,2)
		set_task(0.4,"create_line",0,ids,2,"a",1);
		num_to_str(2,ids,2)
		set_task(0.8,"create_line",0,ids,2,"a",1);

		//scoreboard
		set_hudmessage(10, 240, 10, -0.8452, -0.84, 0, 1.0, 5.0, 0.0, 0.0, -1);
		ShowSyncHudMsg(0, g_msgsboard, "     The Score^n     CTs      Ts     ^n      %d       %d",ctscore,tscore);
	}
}

// puts the first down and line of scrimmage on the map
public create_line(ids[])
{
	new loc,clrs[3];
	if (str_to_num(ids) == 2)
	{
		loc = FirstD_loc;
		clrs = { 255, 255, 0 };
	}
	else
	{
		loc = Scrimage_loc;
		clrs = { 0, 0, 255 };
	}
	
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY) 
	write_byte(0)		//TE_BEAMPOINTS
	write_coord(loc)		//centerpoint
	write_coord(CTtd_loc[1]+2000)	//left top corner
	write_coord(CTtd_loc[2]-34)	//horizontal height
	write_coord(loc)		//centerpoint
	write_coord(Ttd_loc[1]-2000)	//left right corner
	write_coord(CTtd_loc[2]-34)	//horizontal height
	write_short(beamspr)		//sprite to use
	write_byte(1)		// framestart
	write_byte(1)		// framerate
	write_byte(42)		// life in 0.1's
	write_byte(15)		// width
	write_byte(0)		// noise
	write_byte(clrs[0])	// red
	write_byte(clrs[1])	// green
	write_byte(clrs[2])	// blue
	write_byte(200)		// brightness
	write_byte(0)		// speed
	message_end()
	return PLUGIN_CONTINUE;
}

// if one team scores a touchdown make their screen flash
public display_touchdown(team)
{
	new players[32],num,clr[3];
	get_players(players,num,"a");
	for (new i=0;i<num;i++) 
	{
		if (get_user_team(players[i])==team)
			clr = {0,170,0};
		else
			clr = {170,0,0};
		// screen flashes
		message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("ScreenFade"), {0,0,0}, players[i])
		write_short(3000) 	// duration
		write_short(3000) 	// hold time
		write_short(0) 		// flags
		write_byte(clr[0])	// red
		write_byte(clr[1])	// green
		write_byte(clr[2])	// blue
		write_byte(95)		// alpha
		message_end()
	}
}

// if one teams wins
public display_winner()
{
	new twinner[22],clr[3];
	dwnum++;
	dwnum2++;
	GameActive = 0;
	switch(random_num(1,7))
	{
		case 1: clr = {255,0,0};
		case 2: clr = {0,255,0};
		case 3: clr = {0,0,255};
		case 4: clr = {255,255,0};
		case 5: clr = {0,255,255};
		case 6: clr = {255,0,255};
		case 7: clr = {255,255,255};
	}
	if (tscore>ctscore)
		formatex(twinner, 20, "TERRORISTS");
	else
		formatex(twinner, 20, "COUNTER-TERRORISTS");
	
	// display messages and colours
	display_touchdown(dwnum2);
	set_hudmessage(clr[0], clr[1], clr[2], -0.8452, -0.84, 0, 1.0, 12.0, 0.0, 0.0, -1);
	ShowSyncHudMsg(0, g_msgsboard, "   %s^n        WIN!!^n      %d       %d",twinner,ctscore,tscore);
	set_hudmessage(clr[0], clr[1], clr[2], -1.0, 0.80, 0, 1.0, 10.0, 0.01, 0.01, -1);
 	ShowSyncHudMsg(0, g_msgsync, "GAME OVER!");

	// repeat win message
	if (dwnum<20)
		set_task(0.5,"display_winner");
	else
	{
		dwnum = 0;
		// give them 30secs to play
		set_task(30.0,"start_game",5273333);
		// respawn them and give them some balls
		new Players[32],pcount;
		get_players(Players,pcount,"a");
		for (new i=0;i<pcount;i++)
		{
			spawn(Players[i]);
			spawn(Players[i]);
			give_item(Players[i],"weapon_hegrenade");
		}
	}
	if (dwnum2==2)
		dwnum2 = 0;
}

// display a game related message in green
public display_comment(type,user)
{
	new mssge[200],players[32],name[16],count;
	get_user_name(user,name,15);
	
	switch(type)
	{
		case 1: {//ball is snapped
			if (user)
				switch(random_num(1,6))
				{
					case 1: formatex(mssge, 192, "^x04The QB takes the snap and sits back in the pocket.");
					case 2: formatex(mssge, 192, "^x03%s^x04 snaps the ball",name);
					case 3: formatex(mssge, 192, "^x04The QB gets the snap and looks down field.");
					case 4: formatex(mssge, 192, "^x04The ball is snapped and the QB gets in position to make a throw.");
					case 5: formatex(mssge, 192, "^x04The QB calls hut and fades back with the pigskin.");
					case 6: formatex(mssge, 192, "^x03%s^x04 snaps the ball and the play starts.",name);
				}
			else
				formatex(mssge, 511, "^x04The ball is snapped and play has begun.");
		}
		case 2: {//ball is thrown
			if (user)
				switch(random_num(1,7))
				{
					case 1: formatex(mssge, 192, "^x03%s^x04 spots a receiver and tosses him the ball.",name);
					case 2: formatex(mssge, 192, "^x04The ball is thrown by ^x03%s^x04!",name);
					case 3: formatex(mssge, 192, "^x03%s^x04 winds up and throws a long bomb.",name);
					case 4: formatex(mssge, 192, "^x03%s^x04 hits an open receiver with a pass.",name);
					case 5: formatex(mssge, 192, "^x03%s^x04 fakes to one side and throws to the other.",name);
					case 6: formatex(mssge, 192, "^x04The QB ^x03%s^x04 throws a bomb, deep!",name);
					case 7: formatex(mssge, 192, "^x03%s^x04 throws up the hailmary!",name);
				}
			else
				formatex(mssge, 511, "^x04The ball is snapped and play has begun.");
		}
		case 3: {//tackled
			switch(random_num(1,4))
			{
				case 1: formatex(mssge, 192, "^x03%s^x04 makes the tackle.",name);
				case 2: formatex(mssge, 192, "^x03%s^x04 takes down the ball carrier.",name);
				case 3: formatex(mssge, 192, "^x03%s^x04 makes a play and tags the receiver.",name);
				case 4: formatex(mssge, 192, "^x04The tackle is made by ^x03%s^x04!",name);
			}
		}
		case 4: {//incomplete
			switch(random_num(1,3))
			{
				case 1: formatex(mssge, 192, "^x04The ball is thrown incomplete!");
				case 2: formatex(mssge, 192, "^x04The receiver missed the pass.");
				case 3: formatex(mssge, 192, "^x04The ball is over-thrown and incomplete.");
			}
		}
		case 5: {//touchdown
			if (TeamWithBall==1)
				formatex(mssge, 511, "^x04TOUCHDOWN TERRORISTS!");
			else
				formatex(mssge, 511, "^x04TOUCHDOWN COUNTER-TERRORISTS!");
		}
		case 6: {//interception
			switch(random_num(1,3))
			{
				case 1: formatex(mssge, 192, "^x03%s^x04 picks off the pass.",name);
				case 2: formatex(mssge, 192, "^x04The ball has been intercepted by ^x03%s^x04!",name);
				case 3: formatex(mssge, 192, "^x03%s^x04 intercepts the pass and goes the other way.",name);
			}
		}
		case 7: {//first down
			switch(random_num(1,3))
			{
				case 1: formatex(mssge, 192, "^x04 First down ^x03%s^x04!",name);
				case 2: formatex(mssge, 192, "^x03%s^x04 gets the ball to the first down line!",name);
				case 3: formatex(mssge, 192, "^x03%s^x04 takes the ball over the first down line.",name);
			}
		}
		case 8: {//turnover on downs
			new tname[20];
			if (TeamWithBall==1)
				formatex(tname, 20, "Terrorists");
			else
				formatex(tname, 20, "Counter-Terrorists");
		
			switch(random_num(1,3))
			{
				case 1: formatex(mssge, 192, "^x04The ball is turned over by the ^x03%s^x04 on downs!",tname);
				case 2: formatex(mssge, 192, "^x04The ^x03%s^x04 failed to get the first down and the ball is turned-over.",tname);
				case 3: formatex(mssge, 192, "^x04The ^x03%s^x04 loose possession of the ball on downs.",tname);
			}
		}
		case 9: {//down print
			new tname[20];
			if (TeamWithBall==1)
				formatex(tname, 20, "Terrorists");
			else
				formatex(tname, 20, "Counter-Terrorists");
		
			switch(CurDown)
			{
				case 1: formatex(mssge, 192, "^x03%dst^x04 down for ^x03%s^x04!",CurDown,tname);
				case 2: formatex(mssge, 192, "^x03%dnd^x04 down for ^x03%s^x04!",CurDown,tname);
				case 3: formatex(mssge, 192, "^x03%drd^x04 down for ^x03%s^x04!",CurDown,tname);
				default: formatex(mssge, 192, "^x03%dth^x04 down for ^x03%s^x04!",CurDown,tname);
			}
		}
		case 10: {//ball caught
			switch(random_num(1,6))
			{
				case 1: formatex(mssge, 192, "^x03%s^x04 hauls in the pass!",name);
				case 2: formatex(mssge, 192, "^x04The pass is caught by ^x03%s^x04!",name);
				case 3: formatex(mssge, 192, "^x03%s^x04 makes a nice grab!",name);
				case 4: formatex(mssge, 192, "^x03%s^x04 snags the ball!",name);
				case 5: formatex(mssge, 192, "^x03%s^x04 completes the pass!",name);
				case 6: formatex(mssge, 192, "^x04The ball is caught by ^x03%s^x04 and moves up-field.",name);
			}
		}
		case 11: {//gameover
			if (tscore>ctscore)
				formatex(mssge, 511, "^x04 TERRORISTS WIN!");
			else
				formatex(mssge, 511, "^x04 COUNTER-TERRORISTS WIN!");
		}
		case 12: {//not enough players
			switch(random_num(1,2))
			{
				case 1: formatex(mssge, 192, "^x04 A game will start once there are is a player on each team. If you need help, type /help in chat.");
				case 2: formatex(mssge, 192, "^x04 We are currently waiting for each team to have a player, so we can start. For help, type /help in chat.");
			}
		}
		case 13: {//new game
			switch(random_num(1,2))
			{
				case 1: formatex(mssge, 192, "^x04 A new game is about to begin!");
				case 2: formatex(mssge, 192, "^x04 A new game is starting!");
			}
		}
		case 14: {//game caned
			formatex(mssge, 192, "^x04This game has been cancelled due to one team not having a player!");
		}
		case 15: {//offside
			formatex(mssge, 192, "^x03%s^x04 crossed the srimmage line before the snap!^x03 MAKE SURE YOU READ -=YOUR HELP=-!!",name);
		}
		case 16: {//make new qb
			if (get_user_team(user)==1)
				formatex(mssge, 192, "^x03%s ^x04is the new^x03 Terrorist^x04 QB.",name);
			else
				formatex(mssge, 192, "^x03%s ^x04is the new^x03 Counter-Terrorist^x04 QB.",name);
		}
		case 17: {//switch player team
			new tname[20];
			if (get_user_team(user)==1)
				formatex(tname, 20, "Terrorists");
			else
				formatex(tname, 20, "Counter-Terrorists");
			formatex(mssge, 192, "^x03%s^x04 has been switch to the ^x03%s^x04!^x03 say /switch to change teams.",name,tname);
		}
		case 18: {//player rushed
			formatex(mssge, 192, "^x03%s^x04 tried to Rush the Scrimmage Line but it's currently disabled with /voterush",name);
		}
		case 19: {//yards gained
			new tname[20];
			if (TeamWithBall==1)
				formatex(tname, 20, "Terrorists");
			else
				formatex(tname, 20, "Counter-Terrorists");

			switch(random_num(1,2))
			{
				case 1: formatex(mssge, 192, "^x03%s^x04 gained ^x03%d^x04 yards on the play!",tname,user);
				case 2: formatex(mssge, 192, "^x03%s^x04 got a total of ^x03%d^x04 yards.",tname,user);
			}
		}
	}

	mssge[192] = '^0';
	get_players(players,count,"a");
	for (new i=0;i<count;i++)
	{
		message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("SayText"), {0,0,0}, players[i]);
		write_byte(players[i]);
		write_string(mssge);
		message_end();
	}
	return PLUGIN_CONTINUE;
}

// display a game related message in orange
public display_help(type)
{
	if (!get_cvar_num("fm_helpmsg"))
		return PLUGIN_CONTINUE;
	new mssge[200],players[32],count;
	get_players(players,count,"a");
	for (new i=0;i<count;i++)
	{
		if (get_user_team(players[i])==TeamWithBall)
		{
			if (players[i]==CT_QB || players[i]==T_QB)
				switch(type)
				{
					case 1: formatex(mssge, 192, "-=YOUR HELP=-  -=POSITION: Quarterback=-^nDo NOT cross the blue line until the ball is snapped/hutted. Get into position to either throw or run the football while wait for the snap.");
					case 2: formatex(mssge, 192, "-=YOUR HELP=-  -=POSITION: Quarterback=-^nNow either sitback and throw to an open receiver or try and rush the ball over the first down line.");
					case 3: formatex(mssge, 192, "-=YOUR HELP=-  -=POSITION: Quarterback=-^nNow you can try and block for the ball-carrier, or if he is behind the scrimmage line try and get open for a pass.");
				}
			else
				switch(type)
				{
					case 1: formatex(mssge, 192, "-=YOUR HELP=-  -=POSITION: Receiver=-^nWait for the ball to be snapped/hutted.");
					case 2: formatex(mssge, 192, "-=YOUR HELP=-  -=POSITION: Receiver=-^nNow you can run up-field and try and get open for a pass from the QB.");
					case 3: formatex(mssge, 192, "-=YOUR HELP=-  -=POSITION: Receiver=-^nIf you have the ball, you can try and outrun the defenders, or if you don't have the ball you can block defenders.");
				}
		}
		else
		{
			if (players[i]==CT_QB || players[i]==T_QB)
				switch(type)
				{
					case 1: formatex(mssge, 192, "-=YOUR HELP=-  -=POSITION: Safety=-^nDo NOT cross the blue line until the ball is snapped/hutted. Your responsibiliy is to cover the QB, stay close to him.");
					case 2: formatex(mssge, 192, "-=YOUR HELP=-  -=POSITION: Safety=-^nNow that the ball is snapped you can either rush the QB or cover a receiver or play zone defense and try and pick the ball.");
					case 3: formatex(mssge, 192, "-=YOUR HELP=-  -=POSITION: Safety=-^nNow it is your responsibility to stop the ball-carrier or to try and intercept the football.");
				}
			else
				switch(type)
				{
					case 1: formatex(mssge, 192, "-=YOUR HELP=-  -=POSITION: Defensiveback=-^nSit and wait for the QB to snap/hut the football.");
					case 2: formatex(mssge, 192, "-=YOUR HELP=-  -=POSITION: Defensiveback=-^nNow that the ball is snapped you can either rush the QB or you can most likely cover a Receiver and try and pick the ball.");
					case 3: formatex(mssge, 192, "-=YOUR HELP=-  -=POSITION: Defensiveback=-^nIf the ball is caught you need to tackle the ball-carrier or if the ball is in the air you can try and pick it off.");
				}
		}
		set_hudmessage(255, 128, 0, -1.0, -0.84, 1, 1.0, 10.0, 0.5, 0.5, -1);
		ShowSyncHudMsg(players[i], g_msghelp, "%s", mssge);
	}
	return PLUGIN_CONTINUE;
}

// makes a motd on how to play
public display_info(id)
{
	new mssge[1200],iLen;
	iLen = format(mssge, 1200, "<style>body{background-color:black;color:white;font-family:verdana}a{color:white}</style><center><h1>American Football Mod</h1>Created by: WhooKid (travomail@gmail.com)<br><a href=http://forums.alliedmods.net/showthread.php?t=63165>Get this mod here</a>");
	iLen += format(mssge[iLen], 1200 - iLen, "<table><tr><td><u>Commands</u><br><font size=2><li>say <b>/qb</b> - <i>Make you the QB of your team</i></li><li>say <b>/start</b> - <i>Starts a new Football game</i></li><li>say <b>/switch</b> - <i>Switches a player to the opposite team</i></li>");
	iLen += format(mssge[iLen], 1200 - iLen, "<li>say <b>/voterush</b> - <i>Starts a vote on rushing</i></li><li>press <b>+USE key (default 'e')</b> - <i>Activates Speed Burst (allowed 1 per drive)</i></li><li><b>to catch</b> - <i>let the ball hit you</i></li></table>");
	show_motd(id,mssge,"Football Help");
	return PLUGIN_CONTINUE;
}

// when a granade is thrown
public think_grenade(ent) 
{
	new model[32];
	entity_get_string(ent,EV_SZ_model,model,31);

	if (!equali(model,"models/w_dodgeball.mdl"))
	{
		return PLUGIN_CONTINUE;
	}
	// stop grenade from blowing up
	return PLUGIN_HANDLED;
}
 
// model set
public fw_setmodel(ent,model[]) 
{
 	// change grenades to dodgeballs
	if (equali(model,"models/w_hegrenade.mdl")) 
	{
		entity_set_model(ent,"models/w_dodgeball.mdl");
		return FMRES_SUPERCEDE;
	}
	return FMRES_IGNORED;
}

 // fire in the hole sound
public  msg_sendaudio() 
{
	new string[32];
	get_msg_arg_string(2,string,31);

	// stop grenade throwing radio alerts
	if (equali(string,"%!MRAD_FIREINHOLE"))
	{
		return PLUGIN_HANDLED;
	}
	return PLUGIN_CONTINUE;
}

// fire in the hole message AND weapon cannot be dropped message
public msg_textmsg() 
{
	new string[32];
	// "This weapon cannot be dropped"
	get_msg_arg_string(2,string,31);
	if (equali(string,"#Weapon_Cannot_Be_Dropped"))
	{
		return PLUGIN_HANDLED;
	}

	// some exception thingy
	if (str_to_num(string) > 0)
	{
		// if it's a radio message
		if (get_msg_args()>2)
		{
			get_msg_arg_string(3,string,31);
			if (equali(string,"#Game_radio"))
			{
				// "Fire in the hole!"
				get_msg_arg_string(5,string,31);
				if (equali(string,"#Fire_in_the_hole"))
					return PLUGIN_HANDLED;
			}
		}
	}
	return PLUGIN_CONTINUE;
}

// check everytime someone presses a button for burst
public fw_start(const id,const uc_handle,random_seed)
{
	if (!is_user_alive(id) || !get_cvar_num("fm_allowburst") || Burst[id])
		return FMRES_IGNORED;

	static buttons;
	buttons = get_uc(uc_handle,UC_Buttons);

	if (buttons & IN_USE)
		act_burst(id);

	return FMRES_SUPERCEDE;
}

// initiate the players speed burst
public act_burst(id)
{
	Burst[id] = 1;
		
	new origin[3],user[1];

	get_user_origin(id,origin);
	origin[2] -= 26;
	user[0] = id;
	
	act_explode(origin);
	act_trail(user[0]);
	set_task(0.9,"act_trail",id,user,1,"b");
}

// execute the speed burst on the player
public act_trail(user[])
{
	new clr[3],id = user[0];
	BrsCnt[id]++;
	if (!is_user_alive(id))
	{
		remove_task(id);
		return PLUGIN_CONTINUE;
	}
	if (BrsCnt[id]<5)
	{
		switch (get_user_team(id))
		{
			case 1: clr = {150,0,0};
			case 2: clr = {0,0,150};
		}
		if (user_has_ball(id))
			set_user_maxspeed(id,float(get_cvar_num("fm_burstspeed")-30));
		else
			set_user_maxspeed(id,float(get_cvar_num("fm_burstspeed")));
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
		write_byte(TE_BEAMFOLLOW);
		write_short(id);
		write_short(beamspr);
		write_byte(15);
		write_byte(8);
		write_byte(clr[0]);// red
		write_byte(clr[1]);// green
		write_byte(clr[2]);// blue
		write_byte(255);
		message_end();
	}
	else
	{
		remove_task(id);
		if (user_has_ball(id))
			set_user_maxspeed(id,float(get_cvar_num("fm_maxspeed")-30));
		else
			set_user_maxspeed(id,float(get_cvar_num("fm_maxspeed")));
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
		write_byte(TE_KILLBEAM);
		write_short(id);
		message_end();
	}
	return PLUGIN_CONTINUE;
}

// admin can assign any player to a qb
public set_qb(id,level,cid)
{
	if (!cmd_access(id,level,cid,2))
		return PLUGIN_HANDLED;
	
	new arg[32],name[32],name2[32];
	read_argv(1,arg,31);
	new player = cmd_target(id, arg, 2);
	if (!player)
		return PLUGIN_HANDLED
	get_user_name(id,name,31);
	get_user_name(player,name2,31);
	
	if (get_user_team(player)==1)
		T_QB = player;
	else
		CT_QB = player;
	
	display_comment(16,player);
	log_amx("RF Set QB: Admin %s made %s QB",name,name2);
	
	return PLUGIN_HANDLED;
}

// admin can set the current down to whatever
public set_down(id,level,cid)
{
	if (!cmd_access(id,level,cid,2))
		return PLUGIN_HANDLED;
	
	new arg[32],name[32];
	read_argv(1,arg,4);
	get_user_name(id,name,31);

	if (!is_str_num(arg))
		return PLUGIN_HANDLED;
	
	CurDown = str_to_num(arg);
	
	display_comment(9,0);
	log_amx("RF Set Down: Admin %s set team #%d current down to %s",name,TeamWithBall,arg);
	
	return PLUGIN_HANDLED;
}

// admin can set if they want players to be able to rush or not
public set_rush(id,level,cid)
{
	if (!cmd_access(id,level,cid,2))
		return PLUGIN_HANDLED;
	
	new arg[32],name[32];
	read_argv(1,arg,7);
	get_user_name(id,name,31);

	if (equali(arg,"yes") || equali(arg,"on") || equali(arg,"1"))
	{
		client_print (0,print_chat,"[AMXX] Rushing is now allowed.");			
		NoRushing = 0;
	}
	else if (equali(arg,"no") || equali(arg,"off") || equali(arg,"0"))
	{
		client_print (0,print_chat,"[AMXX] Rushing is now disallowed.");			
		NoRushing = 1;
		act_norush();
	}
	else
	{
		client_print(id,print_chat,"[AMXX] amx_setrush usage: <yes|on|1|no|off|0>");
		return PLUGIN_HANDLED;
	}
	
	log_amx("RF Set Rush: Admin %s set rushing to %s",name,arg);
	
	return PLUGIN_HANDLED;
}

// admin can set a score to whatever he wants
public set_score(id,level,cid)
{
	if (!cmd_access(id,level,cid,3))
		return PLUGIN_HANDLED;
	
	new arg[32],arg2[8],name[32];
	read_argv(1,arg,31);
	read_argv(2,arg2,7);
	get_user_name(id, name,31);

	if (!is_str_num(arg2))
		return PLUGIN_HANDLED;

	if (equali(arg,"t") || equali(arg,"1"))
		tscore = str_to_num(arg2);
	else if (equali(arg,"ct") || equali(arg,"2"))
		ctscore = str_to_num(arg2);
	else {
		client_print(id,print_chat,"[AMXX] amx_setscore usage: <t|1|ct|2> <point #>");
		return PLUGIN_HANDLED;
	}

	log_amx("RF Set Score: Admin %s set the score of %s to %s",name,arg,arg2);
	
	return PLUGIN_HANDLED;
}

// admin can make a player burst
public make_burst(id,level,cid)
{
	if (!cmd_access(id,level,cid,2))
		return PLUGIN_HANDLED
	
	new arg[32],name[32],name2[32];
	read_argv(1,arg,31);
	new player = cmd_target(id, arg, 2);
	if (!player)
		return PLUGIN_HANDLED;
	get_user_name(id,name,31);
	get_user_name(player,name2,31);
	
	new origin[3],user[1];
	get_user_origin(player,origin);
	origin[2] -= 26;
	user[0] = player;
	BrsCnt[id] = 0;
	act_explode(origin);
	act_trail(user[0]);
	set_task(0.9,"act_trail",player,user,1,"b");
	
	log_amx("RF Make Burst: Admin %s made %s Speed Burst",name,name2);
	
	return PLUGIN_HANDLED;
}

// make new QB
public act_qb(id)
{
	if (id==T_QB || id==CT_QB)
	{
		client_print(id,print_chat,"[AMXX] You currently are the QB.");
	}
	else if (QB_lock[get_user_team(id)])
	{
		client_print(id,print_chat,"[AMXX] The QB is already choosen for this drive.");
		client_print(id,print_chat,"[AMXX] The QB can only be changed once per drive.");
	}
	else if (StatSnap!=2 || !GameActive)
	{
		client_print(id,print_chat,"[AMXX] You can only change to the QB after the play.");
	}
	else if (get_user_team(id)==1)
	{
		T_QB = id;
		display_comment(16,id);
		if (TeamWithBall==1)
			QB_lock[1] = 1;
	}
	else
	{
		CT_QB = id;
		display_comment(16,id);
		if (TeamWithBall==2)
			QB_lock[2] = 1;
	}
	return PLUGIN_CONTINUE;
}

// switch a user between teams
public act_switch(id)
{
	// if id>0 then player is specified
	if (id>0)
	{
		if (StatSnap==1)
		{
			client_print(id,print_chat,"[AMXX] You can only change teams after the play.")
			return PLUGIN_CONTINUE;
		}
		// clear QB if he switches
		if (id==CT_QB && id==T_QB)
			QB_lock[get_user_team(id)] = 0;
		switch(get_user_team(id))
		{
			case 0: {
				cs_set_user_team(id,CS_TEAM_CT);
				display_comment(17,id);
			}
			case 1: {
				cs_set_user_team(id,CS_TEAM_CT);
				display_comment(17,id);
			}
			case 2: {
				cs_set_user_team(id,CS_TEAM_T);
				display_comment(17,id);
			}
		}
	}
	else
	{
		new j,plyr,ovflw;
		while (j==0 && ovflw<55)
		{
			// pick a player at random
			plyr = random_num(1,get_playersnum());
			// check and see if hes a ct and if we are changing a t
			if (id == -1 && get_user_team(plyr)==2 && !is_user_admin(plyr) && plyr!=CT_QB && plyr!=T_QB)
			{
				cs_set_user_team(plyr,CS_TEAM_T);
				display_comment(17,plyr);
				j = 1;
			}
			else if (id == -2 && get_user_team(plyr)==1 && !is_user_admin(plyr) && plyr!=CT_QB && plyr!=T_QB)
			{
				cs_set_user_team(plyr,CS_TEAM_CT);
				display_comment(17,plyr);
				j = 1;
			}
			ovflw++;
		}
	}
	return PLUGIN_CONTINUE;
}

// in a player pushes off
public act_push(user1,user2) 
{
	//
	if (get_cvar_num("fm_allowpushoff") && StatSnap && !user_has_ball(user2) && !is_user_admin(user2) && (pev(user2,pev_flags) & FL_ONGROUND))
	{
		new Float:momntm[2][3];
		entity_get_vector(user1,EV_VEC_origin,momntm[0]);
		entity_get_vector(user2,EV_VEC_origin,momntm[1]);
		for (new a=0; a<3; a++) 
		{
			momntm[1][a] -= momntm[0][a];
			momntm[1][a] *= 7;
		}
		entity_set_vector(user2,EV_VEC_velocity,momntm[1]);
	}
}

// if a user has a ball
public user_has_ball(id)
{
	new clip, ammo;
	get_user_ammo(id,CSW_HEGRENADE,clip,ammo);
	return ammo;
}

// if a user has a ball
public check_teams()
{
	new players[32],count,teams[4];
	get_players(players,count,"a");
	for (new i=0;i<count;i++)
	{
		if (get_user_team(players[i])>0)
			teams[get_user_team(players[i])]++;
		if (teams[1]>0 && teams[2]>0)
			return 1;
	}
	return 0;
}

// when a play spawns
public event_resethud(id)
{
	new ids[3]
	num_to_str(id,ids,2);
	set_task(0.5,"reset_player",0,ids,2);
}

// resets play after he spawns
public reset_player(user[])
{
	new id = str_to_num(user);
	if (is_user_alive(id))
	{
		// strip them incase they have a ball
		new save = user_has_ball(id);
		strip_user_weapons(id);
		if(save) give_item(id,"weapon_hegrenade");
		// heal
		set_user_health(id,300);
		// take cash
		cs_set_user_money(id,0,0);
		// make play invincible
		set_user_godmode(id,1);
		// hide uneeded hud sprites
		message_begin(MSG_ONE, get_user_msgid("HideWeapon"), _, id); 
		write_byte((1<<1) | (1<<3) | (1<<4) | (1<<5)); 
		message_end();
	}
}

// resets both teams after a turnover
public reset_drive()
{
	CurDown = 1;
	QB_lock[1] = QB_lock[2] = 0;
	arrayset(Burst,0,get_playersnum()+4);
	arrayset(BrsCnt,0,get_playersnum()+4);
}

// bring back the dead
public revive()
{ 
	new players[32],num;
	get_players(players,num,"b");
	for (new i=0;i<num;i++) 
		if (get_user_team(players[i])==1 || get_user_team(players[i])==2)
		{
			spawn(players[i]);
			spawn(players[i]);
		}
}

// player leaves
public client_disconnect(id)
{
	// if the player with the ball leaves then end down
	if (user_has_ball(id) && GameActive)
		play_over(2,0);
}

// voting stuff
public vote_start(id)
{
	if (!get_cvar_num("fm_allowvoterush"))
	{
		client_print(id,print_chat,"[AMXX] Rushing is permanently enabled.")
		return PLUGIN_HANDLED; 
	}
	else if (!GameActive)
	{
		client_print(id,print_chat,"[AMXX] You can only preform a vote during play.")
		return PLUGIN_HANDLED; 
	}
	else if (get_gametime()-votetime <= 20.0 && votetime)
	{
		client_print(id, print_chat,"[AMXX] We are already voting on rushing.");
		return PLUGIN_HANDLED;
	}
	else if (get_gametime()-votetime <= 130.0 && votetime)
	{
		client_print(id, print_chat,"[AMXX] We just recently voted on rushing. Please wait a few minutes.");
		return PLUGIN_HANDLED;
	}
	new name[32];
	get_user_name(id,name,31);
		
	show_menu(0,(1<<0)|(1<<1),"\yRushing the Scrimmage Line should be?\w^n^n\r1. \wAllowed^n\r2. \wDisallowed",30);
	client_print(0,print_chat,"[AMXX] %s has started a vote on rushing by saying /voterush",name);
	
	votetime = get_gametime();
	choice[0] = choice[1] = 0;
	
	set_task(20.0,"vote_check");
	return PLUGIN_HANDLED; 
}

// register a vote
public vote_count(id,key)
{
	new name[32];
	get_user_name(id,name,31);

	client_print(0,print_chat,"[AMXX] %s voted to %s.",name,key ? "disable rushing" : "allow rushing");

	choice[key]++;
	return PLUGIN_HANDLED;
}

// check the ballots
public vote_check()
{
	// if draw then defaults to allow rush
	if (choice[0] >= choice[1])
	{
		if (NoRushing)
			client_print (0,print_chat,"[AMXX] Rushing is now allowed. (On:%d) (Off:%d).",choice[0],choice[1]);		
		else 
			client_print (0,print_chat,"[AMXX] Rushing is still allowed. (On:%d) (Off:%d).",choice[0],choice[1]);			
		NoRushing = 0;
	}
	else
	{
		if (NoRushing)
			client_print (0,print_chat,"[AMXX] Rushing is still disallowed. (On:%d) (Off:%d).",choice[0],choice[1]);
		else 
			client_print (0,print_chat,"[AMXX] Rushing is now disallowed. (On:%d) (Off:%d).",choice[0],choice[1]);			
		NoRushing = 1;
		act_norush();
	}
	return PLUGIN_CONTINUE;
}

// the no rushing action
public act_norush()
{
	if (NoRushing)
	{
		// kill if they cross the line of scrimmage
		new players[32],norigin[3],num;
		get_players(players,num,"a");
		for (new i=0;i<num;i++)
		{
			if (GameActive && FirstD_loc!=10000 && StatSnap==1 && !is_user_bot(players[i]))
			{
				new origin[3],teamnum = get_user_team(players[i]);
				get_user_origin(players[i],origin);
				if (((origin[0]<Scrimage_loc && teamnum==1) || (origin[0]>Scrimage_loc && teamnum==2)) && (teamnum!=TeamWithBall || (user_has_ball(players[i]) && (players[i]==CT_QB || players[i]==T_QB))))
				{
					// freeze player
					if (get_user_team(players[i])==1)
						norigin[0] = Ttd_loc[0]+10;
					else
						norigin[0] = CTtd_loc[0]-10;
					norigin[1] = CTtd_loc[1]+random_num(-600,600);
					norigin[2] = CTtd_loc[2]-10;
					set_user_origin(players[i],norigin);
					// say player is offside
					display_comment(18,players[i]);
					// tell them to use help messages cause they are noobs
					set_hudmessage(255, 255, 255, -1.0, -0.84, 0, 1.0, 12.0, 2.0, 2.0, -1);
					ShowSyncHudMsg(players[i], g_msghelp, "You have been caught rushing when it is prohibted. say /voterush if you want to enable it.");
					// end play if carrier dies
					if (user_has_ball(players[i]))
					{
						play_over(2,0);
						// make player not glow
						set_rendering2(players[i],kRenderFxNone,0,0,0,kRenderTransAlpha,255);
					}
				}
			}
		}
		// check again
		set_task(1.6,"act_norush");
	}
}

// from admin slay by f117bomb
public act_explode(vec1[3])
{	// blast circles
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY,vec1)
	write_byte(21)
	write_coord(vec1[0])
	write_coord(vec1[1])
	write_coord(vec1[2] + 16)
	write_coord(vec1[0])
	write_coord(vec1[1])
	write_coord(vec1[2] + 1936)
	write_short(s2white)
	write_byte(0) 	// startframe
	write_byte(0) 	// framerate
	write_byte(2) 	// life
	write_byte(16) 	// width
	write_byte(0) 	// noise
	write_byte(188) // r
	write_byte(220) // g
	write_byte(255) // b
	write_byte(255) //brightness
	write_byte(0) 	// speed
	message_end();
	// Explosion2
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte(12)
	write_coord(vec1[0])
	write_coord(vec1[1])
	write_coord(vec1[2])
	write_byte(188) // byte (scale in 0.1's)
	write_byte(10) 	// byte (framerate)
	message_end();
	// s2smoke
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY,vec1)
	write_byte(5)
	write_coord(vec1[0])
	write_coord(vec1[1])
	write_coord(vec1[2])
	write_short(s2smoke)
	write_byte(2)
	write_byte(10)
	message_end();
}

// teame06's function
public set_rendering2(index,fx,r,g,b,render,amount)
{
	set_pev(index, pev_renderfx, fx);
	new Float:RenderColor[3];
	RenderColor[0] = float(r);
	RenderColor[1] = float(g);
	RenderColor[2] = float(b);
	set_pev(index, pev_rendercolor, RenderColor);
	set_pev(index, pev_rendermode, render);
	set_pev(index, pev_renderamt, float(amount));
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1033\\ f0\\ fs16 \n\\ par }
*/
