// Hob Goblin - Extra Nade Damage/Refill Nade

/* CVARS - copy and paste to shconfig.cfg

//Hob Goblin
goblin_level 0
goblin_grenademult 1.5		//Damage multiplyer from orginal damage amount
goblin_grenadetimer 10		//How many second delay for new grenade

*/

// v1.17 - JTP - Fixed giving new genades using more reliable event

#include <amxmod>
#include <superheromod>

// VARIABLES
new gHeroName[]="Hobgoblin"
new gHasGoblinPower[SH_MAXSLOTS+1]
#define AMMOX_HEGRENADE 12
//----------------------------------------------------------------------------------------------
public plugin_init()
{
	// Plugin Info
	register_plugin("SUPERHERO Hobgoblin","1.18","{HOJ} Batman/JTP10181")

	// DO NOT EDIT THIS FILE TO CHANGE CVARS, USE THE SHCONFIG.CFG
	register_cvar("goblin_level", "0")
	register_cvar("goblin_grenademult", "1.5")
	register_cvar("goblin_grenadetimer", "10")

	// FIRE THE EVENT TO CREATE THIS SUPERHERO!
	shCreateHero(gHeroName, "Hobgoblin Grenades", "Extra Nade Damage/Refill Nade", false, "goblin_level" )

	// REGISTER EVENTS THIS HERO WILL RESPOND TO! (AND SERVER COMMANDS)

	// INIT
	register_srvcmd("goblin_init", "goblin_init")
	shRegHeroInit(gHeroName, "goblin_init")

	//New Spawn
	register_event("ResetHUD","newRound","b")

	// EXTRA NADE DAMAGE
	register_event("Damage", "goblin_damage", "b", "2!0")

	//Find Thrown Grenades
	register_event( "AmmoX", "on_AmmoX", "b" )
}
//----------------------------------------------------------------------------------------------
public goblin_init()
{
	// First Argument is an id
	new temp[6]
	read_argv(1,temp,5)
	new id=str_to_num(temp)

	// 2nd Argument is 0 or 1 depending on whether the id has goblin
	read_argv(2,temp,5)
	new hasPowers=str_to_num(temp)
	gHasGoblinPower[id]=(hasPowers!=0)

	if ( gHasGoblinPower[id] ) {
		give_grenade(id)
	}
}
//----------------------------------------------------------------------------------------------
public newRound(id)
{
	if ( shModActive() && gHasGoblinPower[id] && is_user_alive(id) ) {
		set_task(0.1,"give_grenade",id)
	}
}
//----------------------------------------------------------------------------------------------
public give_grenade(id)
{
	if ( shModActive() && gHasGoblinPower[id] && is_user_alive(id) ) {
		shGiveWeapon(id, "weapon_hegrenade" )
	}
}
//----------------------------------------------------------------------------------------------
public goblin_damage(id)
{
	if (!shModActive() || !is_user_alive(id)) return PLUGIN_CONTINUE

	new damage = read_data(2)
	new weapon, bodypart, attacker = get_user_attacker(id,weapon,bodypart)

	if ( attacker <=0 || attacker > SH_MAXSLOTS ) return PLUGIN_CONTINUE

	if ( gHasGoblinPower[attacker] && weapon == CSW_HEGRENADE && is_user_alive(id) ) {
		// do extra damage
		new extraDamage = floatround(damage * get_cvar_float("goblin_grenademult") - damage)
		if (extraDamage > 0) shExtraDamage( id, attacker, extraDamage, "grenade" )
	}
	return PLUGIN_CONTINUE
}
//----------------------------------------------------------------------------------------------
public on_AmmoX(id)
{
	if ( !shModActive() ) return
	if ( id <= 0 || id > SH_MAXSLOTS) return
	if ( !is_user_alive(id) || !is_user_connected(id) ) return

	new iAmmoType = read_data(1)
	new iAmmoCount = read_data(2)

	if ( iAmmoType == AMMOX_HEGRENADE && gHasGoblinPower[id]) {
		if (iAmmoCount == 0) {
			set_task( get_cvar_float("goblin_grenadetimer"), "give_grenade", id )
		}
		else if (iAmmoCount > 0 && task_exists(id)) {
			remove_task(id)
		}
	}
}

//----------------------------------------------------------------------------------------------
public client_connect(id)
{
	gHasGoblinPower[id] = false
}
//----------------------------------------------------------------------------------------------