// HULK!

/* CVARS - copy and paste to shconfig.cfg

//Hulk
hulk_level 0
hulk_radius 1800			//Radius of people affected
hulk_cooldown 7			//# of seconds before Hulk can ReStun
hulk_stuntime 3			//# of seconds Hulk Stuns Everybody
hulk_stunspeed 70			//Speed of stunned players

*/

#include <amxmod>
#include <Vexd_Utilities>
#include <superheromod>

// GLOBAL VARIABLES
new gHeroName[]="Hulk"
new bool:gHasHulkPower[SH_MAXSLOTS+1]
#define gHulkSoundCount 3
new gStompSound[gHulkSoundCount][] = {
	"debris/bustconcrete1.wav",
	"debris/bustcrate1.wav",
	"debris/bustcrate3.wav"
}
//----------------------------------------------------------------------------------------------
public plugin_init()
{
	// Plugin Info
	register_plugin("SUPERHERO Hulk","1.18","{HOJ} Batman")

	// DO NOT EDIT THIS FILE TO CHANGE CVARS, USE THE SHCONFIG.CFG
	register_cvar("hulk_level", "0" )
	register_cvar("hulk_radius", "1800" )
	register_cvar("hulk_cooldown", "7" )
	register_cvar("hulk_stuntime", "3" )
	register_cvar("hulk_stunspeed", "70" )

	// FIRE THE EVENT TO CREATE THIS SUPERHERO!
	shCreateHero(gHeroName, "Power Stomp", "Immobilizes Self and Nearby Enemies", true, "hulk_level" )

	// REGISTER EVENTS THIS HERO WILL RESPOND TO! (AND SERVER COMMANDS)
	register_event("ResetHUD","newRound","b")

	// KEY DOWN
	register_srvcmd("hulk_kd", "hulk_kd")
	shRegKeyDown(gHeroName, "hulk_kd")

	// INIT
	register_srvcmd("hulk_init", "hulk_init")
	shRegHeroInit(gHeroName, "hulk_init")

}
//----------------------------------------------------------------------------------------------
public plugin_precache()
{
	// TBD - SOUNDS!
	for (new x = 0; x < gHulkSoundCount; x++) {
		precache_sound(gStompSound[x])
	}
}
//----------------------------------------------------------------------------------------------
public hulk_init()
{
	// First Argument is an id
	new temp[6]
	read_argv(1,temp,5)
	new id=str_to_num(temp)

	// 2nd Argument is 0 or 1 depending on whether the id has iron man powers
	read_argv(2,temp,5)
	new hasPowers=str_to_num(temp)

	gHasHulkPower[id] = (hasPowers != 0)

}
//----------------------------------------------------------------------------------------------
public newRound(id)
{
	gPlayerUltimateUsed[id]=false
}
//----------------------------------------------------------------------------------------------
// RESPOND TO KEYDOWN
public hulk_kd()
{
	if ( !hasRoundStarted() ) return PLUGIN_HANDLED

	new Float:velocity[3]

	// First Argument is an id with Hulk Powers!
	new temp[6]
	read_argv(1,temp,5)
	new id=str_to_num(temp)

	if ( !is_user_alive(id) || !gHasHulkPower[id]) return PLUGIN_HANDLED

	Entvars_Get_Vector(id, EV_VEC_velocity, velocity)

	// Hulk should technically be standing still to do this...  (i.e. no jump or air)
	// Let them know they already used their ultimate if they have
	if ( velocity[2] < -10.0 || velocity[2] > 10.0 || gPlayerUltimateUsed[id]) {
		playSoundDenySelect(id)
		return PLUGIN_HANDLED
	}

	new hulkRadius = get_cvar_num("hulk_radius")
	new Float:hulkCooldown = get_cvar_float("hulk_cooldown")
	new hulkStunTime = get_cvar_num("hulk_stuntime")
	new Float:hulkStunSpeed = get_cvar_float("hulk_stunspeed")

	// OK Power stomp enemies closer than x distance
	new userOrigin[3]
	new victimOrigin[3]
	new distanceBetween

	ultimateTimer(id, hulkCooldown)
	get_user_origin(id,userOrigin)

	for ( new x = 1; x <= SH_MAXSLOTS; x++) {
		if ( (is_user_alive(x) && get_user_team(id) != get_user_team(x)) || x == id ) {
			get_user_origin(x,victimOrigin)
			distanceBetween = get_distance(userOrigin, victimOrigin )
			if ( distanceBetween < hulkRadius ) {
				sh_screenShake(x, 14, 14, 14 )
				shStun(x, hulkStunTime)
				set_user_maxspeed(x, hulkStunSpeed)
			}
		}
	}

	// Dependint on the hulkStunTime - Set some Stomp Sounds
	new count = 0
	for (new x = 0; x < 2 * hulkStunTime; x++) {
		new parm[2]
		parm[0] = id
		parm[1] = count++
		if ( count >= gHulkSoundCount) count = 0
		set_task( (x * 1.0) / 2.0, "stompSound", 0, parm, 2)
	}
	return PLUGIN_HANDLED
}
//----------------------------------------------------------------------------------------------
public playSound( id, soundNbr )
{
	emit_sound(id, CHAN_STATIC, gStompSound[soundNbr], 1.0, ATTN_NORM, 0, PITCH_HIGH)
}
//----------------------------------------------------------------------------------------------
public stompSound(parm[2])
{
	playSound( parm[0], parm[1] )
}
//----------------------------------------------------------------------------------------------
public client_connect(id)
{
	gHasHulkPower[id] = false
}
//----------------------------------------------------------------------------------------------