// MYSTIQUE! - BASED ON Vexds model changer

/* CVARS - copy and paste to shconfig.cfg

//Mystique
mystique_level 0
mystique_cooldown 0				//Cooldown time between morphs
mystique_maxtime 0				//Max time you can be morphed
mystique_toggle 1				//Should the key be a toggle or do they need to hold it down

*/

#include <amxmod>
#include <Vexd_Utilities>
#include <superheromod>

// GLOBAL VARIABLES
new gHeroName[]="Mystique"
new bool:gMorphed[SH_MAXSLOTS+1]
new gMystiqueSound[]="ambience/disgusting.wav"
new CTSkins[4][10]={"sas","gsg9","urban","gign"}
new TSkins[4][10]={"arctic","leet","guerilla","terror"}
//----------------------------------------------------------------------------------------------
public plugin_init()
{
	// Plugin Info
	register_plugin("SUPERHERO Mystique","1.18","{HOJ} Batman")

	// DO NOT EDIT THIS FILE TO CHANGE CVARS, USE THE SHCONFIG.CFG
	register_cvar("mystique_level", "0" )
	register_cvar("mystique_cooldown", "0")
	register_cvar("mystique_maxtime",  "0" )
	register_cvar("mystique_toggle",  "1" )

	// FIRE THE EVENT TO CREATE THIS SUPERHERO!
	shCreateHero(gHeroName, "Morph into Enemy", "Hold Down a Power Key to Look Like the Enemy - Release the Key to Look Like Yourself!", true, "mystique_level" )

	// REGISTER EVENTS THIS HERO WILL RESPOND TO! (AND SERVER COMMANDS)

	// KEY UP
	register_srvcmd("mystique_ku", "mystique_ku")
	shRegKeyUp(gHeroName, "mystique_ku")

	// KEY DOWN
	register_srvcmd("mystique_kd", "mystique_kd")
	shRegKeyDown(gHeroName, "mystique_kd")

	// DEATH
	register_event("DeathMsg", "mystique_death", "a")

	// INIT
	register_srvcmd("mystique_init", "mystique_init")
	shRegHeroInit(gHeroName, "mystique_init")

}
//----------------------------------------------------------------------------------------------
public plugin_precache()
{
	precache_sound(gMystiqueSound)
}
//----------------------------------------------------------------------------------------------
public mystique_init()
{
	// First Argument is an id
	new temp[6]
	read_argv(1,temp,5)
	new id = str_to_num(temp)

	// 2nd Argument is 0 or 1 depending on whether the id has mystique man powers
	read_argv(2,temp,5)
	new hasPowers = str_to_num(temp)

	if ( !hasPowers && gMorphed[id] && is_user_connected(id) ) mystique_unmorph(id)

}
//----------------------------------------------------------------------------------------------
public mystique_sound(id)
{
	new SND_STOP=(1<<5)
	emit_sound(id, CHAN_AUTO, gMystiqueSound, 0.2, ATTN_NORM, SND_STOP , PITCH_NORM)
	emit_sound(id, CHAN_AUTO, gMystiqueSound, 0.2, ATTN_NORM, 0, PITCH_NORM)
}
//----------------------------------------------------------------------------------------------
public mystique_morph(id)
{
	new newSkin[32]

	if ( !is_user_alive(id) || gMorphed[id] ) return

	new num = random_num(0,3)

	if ( get_user_team(id) == 1 ) {
		copy(newSkin,31,CTSkins[num])
	}
	else {
		copy(newSkin,31,TSkins[num])
	}

	#if defined AMXX_VERSION
	cs_set_user_model(id, newSkin)
	#else
	CS_SetModel(id, newSkin)
	#endif

	gMorphed[id] = true
	mystique_sound(id)

	// Message
	set_hudmessage(200, 200, 0, -1.0, 0.45, 2, 0.02, 4.0, 0.01, 0.1, 86)
	show_hudmessage(id, "Mystique - YOU NOW LOOK LIKE THE ENEMY")
}
//----------------------------------------------------------------------------------------------
public mystique_unmorph(id)
{
	if ( gMorphed[id] )
	{
		set_hudmessage(200, 200, 0, -1.0, 0.45, 2, 0.02, 4.0, 0.01, 0.1, 86)
		show_hudmessage(id,"Mystique - RETURNED TO SELF")
		remove_task(id)

		#if defined AMXX_VERSION
		cs_reset_user_model(id)
		#else
		CS_ClearModel(id)
		#endif

		gMorphed[id] = false
		mystique_sound(id)
	}
}
//----------------------------------------------------------------------------------------------
// RESPOND TO KEYDOWN
public mystique_kd()
{
	// First Argument is an id with Mystique Powers!
	new temp[6]
	read_argv(1,temp,5)
	new id=str_to_num(temp)

	// If in toggle mode change this to a keyup event
	if ( get_cvar_num("mystique_toggle") && gMorphed[id] ) {
		mystique_unmorph(id)
		return PLUGIN_HANDLED
	}

	if ( !is_user_alive(id) ) return PLUGIN_HANDLED

	// Let them know they already used their ultimate if they have
	if ( gPlayerUltimateUsed[id] ) {
		playSoundDenySelect(id)
		return PLUGIN_HANDLED
	}

	new mystiqueCooldown=get_cvar_num("mystique_cooldown")
	if ( mystiqueCooldown > 0 )ultimateTimer(id, mystiqueCooldown * 1.0 )

	mystique_morph(id)

	new Float:mystiqueMaxTime = get_cvar_float("mystique_maxtime")
	if (mystiqueMaxTime > 0.0) {
		set_task(mystiqueMaxTime,"forceUnmorph", id)
	}

	return PLUGIN_HANDLED
}
//----------------------------------------------------------------------------------------------
public mystique_death()
{
	new id = read_data(2)
	mystique_unmorph(id)
}
//----------------------------------------------------------------------------------------------
public forceUnmorph(id)
{
	client_print(id, print_chat, "[SH](Mystique) Your morph power has worn off")
	mystique_unmorph(id)
}
//----------------------------------------------------------------------------------------------
// RESPOND TO KEYUP
public mystique_ku()
{
	// toggle mode - keyup doesn't do anything!
	if ( get_cvar_num("mystique_toggle") ) return

	// First Argument is an id with Mystique Powers!
	new temp[6]
	read_argv(1,temp,5)
	new id = str_to_num(temp)

	mystique_unmorph(id)
}
//----------------------------------------------------------------------------------------------
public client_connect(id)
{
	gMorphed[id] = false
}
//----------------------------------------------------------------------------------------------