// SKELETOR!
// REQUIRES Monster Mod (Botman version 3.00.00)
// Created 5/17/2003

/* CVARS - copy and paste to shconfig.cfg

//Skeletor
skeletor_level 0
skeletor_cooldown 20			// # of seconds for skeletor cooldown
skeletor_camptime 10			// # of seconds player considered camping w/o x/y movement
skeletor_movedist 10			// minimum amount of dist player has to move b4 considered not camping

*/

#include <amxmod>
#include <superheromod>

// VARIABLES
new gHeroName[]="Skeletor"
new bool:gHasSkeletorPowers[SH_MAXSLOTS+1]={false}
new gPlayerPosition[SH_MAXSLOTS+1][3]  // keeps track of last known origin
new gMoveTimer[SH_MAXSLOTS+1]          // incremented if player didn't move far enough
new gPlayerLevels[SH_MAXSLOTS+1]
//----------------------------------------------------------------------------------------------
public plugin_init()
{
	// Plugin Info
	register_plugin("SUPERHERO Skeletor","1.18","{HOJ} Batman")

	// DO NOT EDIT THIS FILE TO CHANGE CVARS, USE THE SHCONFIG.CFG
	register_cvar("skeletor_level", "0" )
	register_cvar("skeletor_cooldown", "20" )
	register_cvar("skeletor_camptime", "10" )
	register_cvar("skeletor_movedist", "10" )

	// FIRE THE EVENT TO CREATE THIS SUPERHERO!
	shCreateHero(gHeroName, "Summon Monsters", "Will Automatically Summon Monsters To Attack Enemy Campers", false, "skeletor_level" )

	// REGISTER EVENTS THIS HERO WILL RESPOND TO! (AND SERVER COMMANDS)

	// INIT
	register_event("ResetHUD","skeletor_newround","b")
	register_srvcmd("skeletor_init", "skeletor_init")
	shRegHeroInit(gHeroName, "skeletor_init")

	// LEVELS
	register_srvcmd("skeletor_levels", "skeletor_levels")
	shRegLevels(gHeroName,"skeletor_levels")

	set_task(1.0,"skeletor_campcheck",0,"",0,"b" )

}
//----------------------------------------------------------------------------------------------
public skeletor_newround(id)
{
	gMoveTimer[id] = 0
	gPlayerUltimateUsed[id] = false

	if ( is_user_alive(id) ) {
		get_user_origin(id, gPlayerPosition[id])
	}
}
//----------------------------------------------------------------------------------------------
public plugin_precache()
{
	precache_sound("ambience/port_suckin1.wav")
}
//----------------------------------------------------------------------------------------------
public skeletor_init()
{
	// First Argument is an id
	new temp[6]
	read_argv(1,temp,5)
	new id=str_to_num(temp)

	// 2nd Argument is 0 or 1 depending on whether the id has wolverine skills
	read_argv(2,temp,5)
	new hasPowers = str_to_num(temp)

	gHasSkeletorPowers[id] = (hasPowers!=0)
}
//----------------------------------------------------------------------------------------------
public skeletor_levels()
{
	new id[5]
	new lev[5]

	read_argv(1,id,4)
	read_argv(2,lev,4)

	gPlayerLevels[str_to_num(id)] = str_to_num(lev)
}
//----------------------------------------------------------------------------------------------
public skeletor_campcheck()
{
	if ( !shModActive() || !hasRoundStarted() ) return

	// Check all players to see if they've moved...
	new origin[3]
	new dx,dy,dz

	for ( new i = 1; i <= SH_MAXSLOTS; i++ ) {
		if ( is_user_alive(i) ) {
			get_user_origin(i,origin)
			dx = gPlayerPosition[i][0] - origin[0]
			dy = gPlayerPosition[i][1] - origin[1]
			dz = gPlayerPosition[i][2] - origin[2]
			new d = sqrt( dx*dx + dy*dy + dz*dz )
			if ( d<=get_cvar_num("skeletor_movedist") ) {
				gMoveTimer[i]++
				if ( gMoveTimer[i]>get_cvar_num("skeletor_camptime") ) {
					gMoveTimer[i]=0
					skeletor_summon(i)
				}
			}
			else {
				gMoveTimer[i] = 0
			}
			gPlayerPosition[i][0] = origin[0]
			gPlayerPosition[i][1] = origin[1]
			gPlayerPosition[i][2] = origin[2]
		}
	}
}
//----------------------------------------------------------------------------------------------
public skeletor_summon(id)
{
	// Go through a list of skeletor looking for
	// 1) ultimate available
	// 2) opposite team than (id)
	// 3) skeletor powers...
	for ( new i = 1; i <= SH_MAXSLOTS; i++ ) {
		if ( is_user_alive(i) && gHasSkeletorPowers[i] && get_user_team(i)!=get_user_team(id) && !gPlayerUltimateUsed[i] ) {
			// COOL WE HAVE A SKELETOR TO STICK SNARKS ON Player id!
			ultimateTimer(i, get_cvar_num("skeletor_cooldown") * 1.0)
			// SUMMON THE MONSTERS USING MONSTOR MOD
			new name[32]
			new enemyName[32]
			get_user_name(id,enemyName,31)
			get_user_name(i,name,31)
			client_print(0,3,"%s using Skeletor Powers Against Camper %s", name, enemyName )
			emit_sound(id, CHAN_STATIC, "ambience/port_suckin1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
			emit_sound(i, CHAN_STATIC, "ambience/port_suckin1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)

			// The Higher the Level - The more Snarks!
			//server_print("LEVEL OF %s=%d", name, gPlayerLevels[i] )
			for ( new m = 1; m <= gPlayerLevels[i] / 2 + 1; m++ ) {
				set_task(m * 0.2,"summon_monster", id)
			}
			break //ok no more poeple need to syc this guy
		}
	}
}
//----------------------------------------------------------------------------------------------
public summon_monster(id)
{
	if (is_user_alive(id)) {
		server_cmd("monster snark #%i", id)
	}
}
//----------------------------------------------------------------------------------------------