/*
===============================================================================
Steam ID password association plugin - Version 1.00  // change const VERSION[]
===============================================================================
As requested http://amxmodx.org/forums/viewtopic.php?t=15723
For use as "a login function as in psychostats"

--------
Features
--------
-Associate a Steam ID with user defined password

------------
Requirements
------------
-mySQL

--------------
Main Functions
--------------
    sh_password <username> <pass>      Register a password to a Steam ID
                            if already defined in DB, new <pass> overwrites old one

'''''''''''''''
Admin Functions
'''''''''''''''
    sh_add <steamID> <username> <pass> Register a password to a Steam ID
                            if already defined in DB, new <pass> overwrites old one
    sh_del "<steamID>"        Unregister user via steam ID

-----
cvars
-----
None

---------
Changelog
---------
v 1.00    First release

*/

#include <amxmodx>
#include <amxmisc>
#include <dbi>

#define REG_ACCESS ADMIN_ALL
#define ADMIN ADMIN_KICK

// program details
new const PLUGIN_NAME[] = "SteamID password association"
new const AUTHOR[] = "ShadowLeader"
new const VERSION[] = "1.00"

//////////////////
// mysql vars - 1
new bool:SQL_CONNECTED = false

// mysql table names
new const USER_TABLE[] = "users"

new Sql:sql
new Result:result

// mysql vars - 0
//////////////////

/*#############################################################################
    INITIALISE FUNCTIONS - 1
#############################################################################*/

public plugin_init()
{
	register_plugin(PLUGIN_NAME, VERSION, AUTHOR)
	register_concmd("sh_password","consoleRegister",REG_ACCESS," <username> <password> - Register a username and password to your Steam ID")

	// admin fucntions
	register_concmd("sh_add","consoleAdminRegister",ADMIN," ^"<SteamID>^" ^"<username>^" ^"<pass>^" - Register a password to a Steam ID")
	register_concmd("sh_del","consoleAdminUnregister",ADMIN," ^"<Steam ID>^" - Remove a Steam ID from the database")
}

public plugin_cfg()
{
	sqlInit()
}

// checks for required modules
public plugin_modules()
{
    require_module("DBI")
}

public sqlInit()
{
    new host[64],user[32],pass[32],db[32],error[128]
    get_cvar_string("sh_mysql_host",host,63)
    get_cvar_string("sh_mysql_user",user,31)
    get_cvar_string("sh_mysql_pass",pass,31)
    get_cvar_string("sh_mysql_db",db,31)

    sql = dbi_connect(host,user,pass,db,error,127)
    if (sql <= SQL_FAILED)
    {
        server_print("ERROR. Failed to connect to mySQL. Plugin ending")
    }
    else
    {
        server_print("Connection to mySQL: Successful")
        SQL_CONNECTED = true
    }
    return PLUGIN_HANDLED
}

/*#############################################################################
    INITIALISE FUNCTIONS - 0
    CONSOLE FUNCTIONS - 1
#############################################################################*/


/*-----------------------------------------------------------------------------
admin registering
-----------------------------------------------------------------------------*/
public consoleAdminRegister(id,level,cid)
{
    new steamID[32], username[32], pass[35]
    if (!cmd_access(id, level, cid, 3))
        return PLUGIN_HANDLED
    read_argv(1, steamID, 31)
    read_argv(2, username, 31)
    read_argv(3, pass, 34)
    if(!validPassMsg(id, pass))
        return PLUGIN_HANDLED
    if(validSteamID(steamID) == -1)
        updateUser(id, steamID, username, pass)
    else
    {
        if(!validSteamIDMsg(id, steamID))
            return PLUGIN_HANDLED
        registerUser(id, steamID, username, pass)
    }
    return PLUGIN_HANDLED
}

/*-----------------------------------------------------------------------------
admin unregistering a name
-----------------------------------------------------------------------------*/
public consoleAdminUnregister(id,level,cid)
{
    if (!cmd_access(id, level, cid, 2))
        return PLUGIN_HANDLED
    new steamID[32]
    read_argv(1, steamID, 31)
    if(validSteamID(steamID) >= -1)
        unregisterUser(id, steamID)
    return PLUGIN_HANDLED
}

/*-----------------------------------------------------------------------------
register a name
    syntax:        reg <name> <password>
-------------------------------------------------------------------------------
checks database for clash with name
    if clash fail registration and tell user
-------------------------------------------------------------------------------

input
    syntax:        reg <name> <password>
output
    sets user name and password to that registered
    if registerLogin is set
        logs user in after registration
    else
        requires manual login
-----------------------------------------------------------------------------*/
public consoleRegister(id,level,cid)
{
    new steamID[32], username[32], pass[35]
    if (!SQLconnected())
        return PLUGIN_HANDLED

    if (!cmd_access(id, level, cid, 2))
        return PLUGIN_HANDLED
    get_user_authid(id, steamID, 31)

    read_argv(1, username, 31)
    read_argv(2, pass, 34)
    if(!validPassMsg(id, pass))
        return PLUGIN_HANDLED
    if(validSteamID(steamID) == -1)
        updateUser(id, steamID, username, pass)
    else
        registerUser(id, steamID, username, pass)
    return PLUGIN_HANDLED
}

/*#############################################################################
    CONSOLE FUNCTIONS - 0
    AUTO CALLED FUNCTIONS - 1
#############################################################################*/

/*#############################################################################
    AUTO CALLED FUNCTIONS - 0
    MISC FUNCTIONS - 1
#############################################################################*/



/*-----------------------------------------------------------------------------
unregister a name
    assume perfect input
-------------------------------------------------------------------------------
does actual deletion from database
-----------------------------------------------------------------------------*/
public unregisterUser(id, steamID[])
{
    result = dbi_query(sql,"select * from %s where steamid = '%s'",USER_TABLE, steamID)
    if(result == RESULT_FAILED)
    {
        console_print(id, "ERROR. Cannot delete name from database. Please contact admin")
    }
    else if(result == RESULT_NONE)
    {
        console_print(id, "ERROR. Steam ID(%s) does not exist in database.", steamID)
    }
    else
    {
        dbi_query(sql,"delete from %s where steamid = '%s'",USER_TABLE, steamID)
        console_print(id, "Steam ID (%s) succesfully unregistered", steamID)
        dbi_free_result(result)
        return true
    }
    dbi_free_result(result)
    return false
}


/*-----------------------------------------------------------------------------
register a name
    assume perfect input
-------------------------------------------------------------------------------
does actual registration into database
-----------------------------------------------------------------------------*/
public registerUser(id, steamID[], username[], pass[])
{
	new sqlcmd[256],error[128]
	format(sqlcmd,255,"INSERT INTO %s (steamid, username, passhash, status) values ('%s','%s',MD5('%s'),'confirmed')",USER_TABLE, steamID, username, pass)
	result = dbi_query(sql,sqlcmd)
	if(result == RESULT_FAILED)
	{
		console_print(id, "ERROR. Cannot register into database. Please contact admin")

		dbi_error(sql,error,127)
		log_amx("Error Registering For %s: '%s' - '%s'", steamID, sqlcmd, error)
		return false
	}

	console_print(id, "Succesfully registered Steam ID(%s) with username: %s and password (%s)", steamID, username, pass)
	dbi_free_result(result)
	return true
}

/*-----------------------------------------------------------------------------
updates user details
    assume perfect input
-------------------------------------------------------------------------------
does actual update into database
-----------------------------------------------------------------------------*/
public updateUser(id, steamID[], username[], pass[])
{
    result = dbi_query(sql,"UPDATE %s set username = '%s', passhash = MD5('%s') where steamid = '%s'",USER_TABLE, username, pass, steamID)
    if(result == RESULT_FAILED)
    {
        console_print(id, "ERROR. Cannot update database. Please contact admin")
    }
    else
    {
        console_print(id, "Succesfully update Steam ID(%s) with username: %s and password (%s)", steamID, username, pass)
        dbi_free_result(result)
        return true
    }
    return false
}


/*-----------------------------------------------------------------------------
validates password
-------------------------------------------------------------------------------
    returns
        false  invalid
        true   valid
-----------------------------------------------------------------------------*/
public validPass(pass[])
{
    trim(pass)
    if((containi (pass, "^"") >= 0) || (containi (pass, "^'") >= 0) )
        return false
    return true
}

public validPassMsg(id, pass[])
{
    if(validPass(pass))
        return true
    console_print(id, "ERROR. Password invalid. Invalid characters: ^", ^'")
    return false
}

/*-----------------------------------------------------------------------------
validates steam id
-------------------------------------------------------------------------------
checks for
    invalid format
    clash with
        registered names
-------------------------------------------------------------------------------
output
    returns
        -10 parse error ie " / ' inside
        -1  clash with registered id
         1  valid
-----------------------------------------------------------------------------*/
public validSteamID(steamID[])
{
    // check blocked names table
    trim(steamID)
    if((containi (steamID, "^"") >= 0) || (containi (steamID, "^'") >= 0) )
    {
        return -10
    }

    // check user table
    result = dbi_query(sql,"SELECT * FROM %s WHERE steamid like '%s'", USER_TABLE, steamID)
    if(result >= RESULT_OK)
    {
        dbi_free_result(result)
        return -1
    }
    return 1
}

public validSteamIDMsg(id, steamID[])
{
    switch(validSteamID(steamID))
    {
        case 1:
            return true
        case -1:
            console_print(id, "ERROR. SteamID already registered")
        case -10:
            console_print(id, "ERROR. Name invalid. Invalid characters: ^", ^'")
        default:
            console_print(id, "ERROR. Invalid name")
    }
    return false
}

/*-----------------------------------------------------------------------------
checks if currently connected to the database
-------------------------------------------------------------------------------
output
    returns
        true    connected
        false    not connected
-----------------------------------------------------------------------------*/
public SQLconnected()
{
    if (SQL_CONNECTED)
        return true
    console_print(0, "ERROR. Cannot connect to database. Please contact admin")
    server_print("ERROR. Cannot connect to database")
    return false
}

