#include <amxmodx>
#include <kz>

new kz_enabled;
new kz_autojoin;

public plugin_init()
{
	register_plugin("KZ Misc", KZ_VERSION, "teame06");

	// Pointer Cvars
	kz_enabled = get_cvar_pointer("kz_enabled");
	kz_autojoin = get_cvar_pointer("kz_autojoin");

	// Auto Join
	register_event("ShowMenu", "menuclass", "b", "4&CT_Select", "4&Terrorist_Select");
	register_event("ShowMenu", "menuteam", "b", "4&Team_Select_Spect", "4&Team_Select", "4&IG_Team_Select");
}

public menuteam(id)
{
	if(get_pcvar_num(kz_enabled) && get_pcvar_num(kz_autojoin))
		client_cmd(id, "slot2");
}

public menuclass(id)
{
	if(get_pcvar_num(kz_enabled) && get_pcvar_num(kz_autojoin))
		client_cmd(id, "slot5");
}

public client_connect(id)
{
	if(get_pcvar_num(kz_enabled) && get_pcvar_num(kz_autojoin))
		set_user_info(id, "_vgui_menus", "0");
}

public kz_Init(_state)
{
	if(!_state)
	{
		pause("a");
		return;
	}

	if(!get_pcvar_num(kz_enabled))
		return;

	// Block commands
	register_clcmd("jointeam 1", "cmdBlock");
	register_clcmd("chooseteam", "cmdBlock");
	register_clcmd("buy", "cmdBlock");
	register_clcmd("buyammo1", "cmdBlock");
	register_clcmd("buyammo2", "cmdBlock");
	register_clcmd("buyequip", "cmdBlock");
	register_clcmd("cl_autobuy", "cmdBlock");
	register_clcmd("cl_rebuy", "cmdBlock");
	register_clcmd("cl_setautobuy", "cmdBlock");
	register_clcmd("cl_setrebuy", "cmdBlock");
	register_clcmd("fullupdate", "cmdBlock");
	register_clcmd("radio1", "cmdBlock");
	register_clcmd("radio2", "cmdBlock");
	register_clcmd("radio3", "cmdBlock");

	find_entity_for_removal();
	create_trigger_hurt();
}

find_entity_for_removal()
{
	#define CLASSNAME_REMOVAL 6
	new classname[CLASSNAME_REMOVAL][] =
	{
		"armoury_entity",
		"game_player_equip",
		"player_weaponstrip",
		"info_deathmatch_start", // Make sure there no T's spawn on the map.
		"func_healthcharger",

		// Trigger hurt might need a secondary check to make sure it only remove trigger_hurt with healing
		"trigger_hurt" // Remove maps trigger_hurt and replace with my own.
	};

	new i;
	while(i < CLASSNAME_REMOVAL)
	{
		remove_all_entity(classname[i], "classname", 0, "");
		i++;
	}

	remove_all_entity("healbutton", "targetname", 0, "");

	// Remove triggers for 10,000 health. (Maybe maps with really deep jumps need it)
	remove_all_entity("func_door", "classname", pev_targetname, "healingdoor");
	remove_all_entity("func_button", "classname", pev_target, "healingdoor");
	remove_all_entity("trigger_multiple", "classname", pev_target, "healingdoor");
}

remove_all_entity(classname[], type[], _pev, _targetname[])
{
	new ent = engfunc(EngFunc_FindEntityByString, -1, type, classname);
	new targetname[32];

	while(ent > 0)
	{
		if(_targetname[0])
		{
			pev(ent, _pev, targetname, 31);
			if(containi(targetname, _targetname) != -1)
			{
				engfunc(EngFunc_RemoveEntity, ent);
			}
		}
		else
		{
			if(equal(classname, "trigger_hurt")) // Only remove trigger_hurt that heals
			{
				new dmg[12];
				pev(ent, pev_dmg, dmg, 11);

				new dmg_num = str_to_num(dmg);

				if(dmg_num > 0)
					engfunc(EngFunc_RemoveEntity, ent);
			}
			else
			{
				engfunc(EngFunc_RemoveEntity, ent);
			}
		}
		ent = engfunc(EngFunc_FindEntityByString, ent, type, classname);
	}
}

// Create a trigger_Hurt the maximum size of a map.
create_trigger_hurt()
{
	new ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "trigger_hurt"));

	if(ent > 0)
	{
		set_keyvalue(ent, "classname", "trigger_hurt");
		set_keyvalue(ent, "damagetype", "1024");
		set_keyvalue(ent, "dmg", "-15"); // Set it to heal rather than damage
		set_keyvalue(ent, "origin", "0 0 0");

		dllfunc(DLLFunc_Spawn, ent);

		new Float:ent_min[3] = { -4096.0, -4096.0, -4096.0 };
		new Float:ent_max[3] = { 4096.0, 4096.0, 4096.0 };

		set_pev(ent, pev_mins, ent_min);
		set_pev(ent, pev_maxs, ent_max);

		engfunc(EngFunc_SetSize, ent, ent_min, ent_max);
		set_pev(ent, pev_origin, {0.0, 0.0, 0.0});
		set_pev(ent, pev_solid, SOLID_TRIGGER);

		return ent;
	}
	return 0;
}

public PostSpawn(id)
{
	if(!get_pcvar_num(kz_enabled))
		return;

	if(!IsPlayerValid(id))
		return;

	if(!user_has_weapon(id, CSW_SCOUT))
		_fm_give_item(id, "weapon_scout");

	if(!user_has_weapon(id, CSW_USP))
		_fm_give_item(id, "weapon_usp");

	cs_set_user_bpammo(id, CSW_USP, 24); // Sets usp ammo to 24
	cs_set_user_bpammo(id, CSW_SCOUT, 30); // Sets scout ammo to 30

	if(!user_has_weapon(id, CSW_C4))
		_fm_give_item(id, "weapon_c4");

	#if defined a
	if(!IsPlayerStarted(id))
	{
		_fm_give_item(id, "item_longjump"); // Fun item when they are not started.
		set_pev(id, pev_takedamage, 0.0);
	}
	#endif

	cs_set_user_armor(id, 100, CS_ARMOR_VESTHELM); // Set Helm and Armor to 100

	if(!cs_get_user_nvg(id))
		cs_set_user_nvg(id); // Set Night Vision

	set_pev(id, pev_health, 255.0);
	set_pev(id, pev_max_health, 255.0); // Set Max Health to 255 for trigger_hurt to heal up to.
}

public cmdBlock(id)
{
	if(get_pcvar_num(kz_enabled))
		return PLUGIN_HANDLED;

	return PLUGIN_CONTINUE;
}
