/* Plugin generated by AMXX-Studio */

#include <amxmodx>
#include <amxmisc>
#include <fun> 
#include <cstrike> 
#include <fakemeta>


#define PLUGIN "Zombie Me"
#define VERSION "3.0"
#define AUTHOR "Purple Nurple"

////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////Plugin by Jesse Tripp (C) copy-write 2008//////////////////////////////////							  
//////////////////////////////email: jdmotor@sbcglobal.net//////////////////////////////////////////								  
////////////////////////////////////////////////////////////////////////////////////////////////////
enum ROUNDSTATUS {
	RS_END,
	RS_RUNNING,
	RS_UNDEFINED
}
new ROUNDSTATUS:roundstatus = RS_UNDEFINED


#define ZOMBIE_PAIN 2
new pain_zombie[ZOMBIE_PAIN][] = {"zombie/zo_pain1.wav", "zombie/zo_pain2.wav" }

#define ZOMBIE_IDLE 7
new idle_zombie[ZOMBIE_IDLE][] = {
	"zombie/zo_alert10.wav", 
	"zombie/zo_alert20.wav",
	"zombie/zo_alert30.wav",
	"zombie/zo_idle1.wav",
	"zombie/zo_idle2.wav",
	"zombie/zo_idle3.wav", 
	"zombie/zo_idle4.wav"
}

#define ZOMBIE_MISS 2
new miss_zombie[ZOMBIE_MISS][] = {"zombie/claw_miss1.wav", "zombie/claw_miss2.wav" }

#define ZOMBIE_HIT 3
new hit_zombie[ZOMBIE_HIT][] = {"zombie/claw_strike1.wav", "zombie/claw_strike2.wav","zombie/claw_strike3.wav" }

#define ZOMBIE_DEATH 2
new death_zombie[ZOMBIE_DEATH][] = {"aslave/slv_die1.wav","aslave/slv_die2.wav" }

new nightvision[33]
new bool:zombie[33]
new bool:g_speed

new z_cost, z_health, z_armor, z_speed, z_gravity, z_buyable, z_glow, z_arena, z_adminonly, z_damage,z_sounds
#define MAX_PLAYERS 32
new bool:g_restart_attempt[MAX_PLAYERS + 1]

public plugin_init() {
	register_plugin(PLUGIN, VERSION, AUTHOR)
	////COMMANDS
	register_clcmd("say zombieme", "buy_zombie", 0, "Transforms you into a zombie.")
	register_clcmd("say /zombieme","buy_zombie",0, "Transforms you into a zombie.")
	register_clcmd("say /zombie","buy_zombie",0, "Transforms you into a zombie.")
	register_clcmd("say_team zombieme","buy_zombie",0, "Transforms you into a zombie.")
	register_clcmd("say_team /zombieme","buy_zombie",0, "Transforms you into a zombie.")
	register_clcmd("say_team /zombie","buy_zombie",0, "Transforms you into a zombie.")
	register_clcmd("say zombiehelp","zombiehelp",0, "Shows zombie help")
	register_clcmd("amx_zombiehelp","zombiehelp",0, "Shows zombie help")
	register_clcmd("amx_zombie","admin_zombie", ADMIN_KICK,"Client name or @T, @CT, @ALL")
	register_clcmd("nightvision","client_nightvision")
	////////////
	/////////EVENTS/////
	register_event("WeapPickup", "event_weap_pickup", "be", "1!29") // removes players picked up weapon
	register_event("Health", "zombiehealth", "b") // for zombies health
	register_event("Damage","event_damage_pain","be","2!0","3=0") // use for zombie pain sounds
	register_event("DeathMsg","event_DeathMsg","a"); // use the DeathMsg event to take away the zombie
	register_event("CurWeapon","event_CurWeapon","be"); // use the CurWeapon event to keep setting player's speed
	register_event("ResetHUD", "event_hud_reset", "be")
	register_clcmd("fullupdate", "clcmd_fullupdate") 
	register_event("TextMsg", "event_restart_attempt", "a", "2=#Game_will_restart_in")
	
	register_forward(FM_PlayerPreThink,"Client_PreThink")
	register_forward(FM_Touch,"fw_Touch");
	register_forward(FM_EmitSound, "fw_EmitSound" )
	
	register_logevent("event_roundstart", 2, "0=World triggered", "1=Round_Start")
	register_event("SendAudio", "event_twin", "a", "2&%!MRAD_terwin")
	register_event("SendAudio", "event_ctwin", "a", "2&%!MRAD_ctwin")
	register_logevent("event_roundend",2,"1=Game_Commencing")
	register_event("HLTV", "event_new_round", "a", "1=0", "2=0")
	/////////////////////
	/////////CVARS/////////
	z_cost = register_cvar("z_cost","16000") // cvar for cost
	z_health = register_cvar("z_health","500") // cvar for health
	z_armor = register_cvar("z_armor","0") // cvar for armor
	z_speed = register_cvar("z_speed","180.0") // cvar for speed
	z_gravity = register_cvar("z_gravity","0.5") // cvar for gravity
	z_buyable = register_cvar("z_buyable","1") // cvar for allowing you to buy zombieme
	z_glow = register_cvar("z_glow", "20") // cvar for turning glowing off or on 1 is on 0 is off
	z_arena = register_cvar("z_arena","0") 
	z_adminonly = register_cvar("z_adminonly","0")
	z_damage = register_cvar("z_damage","0")
	z_sounds = register_cvar("z_sounds","1")
	///////////////////
	///////////////STUFF////////////
	
	/////////////////////////////////////
	/////////////////////Server commands////////
	server_cmd("sv_maxspeed 99999") //needed for zombies speed
	server_cmd("mp_freezetime 0") //needed for zombies speed
	server_cmd("amx_restrict on shield") // zombies can buy shields so it needs to be restricted
	/////////////////////
}

public plugin_precache() {
	precache_model("models/v_claws.mdl") // zombie knife model
	precache_model("models/player/zombieme/zombieme.mdl") // zombie model
	precache_sound("scientist/c1a0_sci_catscream.wav") // scream
	
	new i
	for (i = 0; i < ZOMBIE_DEATH; i++)
		precache_sound(death_zombie[i])
	for (i = 0; i < ZOMBIE_PAIN; i++)
		precache_sound(pain_zombie[i]) // zombie pain sounds
	for (i = 0; i < ZOMBIE_IDLE; i++)
		precache_sound(idle_zombie[i])
	for (i = 0; i < ZOMBIE_MISS; i++)
		precache_sound(miss_zombie[i])
	
	for (i = 0; i < ZOMBIE_HIT; i++)
		precache_sound(hit_zombie[i])
	
}

public client_connect(id) {
	zombie[id] = false // reset the bool variable back to false on connect
	nightvision[id] = false
	set_task(20.0, "client_connected_msg", id)
}

public client_connected_msg(id) {
	if(get_cvar_num("z_buyable") == 1) {
		client_print(id,print_chat,"[AMXX] This server is running ZombieMe VERSION [%s] (c)", VERSION)
		if(get_cvar_num("z_adminonly") == 0) // if adminonly is set to 1
		{
			client_print(id,print_chat,"[ZOMBIE] Type /zombieme to turn into a zombie!")
		}
	}
}


public buy_zombie(id) {
	if(get_pcvar_num(z_adminonly) == 1) // if adminonly is set to 1
	{
		if (get_user_flags(id) & ADMIN_KICK) //only for admins with kick
		{
			zombie[id] = true;
			////////////////////HUD RANDOM COLOR//////////////////////////////////////////////////
			new num1 = random_num(150,255)
			new num2 = random_num(150,255)
			new num3 = random_num(150,255)
			set_hudmessage(num1, num2, num3, 0.07, 0.49 , 0, 6.0, 12.0)
			new Name[32]
			get_user_name(id, Name, 31)
			show_hudmessage(0, "[ZOMBIE] ADMIN %s IS A ZOMBIE OMG!!!", Name)
			client_print(id,print_chat,"[ZOMBIE] You have drank the ZOMBIE formula you are now transformaing into one! ")
			client_print(0,print_chat,"[ZOMBIE] You Must kill the zombie for it to go back to normal!")
			client_print(id,print_console,"[ZOMBIE] You have drank the ZOMBIE formula you are now transformaing into one! ")
			////////////////////////////////////////////////////////////////////////////////////////////
			///////////////////ZOMBIE SCREAM////////////////////////////////////////////////////////////
			emit_sound(id, CHAN_VOICE, "scientist/c1a0_sci_catscream.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
			////////////////////////////////////////////////////////////////////////////////////////////
			event_player_spawn(id)
			return PLUGIN_HANDLED
		}
		else
		{
			client_print(id,print_chat,"[ZOMBIE] ZombieMe has been set to admin only.")
			return PLUGIN_HANDLED
		}
	}
	if (!get_pcvar_num(z_buyable)) {
		client_print(0,print_chat,"[ZOMBIE] Sorry ZOMBIE ME has been turned off by the a admin.")
		return PLUGIN_HANDLED
	}
	if(!is_user_alive(id))
	{
		client_print(id,print_chat,"[ZOMBIE] You must be alive.")
		return PLUGIN_HANDLED
	}
	if(zombie[id])
	{
		client_print(id, print_chat, "[AMXX] You Are allready a zombie!")
		return PLUGIN_HANDLED
	}
	if((cs_get_user_money(id) - get_pcvar_num(z_cost)) < 0) // check if the player has enough cash
	{
		client_print(id,print_chat,"[ZOMBIE] Sorry you do not have enough money. You need $%d", get_cvar_num("z_cost"))
		client_print(id,print_console,"[ZOMBIE] Sorry you do not have enough money to transform into a zombie")
		return PLUGIN_HANDLED
	}
	if(get_pcvar_num(z_arena))
	{
		client_print(id,print_chat,"[ZOMBIE] Sorry Zombie Arena is enabled, You cant buy ZombieMe")
		return PLUGIN_HANDLED
	}
	zombie[id] = true;
	////////////////////HUD RANDOM COLOR//////////////////////////////////////////////////
	new num1 = random_num(150,255)
	new num2 = random_num(150,255)
	new num3 = random_num(150,255)
	set_hudmessage(num1, num2, num3, 0.07, 0.49 , 0, 6.0, 12.0)
	new Name[32]
	get_user_name(id, Name, 31)
	show_hudmessage(0, "[ZOMBIE] %s IS A ZOMBIE OMG!!!", Name)
	client_print(id,print_chat,"[ZOMBIE] You have drank the ZOMBIE formula you are now transformaing into one! ")
	client_print(0,print_chat,"[ZOMBIE] You Must kill the zombie for it to go back to normal!")
	client_print(id,print_console,"[ZOMBIE] You have drank the ZOMBIE formula you are now transformaing into one! ")
	////////////////////////////////////////////////////////////////////////////////////////////
	///////////////////ZOMBIE SCREAM////////////////////////////////////////////////////////////
	emit_sound(id, CHAN_VOICE, "scientist/c1a0_sci_catscream.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
	////////////////////////////////////////////////////////////////////////////////////////////
	event_player_spawn(id)
	cs_set_user_money(id,cs_get_user_money(id) - get_pcvar_num(z_cost))
	return PLUGIN_CONTINUE
}

public clcmd_fullupdate() {
	return PLUGIN_HANDLED_MAIN
}

public event_restart_attempt() {
	new players[32], num
	get_players(players, num, "a")
	for (new i; i < num; ++i)
		g_restart_attempt[players[i]] = true
}

public event_hud_reset(id) {
	if (g_restart_attempt[id]) {
		g_restart_attempt[id] = false
		return
	}
	new freeze = get_cvar_num("mp_freezetime")
	
	set_task(freeze + 0.3,"event_player_spawn",id)
	if(get_cvar_num("z_arena") == 1 ) {
		zombie_arena(id)
	}
	if(get_cvar_num("z_arena") == 2) {
		zombie_arena(id)
	}
}


public event_player_spawn(id) {
	
	if(zombie[id]) // check if the player has zombie
	{
		set_task(0.1, "RemovePickedWeapon", id) //removes zombies guns
		set_user_health(id, get_pcvar_num(z_health))
		set_user_armor(id, get_pcvar_num(z_armor))
		//set_user_maxspeed(id, get_pcvar_float(z_speed))
		set_user_gravity(id, get_pcvar_float(z_gravity)) // needs to be a float (0.5 is 400 gravity)
		set_user_footsteps(id,1)
		if (roundstatus == RS_RUNNING)
			cs_set_user_model(id, "zombieme")
		cs_set_user_nvg(id,0)
		zombiesounds(id)
		zombiehealth(id)
		set_vision(id)
		set_glow(id)
		if(get_cvar_num("z_arena") == 0) {
			emit_sound(id, CHAN_VOICE, "scientist/c1a0_sci_catscream.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
			new name[32]
			get_user_name(id, name, 31)
			client_print(0,print_chat,"[ZOMBIE] AHHH %s IS A ZOMBIE OMG!!",name)
		}
		return PLUGIN_CONTINUE 
	}
	cs_reset_user_model(id)
	set_user_footsteps(id,0)
	set_user_rendering(id)
	return PLUGIN_CONTINUE
}


public event_weap_pickup(id) {
	if(zombie[id]) {
		set_task(0.1, "RemovePickedWeapon", id)
	}
	return PLUGIN_HANDLED
}

public RemovePickedWeapon(id) {
	if(!is_user_alive(id) || !is_user_connected(id)) 
		return PLUGIN_CONTINUE
		
	if(zombie[id])
	{
		engclient_cmd(id, "drop", "weapon_c4")
		strip_user_weapons(id)
		give_item(id,"weapon_knife")
		if(g_speed)
			set_user_maxspeed(id, get_pcvar_float(z_speed))
	}
	return PLUGIN_HANDLED
} 

public fw_Touch(pToucher, pTouched)
{
	if ( !pev_valid(pToucher) || !pev_valid(pTouched) )
		return FMRES_IGNORED
	
	if (!is_user_connected(pTouched) )
		return FMRES_IGNORED
	
	if (!zombie[pTouched] )
		return FMRES_IGNORED
	
	new className[32]
	pev(pToucher, pev_classname, className, 31)
	
	if ( equal(className, "weaponbox") || equal(className, "armoury_entity" ) || equal(className, "weapon_shield" ) )
		return FMRES_SUPERCEDE
	
	return FMRES_IGNORED
}  

public zombiehealth(id) {
	if(!is_user_alive(id) && !is_user_connected(id)) {
		return PLUGIN_CONTINUE
	}
	if(zombie[id])
	{
		new id = read_data(0)
		new health = read_data(1)
		set_hudmessage(255, 255, 255, 0.11, 0.78, 2, 0.05, 1000.0, 0.01, 3.0, 1)
		show_hudmessage(id, "Health:  %d  ", health)
	}
	return PLUGIN_CONTINUE
}

public event_DeathMsg() { // remove zombie after death
	if(get_cvar_num("z_arena")) {
		return PLUGIN_CONTINUE
	}
	new id
	id = read_data(2)
	set_task(1.0,"Remove_zombie",id)
	return PLUGIN_CONTINUE
}

public Remove_zombie(id)
		zombie[id] = false

public event_CurWeapon(id) { // set player's maxspeed continuously
	if(is_user_alive(id) && zombie[id]) {
		if(g_speed)
			set_user_maxspeed(id, get_pcvar_float(z_speed))
		
		set_vision(id)
	}
}
public event_damage_pain(id) {
	new damage = read_data(2)
	new bodypart, weapon
	new enemy = get_user_attacker(id, weapon, bodypart)
	if ( zombie[id] )
	{
		emit_sound(id, CHAN_VOICE, pain_zombie[random_num(0, ZOMBIE_PAIN - 1)], 1.0, ATTN_NORM, 0, PITCH_NORM)
	} 
	if(zombie[enemy] && weapon == CSW_KNIFE && is_user_alive(id))
	{
		new Xdamage = floatround(float(get_user_health(id)) - (float(damage) + get_pcvar_float(z_damage)))
		if(Xdamage < 1)
		{
			set_msg_block(get_user_msgid("DeathMsg"),BLOCK_ONCE)
			message_begin(MSG_ALL, get_user_msgid("DeathMsg"), {0, 0, 0}, 0)
			write_byte(enemy)
			write_byte(id)
			write_byte(0)
			write_string("knife")
			message_end()
			new frags, deaths
			frags = get_user_frags(enemy) + 1
			set_user_frags(enemy, frags)
			deaths = cs_get_user_deaths(id) + 1
			cs_set_user_deaths(id, deaths)
			frags = get_user_frags(id) + 1
			set_user_frags(id, frags)
		}
		set_user_health(id, Xdamage)
	}
	return PLUGIN_CONTINUE
}

public set_vision(id) {
	
	message_begin(MSG_ONE, get_user_msgid("ScreenFade"), {0,0,0}, id)
	write_short(~0)
	write_short(~0)
	write_short(0)
	write_byte(255)
	write_byte(0)
	write_byte(0)
	write_byte(80)
	message_end()
	set_pev(id, pev_viewmodel, engfunc(EngFunc_AllocString, "models/v_claws.mdl"))
	set_pev(id, pev_weaponmodel, engfunc(EngFunc_AllocString, ""))
	
}

public set_glow(id) {
	
	if(!get_cvar_num("z_glow")) {
		return PLUGIN_CONTINUE
	}
	new CsTeams:team = cs_get_user_team(id)
	if(team == CS_TEAM_T) //terrist
	{ 
		set_user_rendering(id, kRenderFxGlowShell, 150, 0, 0, kRenderNormal, get_pcvar_num(z_glow))
	} 
	
	else if(team == CS_TEAM_CT) //counter-terrist
	{ 
		set_user_rendering(id, kRenderFxGlowShell, 0, 0, 150, kRenderNormal, get_pcvar_num(z_glow))
	} 
	
	return PLUGIN_CONTINUE
} 

public zombiehelp(id) {
	client_print(id,print_chat,"")
	client_print(id,print_chat,"")
	client_print(id,print_chat,"")
	client_print(id,print_chat,"")
	client_print(id,print_chat,"[ZOMBIE] Your help is in the console.")
	client_print(id,print_console,"VERSION (c) %s", VERSION)
	client_print(id,print_console,"")
	client_print(id,print_console,"")
	client_print(id,print_console,"")
	client_print(id,print_console,"")
	client_print(id,print_console,"")
	client_print(id,print_console,"")
	client_print(id,print_console,"")
	client_print(id,print_console,"///////////////////////////////Zombie Me By Purple Nurple (Jesse) (C) 2007/////////")
	client_print(id,print_console,"/////////////////Cvars///////////////////////////////////////")
	client_print(id,print_console,"z_speed (420 default) changes zombies speed")
	client_print(id,print_console,"z_cost (16000 default) changes zombies cost")
	client_print(id,print_console,"z_health (1300 default) changes zombies health")
	client_print(id,print_console,"z_armor (200 default) changes zombies armor")
	client_print(id,print_console,"z_gravity (0.5 default) 1.0 normal changes gravity")
	client_print(id,print_console,"z_glow (1 default) 1 on 0 off make zombies glow")
	client_print(id,print_console,"z_buyable (1 default) 1 on 0 off if people can buy zombie")
	client_print(id,print_console,"z_arena (0 default) 1 on 0 off turns cts to zombies and t stay normal")
	client_print(id,print_console,"z_adminonly (0 default) 1 on 0  off if only admins can be zombies")
	client_print(id,print_console,"z_damage (20 default) adds damage to zombies knife")
	client_print(id,print_console,"")
	client_print(id,print_console,"////////////////////Commands////////////////////////////////////")
	client_print(id,print_console,"")
	client_print(id,print_console,"say /zombieme")
	client_print(id,print_console,"say zombieme")
	client_print(id,print_console,"team_say /zombieme")
	client_print(id,print_console,"team_say zombieme")
	client_print(id,print_console,"amx_zombiehelp")
	client_print(id,print_console,"amx_zombie to turn someone into a zombie")
	client_print(id,print_console,"/////////////////current cvars//////////////////////////////////")
	client_print(id,print_console,"z_speed %d",get_pcvar_num(z_speed))
	client_print(id,print_console,"z_cost %d",get_pcvar_num(z_cost))
	client_print(id,print_console,"z_health %d",get_pcvar_num(z_health))
	client_print(id,print_console,"z_armor %d",get_pcvar_num(z_armor))
	client_print(id,print_console,"z_gravity %s",get_pcvar_float(z_gravity))
	client_print(id,print_console,"z_glow %d",get_pcvar_num(z_glow))
	client_print(id,print_console,"z_buyable %d",get_pcvar_num(z_buyable))
	client_print(id,print_console,"z_arena %d",get_pcvar_num(z_arena))
	client_print(id,print_console,"z_adminonly %d",get_pcvar_num(z_adminonly))
	client_print(id,print_console,"z_damage %d",get_pcvar_num(z_damage))
	client_print(id,print_console,"////////////////////////////////////////////////////////////////")
	client_print(id,print_console,"")
	client_print(id,print_console,"YOU MUST KILL THE ZOMBIE HIM TO GO BACK TO NORMAL")
	client_print(id,print_console,"")
	client_print(id,print_console,"")
	client_print(id,print_console,"///////////////////////////////////////////////////////////////////////////////////")
}


public zombie_arena(id)
	if (get_cvar_num("z_arena") == 1) {
	client_print(id,print_chat,"[ZOMBIE] Zombie ARENA !ON! CTS ARE ZOMBIES")
	new CsTeams:team = cs_get_user_team(id)
	if(team == CS_TEAM_T) //terrist
	{ 
		zombie[id] = false
	} 
	else if(team == CS_TEAM_CT) //counter-terrist
	{ 
		zombie[id] = true
		event_player_spawn(id)
	}
	}else if (get_cvar_num("z_arena") == 2) {
	client_print(id,print_chat,"[ZOMBIE] Zombie ARENA !ON! TS ARE ZOMBIES")
	new CsTeams:team = cs_get_user_team(id)
	if(team == CS_TEAM_T) //terrist
	{ 
		zombie[id] = true
		event_player_spawn(id)
	} 
	else if(team == CS_TEAM_CT) //counter-terrist
	{ 
		zombie[id] = false	
	}
}

public admin_zombie(id,level,cid)
{
	if (!cmd_access(id,level,cid,2))
		return PLUGIN_HANDLED
	new arg[32]
	new aName[32], aAuthid[36], pAuthid[36]
	read_argv(1,arg,31)
	
	get_user_name(id,aName,31)
	get_user_authid(id,aAuthid,35)
	
	if (arg[0]=='@'){
		new plist[32], pnum
		if (equali("T",arg[1]))		copy(arg[1],31,"TERRORIST")
		if (equali("ALL",arg[1]))	get_players(plist,pnum)
		else						get_players(plist,pnum,"ae",arg[1])
		
		if (pnum == 0) {
			console_print(id,"[zombie] NO PLAYERS FOUND")
			return PLUGIN_HANDLED
		}
		
		for(new i=0; i<pnum; i++) {
			if (!(get_user_flags(plist[i])&ADMIN_KICK))
			{
				new ids[3]
				num_to_str(plist[i],ids,2)
				
				zombie[plist[i]] = true
				event_player_spawn(plist[i])
				client_print(plist[i],print_chat,"[ZOMBIE] %s has turned %s into zombies!",aName,arg[31])
			}
		}
		
	}
	else
	{
		new pName[32],player = cmd_target(id,arg,3)
		if (!player) return PLUGIN_HANDLED
		new ids[3]
		get_user_name(player,pName,31)
		get_user_authid(player,pAuthid,35)
		num_to_str(player,ids,2)
		if(!zombie[player] && is_user_alive(player))
		{
			zombie[player] = true
			event_player_spawn(player)
			client_print(0,print_chat,"[ZOMBIE] %s has been turned into a zombie by %s",pName,aName)
			return PLUGIN_HANDLED
		}
		if(zombie[player] && is_user_alive(player))
		{
			zombie[player] = false
			give_item(player,"weapon_usp")
			engclient_cmd(player,"weapon_usp")
			engclient_cmd(player,"weapon_knife")
			event_player_spawn(player)
			client_print(0,print_chat,"[ZOMBIE] %s has been turned BACK to human by %s",pName,aName)
			return PLUGIN_HANDLED
		}
		
	}
	return PLUGIN_HANDLED
}

public event_roundstart(id) 
	roundstatus = RS_RUNNING

public event_new_round(id) 
{
	g_speed = false
	new freeze = get_cvar_num("mp_freezetime") 
	set_task(float(freeze) + 0.1,"allow_speed")
}

public allow_speed() 
{
	g_speed = true
	new players[32], num, i
	get_players(players, num)
	for (i = 0 ; i < num; i++)
		if(zombie[players[i]])
		set_user_maxspeed(players[i], (get_pcvar_float(z_speed)))
	return PLUGIN_CONTINUE
}

public event_twin()
	set_task(1.0, "event_roundend")

public event_ctwin() 
	set_task(1.0, "event_roundend")

public event_roundend() {	
	roundstatus = RS_END
	new players[32], count
	get_players(players, count, "h")
	for(new i = 0; i < count; i++)
	{
		if(zombie[players[i]])
			cs_reset_user_model(players[i])
	}
	return
}

public zombiesounds(id)
{
	if (roundstatus == RS_RUNNING && get_pcvar_num(z_sounds))
	{
		if (random_num(1, 35) == 5 && zombie[id]) {
			if(is_user_alive(id))
				emit_sound(id, CHAN_VOICE, idle_zombie[random_num(0, ZOMBIE_IDLE-1)], 1.0, ATTN_NORM, 0, PITCH_NORM)
		}
	}
	if(zombie[id])
		set_task(1.0,"zombiesounds",id)
}

public Client_PreThink(id) {			
	
	if(zombie[id] && is_user_alive(id) && nightvision[id]) {
		new pos[3]
		get_user_origin(id, pos)
		message_begin(MSG_ONE, SVC_TEMPENTITY, {0,0,0}, id)
		write_byte(TE_DLIGHT)
		write_coord(pos[0])
		write_coord(pos[1])
		write_coord(pos[2])
		write_byte(80)
		write_byte(50)
		write_byte(0)
		write_byte(0)
		write_byte(5)
		write_byte(10)
		message_end()
	}
	return PLUGIN_CONTINUE
}

public client_nightvision(id)
{
	
	if(nightvision[id])
	{
		client_print(0,print_chat,"nightvision off")
		nightvision[id] = false
		return PLUGIN_HANDLED
	}
	if(!nightvision[id])
	{
		client_print(0,print_chat,"nightvision on")
		nightvision[id] = true
	}
	return PLUGIN_CONTINUE
}

public fw_EmitSound(id, channel, sample[])
{
	if(sample[0] == 'p' && sample[1] == 'l'&& sample[7] == 'd' && zombie[id])
	{
		emit_sound(id, CHAN_WEAPON,  death_zombie[random_num(0, ZOMBIE_DEATH - 1)], VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		return FMRES_SUPERCEDE	
	}
	
	if ( !is_user_alive(id) || !zombie[id] )
		return FMRES_IGNORED
	
	if ( sample[0] == 'w' && sample[1] == 'e' && sample[8] == 'k' && sample[9] == 'n' )
	{
		switch(sample[17])
		{
			case 'l': return FMRES_SUPERCEDE
				
			case 's', 'w':
			{				
				emit_sound(id, CHAN_WEAPON, miss_zombie[random_num(0, ZOMBIE_MISS - 1)], VOL_NORM, ATTN_NORM, 0, PITCH_NORM)	
				return FMRES_SUPERCEDE
			}
			
			case 'b', '1', '2', '3', '4':
			{
				emit_sound(id, CHAN_WEAPON, hit_zombie[random_num(0, ZOMBIE_HIT - 1)], VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
				return FMRES_SUPERCEDE
			}
		}
	}
	
	
	return FMRES_IGNORED
}
