/* Terminator Mod
* Version 1.0
*
* Players become a terminator and they will be powerful.
*
* Based on the movie, Terminator 3
*/

#include <amxmodx>
#include <amxmisc>
#include <fun>
#include <engine>
#include <cstrike>

#define PLUGIN "Terminator Mod"
#define VERSION "1.0"
#define AUTHOR "pcboy"

new Terminator[33]

public plugin_init() {
	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_cvar("ter_enable", "1") // Enable or disable this plugin
	register_cvar("ter_on_extra_hp", "1") // On or off extra hp
	register_cvar("ter_extra_hp", "50") // Extra Hp, don't change too much, or overflows
	register_cvar("ter_fast", "1") // Boost
	register_cvar("ter_gravity", "1") // Change gravity to 400
	register_cvar("ter_colourscreen", "1") // Fade to make you like you are a terminator
	register_cvar("ter_model", "1") // 1 = T-101, 2 = T-X
	register_cvar("ter_removebomb", "1") // Remove bombsite to make the game looks more like Terminator 3
	register_cvar("ter_changemdl", "1") // Change user's model, please change the map if want to disable it
	register_event("ResetHUD", "event_ResetHud", "be")
	register_event("CurWeapon", "event_CurWeapon", "be")
}

public plugin_precache() {
	if(!get_cvar_num("ter_enable")) return PLUGIN_HANDLED
	if(!get_cvar_num("ter_changemdl")) return PLUGIN_HANDLED
	precache_model("models/player/terminator/terminator.mdl")
	return PLUGIN_HANDLED
}

public event_ResetHud(id) {
	if(!get_cvar_num("ter_enable")) return PLUGIN_HANDLED
	set_task(1.0, "Ter", id)
	set_task(1.0, "remove_bomb", id)
	return PLUGIN_CONTINUE
}

public client_connect(id){
	client_print(id, print_console, "Terminator Mod is enabled on this server, enjoy")
	Terminator[id] = 1
}

public client_disconnect(id){
	Terminator[id] = 0
}

public event_CurWeapon(id) {
	if(get_cvar_num("ter_fast") == 1)
	{
		set_user_maxspeed(id, 400.0)
	}
	return PLUGIN_CONTINUE
}

public Ter(id) {
	if(Terminator[id] == 0 && !get_cvar_num("ter_enable") && !is_user_alive(id)) return PLUGIN_HANDLED
	
	if(get_cvar_num("ter_changemdl") == 1) {
		cs_set_user_model(id, "terminator")
	}
	
	if(get_cvar_num("ter_colourscreen") == 1) {
		set_task(0.1, "fade", id)
	}
	
	if(get_cvar_num("ter_on_extra_hp") == 1) {
		if(get_cvar_num("ter_extra_hp") < 0) {
			set_cvar_num("ter_extra_hp", 50)
		}
		
		if(get_cvar_num("ter_model") == 1) {
			new myHp = get_user_health(id)
			new extraHp = get_cvar_num("ter_extra_hp")
			new newHp = myHp + extraHp
			
			set_user_health(id, newHp)
		}
		
		if(get_cvar_num("ter_model") == 2) {
			new myHp = get_user_health(id)
			new extraHp = get_cvar_num("ter_extra_hp")
			new newHp = myHp + extraHp * 2
			
			set_user_health(id, newHp)
		}
	}

	if(get_cvar_num("ter_fast") == 1) {
		set_user_maxspeed(id, 400.0)
	}
	
	if(get_cvar_num("ter_gravity") == 1) {
		set_user_gravity(id, 0.5)
	}
	return PLUGIN_HANDLED
}

public fade(id) {
	if(Terminator[id] == 0 && !get_cvar_num("ter_enable") && !is_user_alive(id)) return PLUGIN_HANDLED
	if(!get_cvar_num("ter_colourscreen")) return PLUGIN_HANDLED
	if(get_cvar_num("ter_model") == 1) {
		message_begin(MSG_ONE, get_user_msgid("ScreenFade"), {0,0,0}, id)
		write_short(~0)
		write_short(~0)
		write_short(1<<12)
		write_byte(255)
		write_byte(0)
		write_byte(0)
		write_byte(40)
		message_end()
		set_task(1.0,"fade",id)
		return PLUGIN_HANDLED
	}
	
	if(get_cvar_num("ter_model") == 2) {
		message_begin(MSG_ONE, get_user_msgid("ScreenFade"), {0,0,0}, id)
		write_short(~0)
		write_short(~0)
		write_short(1<<12)
		write_byte(0)
		write_byte(0)
		write_byte(255)
		write_byte(40)
		message_end()
		set_task(1.0,"fade",id)
		return PLUGIN_HANDLED
	}
	return PLUGIN_HANDLED
}

public remove_bomb(id) {
	if(Terminator[id] == 0 && !get_cvar_num("ter_enable") && !is_user_alive(id)) return PLUGIN_HANDLED
	if(!get_cvar_num("ter_removebomb")) return PLUGIN_HANDLED
	
	new func_bomb = find_ent_by_class(-1, "func_bomb_target")
	while(func_bomb > get_maxplayers()) { // entity would have a higher index than last player
		entity_set_int(func_bomb, EV_INT_flags, FL_KILLME) // special flag setting to remove an entity
		func_bomb = find_ent_by_class(func_bomb, "func_bomb_target")
	} 
	new info_bomb = find_ent_by_class(-1, "info_bomb_target")
	while(info_bomb > get_maxplayers()) { // entity would have a higher index than last player
		entity_set_int(func_bomb, EV_INT_flags, FL_KILLME) // special flag setting to remove an entity
		info_bomb = find_ent_by_class(info_bomb, "info_bomb_target")
	}
	return PLUGIN_HANDLED
}